/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.ui.launchview.internal.AbstractLaunchObjectProvider;
import org.eclipse.debug.ui.launchview.internal.LaunchViewMessages;
import org.eclipse.debug.ui.launchview.internal.impl.DebugCoreLaunchObject;
import org.eclipse.debug.ui.launchview.services.ILaunchObject;
import org.eclipse.debug.ui.launchview.services.ILaunchObjectProvider;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ILaunchObjectProvider.class})
public class DebugCoreProvider
extends AbstractLaunchObjectProvider
implements ILaunchObjectProvider,
ILaunchConfigurationListener,
ILaunchesListener2 {
    private final ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();

    @Activate
    public void createService() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    @Deactivate
    public void destroyService() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    public Set<ILaunchObject> getLaunchObjects() {
        try {
            return Arrays.stream(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations()).map(DebugCoreLaunchObject::new).collect(Collectors.toCollection(TreeSet::new));
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error(LaunchViewMessages.DebugCoreProvider_FailedLookup, (Throwable)e);
            return Collections.emptySet();
        }
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        this.fireUpdate();
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        this.fireUpdate();
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        this.fireUpdate();
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
        this.fireUpdate();
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.fireUpdate();
    }

    @Override
    public void contributeViewMenu(Supplier<Set<ILaunchObject>> selected, MMenu menu) {
    }

    @Override
    public void contributeContextMenu(final Supplier<Set<ILaunchObject>> selected, MMenu menu) {
        MDirectMenuItem cleanup = MMenuFactory.INSTANCE.createDirectMenuItem();
        cleanup.setLabel(LaunchViewMessages.DebugCoreProvider_delete);
        cleanup.setTooltip(LaunchViewMessages.DebugCoreProvider_deleteHint);
        cleanup.setIconURI("platform:/plugin/org.eclipse.debug.ui.launchview/icons/remove_exc.png");
        cleanup.setObject(new Object(){

            @Execute
            public void cleanup() throws CoreException {
                for (ILaunchObject e : (Set)selected.get()) {
                    DebugCoreProvider.this.findLaunchConfiguration(e.getType(), e.getId()).delete();
                }
                DebugCoreProvider.this.fireUpdate();
            }

            @CanExecute
            public boolean isEnabled() {
                return ((Set)selected.get()).stream().allMatch(e -> e instanceof DebugCoreLaunchObject && DebugCoreProvider.this.findLaunchConfiguration(e.getType(), e.getId()) != null);
            }
        });
        menu.getChildren().add(MMenuFactory.INSTANCE.createMenuSeparator());
        menu.getChildren().add(cleanup);
    }

    ILaunchConfiguration findLaunchConfiguration(ILaunchConfigurationType type, String name) {
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = this.manager.getLaunchConfigurations(type);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getName().equals(name)) {
                    return config;
                }
                ++n2;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(LaunchViewMessages.DebugCoreProvider_cannotFetchError, e);
        }
    }
}

