/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.CommandReplyWithVars;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.EventWithVars;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.PCFragment;
import org.eclipse.comma.actions.actions.PCFragmentDefinition;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.actions.utilities.ActionsUtilities;
import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.InAllStatesBlock;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.component.utilities.BehaviorFragment;
import org.eclipse.comma.behavior.component.utilities.ClauseFragments;
import org.eclipse.comma.behavior.component.utilities.FunctionFragmentCall;
import org.eclipse.comma.behavior.component.utilities.IfHelperAction;
import org.eclipse.comma.behavior.component.utilities.StateTransitionAction;
import org.eclipse.comma.behavior.component.utilities.TransitionDecomposer;
import org.eclipse.comma.behavior.component.utilities.TransitionFragment;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.monitoring.generator.ConstraintsRulesGenerator;
import org.eclipse.comma.monitoring.generator.TypesJavaGenerator;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.signature.utilities.InterfaceUtilities;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class InterfaceDecisionGenerator
extends ConstraintsRulesGenerator {
    protected Signature signature;
    protected Map<InterfaceEvent, StateMachine> event2Machine;
    protected Map<Clause, String> clause2Method;
    protected Map<TriggeredTransition, String> transition2Method;
    private Map<StateMachine, List<InterfaceEvent>> eventPartitions;
    private Map<Transition, Map<Clause, ClauseFragments>> clauseFragments;
    private Map<Variable, String> triggerVariables;

    public InterfaceDecisionGenerator(Signature signature, Interface behavior, IFileSystemAccess fsa) {
        super((AbstractBehavior)behavior, fsa);
        this.signature = signature;
    }

    public void generateUtilityClass() {
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(ConstraintsRulesGenerator.utilityClassName(this.signature).toString()), this.generateUtilityClassContent(this.behavior));
    }

    public void generateDecisionClass() {
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(InterfaceDecisionGenerator.decisionClassName(this.signature).toString()), this.generateDecisionClassContent());
    }

    protected CharSequence generateUtilityClassContent(AbstractBehavior intdef) {
        boolean _not;
        boolean bl;
        Object _name_9;
        StringConcatenation _xblockexpression = null;
        EList machines = intdef.getMachines();
        HashMap<Variable, String> _hashMap = new HashMap<Variable, String>();
        this.triggerVariables = _hashMap;
        this.clauseFragments = this.populateClauseFragments(intdef);
        this.quantifiersInMachines = this.getQuantifiersInStateMachines(intdef, (List<StateMachine>)machines);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.LinkedHashMap;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CState;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".utils.Utils;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _utilityClassName = ConstraintsRulesGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName);
        _builder.append(" extends CState {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/* global variables from the spec */");
        _builder.newLine();
        EList _vars = intdef.getVars();
        for (Variable variable : _vars) {
            _builder.append("\t");
            _builder.append("private ");
            CharSequence _javaType = this.toJavaType((EObject)variable.getType());
            _builder.append((Object)_javaType, "\t");
            _builder.append(" ");
            _builder.append("commaVar_", "\t");
            String _name = variable.getName();
            _builder.append(_name, "\t");
            _builder.append(" = ");
            CharSequence _defaultValue = this.defaultValue((EObject)variable.getType());
            _builder.append((Object)_defaultValue, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* trigger variables */");
        _builder.newLine();
        Set<Variable> _keySet = this.triggerVariables.keySet();
        for (Variable variable : _keySet) {
            _builder.append("\t");
            _builder.append("private ");
            CharSequence _javaType_1 = this.toJavaType((EObject)variable.getType());
            _builder.append((Object)_javaType_1, "\t");
            _builder.append(" ");
            _builder.append("commaVar_", "\t");
            String _get = this.triggerVariables.get(variable);
            _builder.append(_get, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* variables for current state in machines */");
        _builder.newLine();
        for (StateMachine sm : machines) {
            _builder.append("\t");
            _builder.append("private String ");
            Iterator<Variable> _name_1 = sm.getName();
            _builder.append((String)((Object)_name_1), "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* getters and setters for global variables */");
        _builder.newLine();
        EList _vars_1 = intdef.getVars();
        for (Variable variable : _vars_1) {
            _builder.append("\t");
            _builder.append("public ");
            CharSequence _javaType_2 = this.toJavaType((EObject)variable.getType());
            _builder.append((Object)_javaType_2, "\t");
            _builder.append(" get_");
            _builder.append("commaVar_", "\t");
            String _name_2 = variable.getName();
            _builder.append(_name_2, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            _builder.append("commaVar_", "\t\t");
            String _name_3 = variable.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void set_");
            _builder.append("commaVar_", "\t");
            String _name_4 = variable.getName();
            _builder.append(_name_4, "\t");
            _builder.append("(");
            CharSequence _javaType_3 = this.toJavaType((EObject)variable.getType());
            _builder.append((Object)_javaType_3, "\t");
            _builder.append(" p) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("commaVar_", "\t\t");
            String _name_5 = variable.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append(" = p;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("/* getters and setters for trigger variables */");
        _builder.newLine();
        Set<Variable> _keySet_1 = this.triggerVariables.keySet();
        for (Variable variable : _keySet_1) {
            _builder.append("\t");
            _builder.append("public ");
            CharSequence _javaType_4 = this.toJavaType((EObject)variable.getType());
            _builder.append((Object)_javaType_4, "\t");
            _builder.append(" get_");
            _builder.append("commaVar_", "\t");
            String _get_1 = this.triggerVariables.get(variable);
            _builder.append(_get_1, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("    ");
            _builder.append("return ");
            _builder.append("commaVar_", "\t    ");
            String _get_2 = this.triggerVariables.get(variable);
            _builder.append(_get_2, "\t    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void set_");
            _builder.append("commaVar_", "\t");
            String _get_3 = this.triggerVariables.get(variable);
            _builder.append(_get_3, "\t");
            _builder.append("(");
            CharSequence _javaType_5 = this.toJavaType((EObject)variable.getType());
            _builder.append((Object)_javaType_5, "\t");
            _builder.append(" p) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("    ");
            _builder.append("commaVar_", "\t    ");
            String _get_4 = this.triggerVariables.get(variable);
            _builder.append(_get_4, "\t    ");
            _builder.append(" = p;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("/* getters and setter for variables that hold current state */");
        _builder.newLine();
        for (StateMachine sm_1 : machines) {
            _builder.append("\t");
            _builder.append("public String get_");
            String _name_6 = sm_1.getName();
            _builder.append(_name_6, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            String _name_7 = sm_1.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void set_");
            String _name_8 = sm_1.getName();
            _builder.append(_name_8, "\t");
            _builder.append("(String p) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if(!");
            _name_9 = sm_1.getName();
            _builder.append((String)_name_9, "\t\t");
            _builder.append(".equals(p)){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("activeStates.remove(");
            String _name_10 = sm_1.getName();
            _builder.append(_name_10, "\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("activeStates.add(p);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _name_11 = sm_1.getName();
            _builder.append(_name_11, "\t\t");
            _builder.append(" = p;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        int _size = this.quantifiersInMachines.size();
        boolean bl2 = bl = _size > 0;
        if (bl) {
            _builder.append("\t");
            _builder.append("/* methods that implement quantifiers */");
            _builder.newLine();
            for (ExpressionQuantifier quantifier : this.quantifiersInMachines) {
                _builder.append("\t");
                CharSequence _generateQuantifierMethod = this.generateQuantifierMethod(quantifier, this.quantifiersInMachines.indexOf(quantifier));
                _builder.append((Object)_generateQuantifierMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("/* constructor that performs initialization */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _utilityClassName_1 = ConstraintsRulesGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("/* initialization of the set with active states of the state machines */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("activeStates = new HashSet<String>();");
        _builder.newLine();
        Functions.Function1<StateMachine, EList<State>> function1 = new Functions.Function1<StateMachine, EList<State>>(){

            public EList<State> apply(StateMachine it) {
                return it.getStates();
            }
        };
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return s.isInitial();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)machines, (Functions.Function1)function1)), (Functions.Function1)_function_1);
        _name_9 = _filter.iterator();
        while (_name_9.hasNext()) {
            State s = (State)_name_9.next();
            _builder.append("\t\t");
            _builder.append("activeStates.add(\"");
            String _name_12 = s.getName();
            _builder.append(_name_12, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of global variables in model init section */");
        _builder.newLine();
        EList eList = intdef.getInitActions();
        for (Object a : eList) {
            _builder.append("\t\t");
            CharSequence _generateAction = this.generateAction((Action)a);
            _builder.append((Object)_generateAction, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initilization of current state variables */");
        _builder.newLine();
        for (StateMachine stateMachine : machines) {
            _builder.append("\t\t");
            String _name_13 = stateMachine.getName();
            _builder.append(_name_13, "\t\t");
            _builder.append(" = \"");
            Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

                public Boolean apply(State s) {
                    return s.isInitial();
                }
            };
            String _name_14 = ((State[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)stateMachine.getStates(), (Functions.Function1)_function_2), State.class))[0].getName();
            _builder.append(_name_14, "\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of the last execution state */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("executionState = \"\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of coverage info */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("clauseMap = new LinkedHashMap<String, Integer>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateMap = new LinkedHashMap<String, Integer>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        for (StateMachine stateMachine : machines) {
            EList _states = stateMachine.getStates();
            for (State s_1 : _states) {
                _builder.append("\t\t");
                _builder.append("stateMap.put(\"");
                String _name_15 = s_1.getName();
                _builder.append(_name_15, "\t\t");
                _builder.append("\", ");
                boolean _isInitial = s_1.isInitial();
                if (_isInitial) {
                    _builder.append("1");
                } else {
                    _builder.append("0");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                List allTransitionInState = StateMachineUtilities.transitionsForState((State)s_1);
                _builder.newLineIfNotEmpty();
                int _size_1 = allTransitionInState.size();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_1, true);
                for (Integer ti : _doubleDotLessThan) {
                    int _size_2 = ((Transition)allTransitionInState.get(ti)).getClauses().size();
                    ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _size_2, true);
                    for (Integer ci : _doubleDotLessThan_1) {
                        _builder.append("\t\t");
                        _builder.append("clauseMap.put(\"");
                        String _name_16 = s_1.getName();
                        _builder.append(_name_16, "\t\t");
                        _builder.append(" transition ");
                        _builder.append((Object)(ti + 1), "\t\t");
                        CharSequence _eventName = this.getEventName((Transition)allTransitionInState.get(ti), (Clause)((Transition)allTransitionInState.get(ti)).getClauses().get(ci.intValue()));
                        _builder.append((Object)_eventName, "\t\t");
                        _builder.append(" clause ");
                        _builder.append((Object)(ci + 1), "\t\t");
                        _builder.append("\", 0);");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* print method */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String toString() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("String result = \"Values of global variables and current machine states:\" + \"\\n\\n\";");
        _builder.newLine();
        boolean bl3 = intdef.getVars().isEmpty();
        boolean bl4 = _not = !bl3;
        if (_not) {
            EList _vars_2 = intdef.getVars();
            for (Variable v_4 : _vars_2) {
                _builder.append("\t\t");
                _builder.append("result = result + \"");
                String _name_17 = v_4.getName();
                _builder.append(_name_17, "\t\t");
                _builder.append(" = \" + ");
                _builder.append("commaVar_", "\t\t");
                String _name_18 = v_4.getName();
                _builder.append(_name_18, "\t\t");
                _builder.append(" + \"\\n\";");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append("\t\t");
            _builder.append("result = result + \"No global variables\" + \"\\n\";");
            _builder.newLine();
        }
        for (StateMachine stateMachine : machines) {
            _builder.append("\t\t");
            _builder.append("result = result + \"Machine ");
            String _name_19 = stateMachine.getName();
            _builder.append(_name_19, "\t\t");
            _builder.append(" in state \" + ");
            String _name_20 = stateMachine.getName();
            _builder.append(_name_20, "\t\t");
            _builder.append(" + \"\\n\";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public HashMap<Transition, Map<Clause, ClauseFragments>> populateClauseFragments(AbstractBehavior behavior) {
        Procedures.Procedure2<StateMachine, Transition> _function;
        HashMap<Transition, Map<Clause, ClauseFragments>> _xblockexpression = null;
        final HashMap<Transition, Map<Clause, ClauseFragments>> result = new HashMap<Transition, Map<Clause, ClauseFragments>>();
        int counter = 1;
        Procedures.Procedure2<StateMachine, Transition> lambda = _function = new Procedures.Procedure2<StateMachine, Transition>(){

            public void apply(StateMachine m, Transition t) {
                HashMap<Clause, ClauseFragments> clausesMap = new HashMap<Clause, ClauseFragments>();
                EList _clauses = t.getClauses();
                for (Clause c : _clauses) {
                    ClauseFragments fragments = TransitionDecomposer.decomposeTransition((StateMachine)m, (Transition)t, (Clause)c);
                    Consumer<Map.Entry<Variable, String>> _function = new Consumer<Map.Entry<Variable, String>>(){

                        @Override
                        public void accept(Map.Entry<Variable, String> it) {
                            (this).InterfaceDecisionGenerator.this.triggerVariables.put(it.getKey(), "");
                        }
                    };
                    fragments.getTriggerVariables().entrySet().forEach(_function);
                    clausesMap.put(c, fragments);
                }
                result.put(t, clausesMap);
            }
        };
        EList _machines = behavior.getMachines();
        for (StateMachine m : _machines) {
            Consumer<InAllStatesBlock> _function_1 = new Consumer<InAllStatesBlock>((Procedures.Procedure2)lambda, m){
                private final /* synthetic */ Procedures.Procedure2 val$lambda;
                private final /* synthetic */ StateMachine val$m;
                {
                    this.val$lambda = procedure2;
                    this.val$m = stateMachine;
                }

                @Override
                public void accept(InAllStatesBlock it) {
                    Consumer<Transition> _function = new Consumer<Transition>(){

                        @Override
                        public void accept(Transition it) {
                            val$lambda.apply((Object)val$m, (Object)it);
                        }
                    };
                    it.getTransitions().forEach((Consumer)_function);
                }
            };
            m.getInAllStates().forEach((Consumer)_function_1);
            Consumer<State> _function_2 = new Consumer<State>((Procedures.Procedure2)lambda, m){
                private final /* synthetic */ Procedures.Procedure2 val$lambda;
                private final /* synthetic */ StateMachine val$m;
                {
                    this.val$lambda = procedure2;
                    this.val$m = stateMachine;
                }

                @Override
                public void accept(State it) {
                    Consumer<Transition> _function = new Consumer<Transition>(){

                        @Override
                        public void accept(Transition it) {
                            val$lambda.apply((Object)val$m, (Object)it);
                        }
                    };
                    it.getTransitions().forEach((Consumer)_function);
                }
            };
            m.getStates().forEach((Consumer)_function_2);
        }
        Set _keySet = result.keySet();
        for (Transition t : _keySet) {
            Set _keySet_1 = ((Map)result.get(t)).keySet();
            for (Clause c : _keySet_1) {
                List _subTransitionFragments = result.get(t).get(c).getSubTransitionFragments();
                for (TransitionFragment f : _subTransitionFragments) {
                    int _plusPlus = counter++;
                    String _plus = "_s" + Integer.valueOf(_plusPlus);
                    f.setSubState(_plus);
                }
            }
        }
        counter = 1;
        Set<Variable> _keySet_2 = this.triggerVariables.keySet();
        for (Variable v : _keySet_2) {
            String _name = v.getName();
            String _plus_1 = String.valueOf(_name) + "_";
            int _plusPlus_1 = counter++;
            String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_plusPlus_1);
            this.triggerVariables.put(v, _plus_2);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected CharSequence generateDecisionClassContent() {
        StringConcatenation _xblockexpression = null;
        this.eventPartitions = StateMachineUtilities.getEventPartitions((AbstractBehavior)this.behavior, (Signature)this.signature);
        HashMap<InterfaceEvent, StateMachine> _hashMap = new HashMap<InterfaceEvent, StateMachine>();
        this.event2Machine = _hashMap;
        HashMap<Clause, String> _hashMap_1 = new HashMap<Clause, String>();
        this.clause2Method = _hashMap_1;
        HashMap<TriggeredTransition, String> _hashMap_2 = new HashMap<TriggeredTransition, String>();
        this.transition2Method = _hashMap_2;
        List events = InterfaceUtilities.getAllInterfaceEvents((Signature)this.signature);
        for (InterfaceEvent ev : events) {
            Set<StateMachine> _keySet = this.eventPartitions.keySet();
            for (StateMachine sm : _keySet) {
                boolean _contains = this.eventPartitions.get(sm).contains(ev);
                if (!_contains) continue;
                this.event2Machine.put(ev, sm);
            }
        }
        EList machines = this.behavior.getMachines();
        this.quantifiersInMachines = this.getQuantifiersInStateMachines(this.behavior, (List<StateMachine>)machines);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.function.BiFunction;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".utils.Utils;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".constraints.CRule;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _decisionClassName = InterfaceDecisionGenerator.decisionClassName(this.signature);
        _builder.append((Object)_decisionClassName);
        _builder.append(" extends CInterfaceDecisionClass {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        CharSequence _utilityClassName = ConstraintsRulesGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName, "\t");
        _builder.append(" stateOfDecisionClass;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        CharSequence _utilityClassName_1 = ConstraintsRulesGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_1, "\t");
        _builder.append(" lastReceivedState;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        CharSequence _rulesClassName = ConstraintsRulesGenerator.rulesClassName((NamedElement)this.signature);
        _builder.append((Object)_rulesClassName, "\t");
        _builder.append(" rulesProvider;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _decisionClassName_1 = InterfaceDecisionGenerator.decisionClassName(this.signature);
        _builder.append((Object)_decisionClassName_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = new ");
        CharSequence _utilityClassName_2 = ConstraintsRulesGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_2, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("lastReceivedState = new ");
        CharSequence _utilityClassName_3 = ConstraintsRulesGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_3, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("rulesProvider = new ");
        CharSequence _rulesClassName_1 = ConstraintsRulesGenerator.rulesClassName((NamedElement)this.signature);
        _builder.append((Object)_rulesClassName_1, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(CState state) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lastReceivedState = (");
        CharSequence _utilityClassName_4 = ConstraintsRulesGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_4, "\t\t");
        _builder.append(") state;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = (");
        CharSequence _utilityClassName_5 = ConstraintsRulesGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_5, "\t\t");
        _builder.append(") Utils.deepCopy(lastReceivedState);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CState getState() {");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("return stateOfDecisionClass;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CInterfaceDecisionResult consume(CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("if(message instanceof CObservedReply) {");
        _builder.newLine();
        _builder.append("\t        ");
        _builder.append("if(stateOfDecisionClass.getSubState() == null) {");
        _builder.newLine();
        _builder.append("\t            ");
        _builder.append("return noTransitions;");
        _builder.newLine();
        _builder.append("\t        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t        ");
        _builder.append("return handleReply((CObservedReply) message);");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch(message.getName()) {");
        _builder.newLine();
        for (InterfaceEvent e : events) {
            _builder.append("\t\t");
            int j = 0;
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("case \"");
            String _name = e.getName();
            _builder.append(_name, "\t\t");
            _builder.append("\" : return ");
            CharSequence _makeEventMethodName = this.makeEventMethodName(e);
            _builder.append((Object)_makeEventMethodName, "\t\t");
            _builder.append("(");
            if (!(e instanceof Notification)) {
                EList _parameters = e.getParameters();
                boolean _hasElements = false;
                for (Parameter p : _parameters) {
                    boolean _notEquals;
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t");
                    }
                    DIRECTION _direction = p.getDirection();
                    boolean bl = _notEquals = !Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
                    if (_notEquals) {
                        _builder.append("(");
                        CharSequence _javaType = this.toJavaType((EObject)p.getType());
                        _builder.append((Object)_javaType, "\t\t");
                        _builder.append(") message.getParameters().get(");
                        int _plusPlus = j++;
                        _builder.append((Object)_plusPlus, "\t\t");
                        _builder.append(")");
                        continue;
                    }
                    CharSequence _defaultValue = this.defaultValue((EObject)p.getType());
                    _builder.append((Object)_defaultValue, "\t\t");
                }
            } else {
                _builder.append("message");
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("default: return unknownEvent;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        for (InterfaceEvent e_1 : events) {
            _builder.append("\t");
            CharSequence _generateEventRootMethod = this.generateEventRootMethod(e_1);
            _builder.append((Object)_generateEventRootMethod, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        CharSequence _generateClauseMethods = this.generateClauseMethods((List<StateMachine>)machines);
        _builder.append((Object)_generateClauseMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateTriggeredMethodsInStates = this.generateTriggeredMethodsInStates((List<StateMachine>)machines, events);
        _builder.append((Object)_generateTriggeredMethodsInStates, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateNonTriggeredMethodsInStates = this.generateNonTriggeredMethodsInStates((List<StateMachine>)machines, events);
        _builder.append((Object)_generateNonTriggeredMethodsInStates, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateReplyHandlerMethod = this.generateReplyHandlerMethod();
        _builder.append((Object)_generateReplyHandlerMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<CRule> getRules() {");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("return rulesProvider.getRules();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateReplyHandlerMethod() {
        StringConcatenation _xblockexpression = null;
        List<TransitionFragment> transitions = this.getSubTransitionsForReplies();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CInterfaceDecisionResult handleReply(CObservedReply message) {");
        _builder.newLine();
        boolean _isEmpty = transitions.isEmpty();
        if (_isEmpty) {
            _builder.append("    ");
            _builder.append("return noTransitions;");
            _builder.newLine();
        } else {
            _builder.append("    ");
            _builder.append("List<CExecutionContext> result = new ArrayList<CExecutionContext>();");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("String subState = stateOfDecisionClass.getSubState();");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("if(subState != null) {");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("   ");
            _builder.append("switch(subState) {");
            _builder.newLine();
            List<TransitionFragment> _subTransitionsForReplies = this.getSubTransitionsForReplies();
            for (TransitionFragment f : _subTransitionsForReplies) {
                _builder.append("    ");
                _builder.append("       ");
                _builder.append("case \"");
                String _subState = f.getSubState();
                _builder.append(_subState, "           ");
                _builder.append("\": ");
                String _methodName = f.getMethodName();
                _builder.append(_methodName, "           ");
                _builder.append("(stateOfDecisionClass.get_");
                String _machineName = f.getMachineName();
                _builder.append(_machineName, "           ");
                _builder.append("(), message, result); break;");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            _builder.append("       ");
            _builder.append("default: return noTransitions;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("   ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("   ");
            _builder.append("return noTransitions;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("return checkTransitionsResult(result);");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence makeEventMethodName(InterfaceEvent e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("_");
        String _name = e.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence generateClauseMethods(List<StateMachine> machines) {
        StringConcatenation _builder = new StringConcatenation();
        for (StateMachine m : machines) {
            CharSequence _generateClauseMethods = this.generateClauseMethods(m);
            _builder.append((Object)_generateClauseMethods);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateClauseMethods(StateMachine m) {
        StringConcatenation _builder = new StringConcatenation();
        int _size = m.getInAllStates().size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            CharSequence _generateClauseMethods = this.generateClauseMethods(m, "block" + Integer.valueOf(i + 1), (List<Transition>)((InAllStatesBlock)m.getInAllStates().get(i.intValue())).getTransitions());
            _builder.append((Object)_generateClauseMethods);
            _builder.newLineIfNotEmpty();
        }
        int _size_1 = m.getStates().size();
        ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _size_1, true);
        for (Integer i_1 : _doubleDotLessThan_1) {
            CharSequence _generateClauseMethods_1 = this.generateClauseMethods(m, ((State)m.getStates().get(i_1.intValue())).getName(), (List<Transition>)((State)m.getStates().get(i_1.intValue())).getTransitions());
            _builder.append((Object)_generateClauseMethods_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateClauseMethods(StateMachine m, String nameFragment, List<Transition> transitions) {
        StringConcatenation _builder = new StringConcatenation();
        int _size = transitions.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            int _size_1 = transitions.get(i).getClauses().size();
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _size_1, true);
            for (Integer j : _doubleDotLessThan_1) {
                String _name = m.getName();
                String _plus = String.valueOf(_name) + "_";
                String _plus_1 = String.valueOf(_plus) + nameFragment;
                String _plus_2 = String.valueOf(_plus_1) + "_t";
                String _plus_3 = String.valueOf(_plus_2) + Integer.valueOf(i + 1);
                String _plus_4 = String.valueOf(_plus_3) + "_c";
                String methodName = String.valueOf(_plus_4) + Integer.valueOf(j + 1);
                _builder.newLineIfNotEmpty();
                ClauseFragments fragments = this.clauseFragments.get(transitions.get(i)).get(transitions.get(i).getClauses().get(j.intValue()));
                _builder.newLineIfNotEmpty();
                fragments.setMethodNames(methodName);
                _builder.newLineIfNotEmpty();
                ArrayList _all = fragments.all();
                for (BehaviorFragment fragment : _all) {
                    CharSequence _generateClauseMethod = this.generateClauseMethod(m, (Clause)transitions.get(i).getClauses().get(j.intValue()), fragment);
                    _builder.append((Object)_generateClauseMethod);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                }
            }
            Transition _get = transitions.get(i);
            if (!(_get instanceof TriggeredTransition)) continue;
            String _name_1 = m.getName();
            String _plus_5 = String.valueOf(_name_1) + "_";
            String _plus_6 = String.valueOf(_plus_5) + nameFragment;
            String _plus_7 = String.valueOf(_plus_6) + "_t";
            String _plus_8 = String.valueOf(_plus_7) + Integer.valueOf(i + 1);
            Transition _get_1 = transitions.get(i);
            CharSequence _generateTriggeredTransitionMethod = this.generateTriggeredTransitionMethod(m, _plus_8, (TriggeredTransition)_get_1);
            _builder.append((Object)_generateTriggeredTransitionMethod);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateTriggeredTransitionMethod(StateMachine m, String methodName, TriggeredTransition transition) {
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        this.transition2Method.put(transition, methodName);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private void ");
        _builder.append(methodName);
        _builder.append("(String stateName, int tIndex, List<CExecutionContext> result");
        EList _parameters = transition.getParameters();
        for (Variable p : _parameters) {
            _builder.append(", ");
            CharSequence _javaType = this.toJavaType((EObject)p.getType());
            _builder.append((Object)_javaType);
            _builder.append(" ");
            _builder.append("commaTVar_");
            String _name = p.getName();
            _builder.append(_name);
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        Expression _guard = transition.getGuard();
        boolean bl = _tripleNotEquals = _guard != null;
        if (_tripleNotEquals) {
            EList _parameters_1 = transition.getParameters();
            for (Variable p_1 : _parameters_1) {
                _builder.append("\t");
                _builder.append("stateOfDecisionClass.set_");
                _builder.append("commaVar_", "\t");
                String _get = this.triggerVariables.get(p_1);
                _builder.append(_get, "\t");
                _builder.append("(");
                _builder.append("commaTVar_", "\t");
                String _name_1 = p_1.getName();
                _builder.append(_name_1, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("if(");
            CharSequence _generateExpression = this.generateExpression(transition.getGuard());
            _builder.append((Object)_generateExpression, "\t");
            _builder.append("){");
            _builder.newLineIfNotEmpty();
            EList _clauses = transition.getClauses();
            for (Clause c : _clauses) {
                TransitionFragment rootFragment = this.clauseFragments.get(transition).get(c).getRootFragment();
                _builder.newLineIfNotEmpty();
                String _methodName = rootFragment.getMethodName();
                _builder.append(_methodName);
                _builder.append("(stateName, tIndex, result");
                EList _parameters_2 = transition.getParameters();
                for (Variable p_2 : _parameters_2) {
                    _builder.append(", ");
                    _builder.append("commaTVar_");
                    String _name_2 = p_2.getName();
                    _builder.append(_name_2);
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            EList _clauses_1 = transition.getClauses();
            for (Clause c_1 : _clauses_1) {
                _builder.append("\t");
                TransitionFragment rootFragment_1 = this.clauseFragments.get(transition).get(c_1).getRootFragment();
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _methodName_1 = rootFragment_1.getMethodName();
                _builder.append(_methodName_1, "\t");
                _builder.append("(stateName, tIndex, result");
                EList _parameters_3 = transition.getParameters();
                for (Variable p_3 : _parameters_3) {
                    _builder.append(", ");
                    _builder.append("commaTVar_", "\t");
                    String _name_3 = p_3.getName();
                    _builder.append(_name_3, "\t");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateClauseMethod(StateMachine m, Clause clause, BehaviorFragment fragment) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        String result = _builder.toString();
        if (fragment instanceof TransitionFragment) {
            boolean _isRoot = ((TransitionFragment)fragment).isRoot();
            if (_isRoot) {
                Transition transition = ((TransitionFragment)fragment).getTransition();
                CharSequence eventName = this.getEventName(transition, clause);
                String _xifexpression = null;
                if (transition instanceof TriggeredTransition) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    EList _parameters = ((TriggeredTransition)transition).getParameters();
                    for (Variable p : _parameters) {
                        _builder_1.append(", ");
                        CharSequence _javaType = this.toJavaType((EObject)p.getType());
                        _builder_1.append((Object)_javaType);
                        _builder_1.append(" ");
                        _builder_1.append("commaTVar_");
                        String _name = p.getName();
                        _builder_1.append(_name);
                    }
                    _xifexpression = _builder_1.toString();
                } else {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _xifexpression = _builder_2.toString();
                }
                String parametersList = _xifexpression;
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("private void ");
                String _methodName = ((TransitionFragment)fragment).getMethodName();
                _builder_3.append(_methodName);
                _builder_3.append("(String stateName, int tIndex, ");
                if (transition instanceof NonTriggeredTransition) {
                    _builder_3.append("CObservedMessage message, ");
                }
                _builder_3.append("List<CExecutionContext> result");
                _builder_3.append(parametersList);
                _builder_3.append(") {");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("    ");
                _builder_3.append("String clauseKey = stateName + \" transition \" + (tIndex + 1) + \"");
                _builder_3.append((Object)eventName, "    ");
                _builder_3.append("\" + \" clause ");
                int _indexOf = transition.getClauses().indexOf((Object)clause);
                int _plus = _indexOf + 1;
                _builder_3.append((Object)_plus, "    ");
                _builder_3.append("\";");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("    ");
                _builder_3.append("CExecutionContext context = new CExecutionContext();");
                _builder_3.newLine();
                _builder_3.append("    ");
                _builder_3.append("stateOfDecisionClass = (");
                CharSequence _utilityClassName = ConstraintsRulesGenerator.utilityClassName(this.signature);
                _builder_3.append((Object)_utilityClassName, "    ");
                _builder_3.append(") Utils.deepCopy(lastReceivedState);");
                _builder_3.newLineIfNotEmpty();
                if (transition instanceof TriggeredTransition) {
                    EList _parameters_1 = ((TriggeredTransition)transition).getParameters();
                    for (Variable p_1 : _parameters_1) {
                        _builder_3.append("    ");
                        _builder_3.append("stateOfDecisionClass.set_");
                        _builder_3.append("commaVar_", "    ");
                        String _get = this.triggerVariables.get(p_1);
                        _builder_3.append(_get, "    ");
                        _builder_3.append("(");
                        _builder_3.append("commaTVar_", "    ");
                        String _name_1 = p_1.getName();
                        _builder_3.append(_name_1, "    ");
                        _builder_3.append(");");
                        _builder_3.newLineIfNotEmpty();
                    }
                }
                _builder_3.append("    ");
                _builder_3.append("stateOfDecisionClass.takeSnapshot();");
                _builder_3.newLine();
                _builder_3.append("    ");
                _builder_3.append("enactClause(stateOfDecisionClass, clauseKey);");
                _builder_3.newLine();
                _builder_3.append("    ");
                _builder_3.append("CMessagePattern mp;");
                _builder_3.newLine();
                _builder_3.append("    ");
                _builder_3.append("CParallelCompositionPattern pc;");
                _builder_3.newLine();
                _builder_3.append("    ");
                _builder_3.append("BiFunction<CState, List<Object>, Boolean> _condition;");
                _builder_3.newLine();
                List _actions = ((TransitionFragment)fragment).getActions();
                for (Object a : _actions) {
                    _builder_3.append("    ");
                    CharSequence _generateActionInContext = this.generateActionInContext(a, null);
                    _builder_3.append((Object)_generateActionInContext, "    ");
                    _builder_3.newLineIfNotEmpty();
                }
                _builder_3.append("}");
                _builder_3.newLine();
                result = _builder_3.toString();
            } else {
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("private void ");
                String _methodName_1 = ((TransitionFragment)fragment).getMethodName();
                _builder_4.append(_methodName_1);
                _builder_4.append("(String stateName, CObservedMessage message, ");
                EObject _eContainer = clause.eContainer();
                if (_eContainer instanceof NonTriggeredTransition) {
                    _builder_4.append("CExecutionContext execContext, ");
                }
                _builder_4.append("List<CExecutionContext> result) {");
                _builder_4.newLineIfNotEmpty();
                EObject _eContainer_1 = clause.eContainer();
                if (_eContainer_1 instanceof NonTriggeredTransition) {
                    _builder_4.append("    ");
                    _builder_4.append("CExecutionContext context;");
                    _builder_4.newLine();
                    _builder_4.append("    ");
                    _builder_4.append("if(execContext == null) {");
                    _builder_4.newLine();
                    _builder_4.append("    ");
                    _builder_4.append("    ");
                    _builder_4.append("context = new CExecutionContext();");
                    _builder_4.newLine();
                    _builder_4.append("    ");
                    _builder_4.append("    ");
                    _builder_4.append("stateOfDecisionClass = (");
                    CharSequence _utilityClassName_1 = ConstraintsRulesGenerator.utilityClassName(this.signature);
                    _builder_4.append((Object)_utilityClassName_1, "        ");
                    _builder_4.append(") Utils.deepCopy(lastReceivedState);");
                    _builder_4.newLineIfNotEmpty();
                    _builder_4.append("    ");
                    _builder_4.append("    ");
                    _builder_4.append("stateOfDecisionClass.takeSnapshot(); //TODO reconsider this!");
                    _builder_4.newLine();
                    _builder_4.append("    ");
                    _builder_4.append("} else {");
                    _builder_4.newLine();
                    _builder_4.append("    ");
                    _builder_4.append("    ");
                    _builder_4.append("context = execContext;");
                    _builder_4.newLine();
                    _builder_4.append("    ");
                    _builder_4.append("}");
                    _builder_4.newLine();
                } else {
                    _builder_4.append("    ");
                    _builder_4.append("CExecutionContext context = new CExecutionContext();");
                    _builder_4.newLine();
                    _builder_4.append("    ");
                    _builder_4.append("stateOfDecisionClass = (");
                    CharSequence _utilityClassName_2 = ConstraintsRulesGenerator.utilityClassName(this.signature);
                    _builder_4.append((Object)_utilityClassName_2, "    ");
                    _builder_4.append(") Utils.deepCopy(lastReceivedState);");
                    _builder_4.newLineIfNotEmpty();
                    _builder_4.append("    ");
                    _builder_4.append("stateOfDecisionClass.takeSnapshot(); //TODO reconsider this!");
                    _builder_4.newLine();
                }
                _builder_4.append("    ");
                _builder_4.append("CMessagePattern mp;");
                _builder_4.newLine();
                _builder_4.append("    ");
                _builder_4.append("CParallelCompositionPattern pc;");
                _builder_4.newLine();
                _builder_4.append("    ");
                _builder_4.append("BiFunction<CState, List<Object>, Boolean> _condition;");
                _builder_4.newLine();
                List _actions_1 = ((TransitionFragment)fragment).getActions();
                for (Object a_1 : _actions_1) {
                    _builder_4.append("    ");
                    CharSequence _generateActionInContext_1 = this.generateActionInContext(a_1, null);
                    _builder_4.append((Object)_generateActionInContext_1, "    ");
                    _builder_4.newLineIfNotEmpty();
                }
                _builder_4.append("}");
                _builder_4.newLine();
                result = _builder_4.toString();
            }
        } else {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("private void ");
            String _methodName_2 = fragment.getMethodName();
            _builder_5.append(_methodName_2);
            _builder_5.append("(String stateName, CObservedMessage message, CExecutionContext context, List<CExecutionContext> result) {");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("    ");
            _builder_5.append("CMessagePattern mp;");
            _builder_5.newLine();
            _builder_5.append("    ");
            _builder_5.append("CParallelCompositionPattern pc;");
            _builder_5.newLine();
            _builder_5.append("    ");
            _builder_5.append("BiFunction<CState, List<Object>, Boolean> _condition;");
            _builder_5.newLine();
            List _actions_2 = fragment.getActions();
            for (Object a_2 : _actions_2) {
                _builder_5.append("    ");
                CharSequence _generateActionInContext_2 = this.generateActionInContext(a_2, null);
                _builder_5.append((Object)_generateActionInContext_2, "    ");
                _builder_5.newLineIfNotEmpty();
            }
            _builder_5.append("}");
            _builder_5.newLine();
            result = _builder_5.toString();
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public CharSequence generateTriggeredMethodsInStates(List<StateMachine> machines, List<InterfaceEvent> events) {
        StringConcatenation _builder = new StringConcatenation();
        for (StateMachine sm : machines) {
            EList _states = sm.getStates();
            for (State state : _states) {
                Functions.Function1<InterfaceEvent, Boolean> _function = new Functions.Function1<InterfaceEvent, Boolean>(){

                    public Boolean apply(InterfaceEvent e) {
                        return !(e instanceof Notification);
                    }
                };
                Iterable _filter = IterableExtensions.filter(events, (Functions.Function1)_function);
                for (InterfaceEvent ev : _filter) {
                    boolean _not;
                    List<TriggeredTransition> transitions = this.getTriggeredTransitionsInState(ev, state);
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = transitions.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (!_not) continue;
                    CharSequence _generateTriggeredTransitionMethodInState = this.generateTriggeredTransitionMethodInState(ev, transitions, state);
                    _builder.append((Object)_generateTriggeredTransitionMethodInState);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                }
            }
        }
        return _builder;
    }

    public CharSequence generateNonTriggeredMethodsInStates(List<StateMachine> machines, List<InterfaceEvent> events) {
        StringConcatenation _builder = new StringConcatenation();
        for (StateMachine sm : machines) {
            EList _states = sm.getStates();
            for (State state : _states) {
                Iterable _filter = Iterables.filter(events, Notification.class);
                for (Notification n : _filter) {
                    List<NonTriggeredTransition> transitions = this.getNonTriggeredTransitionsInState(n, state);
                    _builder.newLineIfNotEmpty();
                    List<TransitionFragment> fragments = this.getSubTransitions(n, state);
                    _builder.newLineIfNotEmpty();
                    if (transitions.isEmpty() && fragments.isEmpty()) continue;
                    CharSequence _generateNonTriggeredTransitionMethodInState = this.generateNonTriggeredTransitionMethodInState((InterfaceEvent)n, transitions, fragments, state);
                    _builder.append((Object)_generateNonTriggeredTransitionMethodInState);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                }
            }
        }
        return _builder;
    }

    public List<TransitionFragment> getSubTransitions(Notification n, State s) {
        ArrayList<TransitionFragment> _xblockexpression = null;
        ArrayList<TransitionFragment> result = new ArrayList<TransitionFragment>();
        List _transitionsForState = StateMachineUtilities.transitionsForState((State)s);
        for (Transition t : _transitionsForState) {
            EList _clauses = t.getClauses();
            for (Clause c : _clauses) {
                List _subTransitionFragments = this.clauseFragments.get(t).get(c).getSubTransitionFragments();
                for (TransitionFragment f : _subTransitionFragments) {
                    InterfaceEvent _event;
                    boolean _equals;
                    Object first = f.getActions().get(0);
                    if (!(first instanceof EventWithVars) || !(_equals = Objects.equal((Object)(_event = ((EventWithVars)first).getEvent()), (Object)n))) continue;
                    result.add(f);
                }
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public List<TransitionFragment> getSubTransitionsForReplies() {
        ArrayList<TransitionFragment> _xblockexpression = null;
        ArrayList<TransitionFragment> result = new ArrayList<TransitionFragment>();
        Collection<Map<Clause, ClauseFragments>> _values = this.clauseFragments.values();
        for (Map<Clause, ClauseFragments> m : _values) {
            Collection<ClauseFragments> _values_1 = m.values();
            for (ClauseFragments f : _values_1) {
                List _subTransitionFragments = f.getSubTransitionFragments();
                for (TransitionFragment subTrans : _subTransitionFragments) {
                    Object first = subTrans.getActions().get(0);
                    if (!(first instanceof CommandReplyWithVars)) continue;
                    result.add(subTrans);
                }
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public CharSequence generateEventRootMethod(InterfaceEvent event) {
        StringConcatenation _xblockexpression = null;
        StateMachine stateMachine = this.event2Machine.get(event);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CInterfaceDecisionResult ");
        CharSequence _makeEventMethodName = this.makeEventMethodName(event);
        _builder.append((Object)_makeEventMethodName);
        _builder.append("(");
        if (!(event instanceof Notification)) {
            EList _parameters = event.getParameters();
            boolean _hasElements = false;
            for (Parameter p : _parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _javaType = this.toJavaType((EObject)p.getType());
                _builder.append((Object)_javaType);
                _builder.append(" ");
                _builder.append("commaTVar_");
                String _name = p.getName();
                _builder.append(_name);
            }
        } else {
            _builder.append("CObservedMessage message");
        }
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("switch(stateOfDecisionClass.get_");
        String _name_1 = stateMachine.getName();
        _builder.append(_name_1, "\t");
        _builder.append("()) {");
        _builder.newLineIfNotEmpty();
        EList _states = stateMachine.getStates();
        for (State s : _states) {
            boolean _not;
            boolean _emptyTransitionsInState = this.emptyTransitionsInState(event, s);
            boolean bl = _not = !_emptyTransitionsInState;
            if (!_not) continue;
            _builder.append("\t");
            _builder.append("case \"");
            String _name_2 = s.getName();
            _builder.append(_name_2, "\t");
            _builder.append("\": return ");
            String _name_3 = s.getName();
            _builder.append(_name_3, "\t");
            _builder.append("_");
            String _name_4 = event.getName();
            _builder.append(_name_4, "\t");
            _builder.append("(");
            if (!(event instanceof Notification)) {
                EList _parameters_1 = event.getParameters();
                boolean _hasElements_1 = false;
                for (Parameter p_1 : _parameters_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    _builder.append("commaTVar_", "\t");
                    String _name_5 = p_1.getName();
                    _builder.append(_name_5, "\t");
                }
            } else {
                _builder.append("message");
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("default: return noTransitions;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateTriggeredTransitionMethodInState(InterfaceEvent event, List<TriggeredTransition> transitions, State s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CInterfaceDecisionResult ");
        String _name = s.getName();
        _builder.append(_name);
        _builder.append("_");
        String _name_1 = event.getName();
        _builder.append(_name_1);
        _builder.append("(");
        EList _parameters = event.getParameters();
        boolean _hasElements = false;
        for (Parameter p : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _javaType = this.toJavaType((EObject)p.getType());
            _builder.append((Object)_javaType);
            _builder.append(" ");
            _builder.append("commaVar_");
            String _name_2 = p.getName();
            _builder.append(_name_2);
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("List<CExecutionContext> result = new ArrayList<CExecutionContext>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(stateOfDecisionClass.getSubState() != null) {");
        _builder.newLine();
        _builder.append("\t   ");
        _builder.append("return noTransitions;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        for (TriggeredTransition t : transitions) {
            boolean _greaterThan;
            _builder.append("\t");
            int transitionIndex = StateMachineUtilities.transitionsForState((State)s).indexOf(t);
            _builder.newLineIfNotEmpty();
            int _indexOf = transitions.indexOf(t);
            boolean bl = _greaterThan = _indexOf > 0;
            if (_greaterThan) {
                _builder.append("\t");
                _builder.append("stateOfDecisionClass = (");
                CharSequence _utilityClassName = ConstraintsRulesGenerator.utilityClassName(this.signature);
                _builder.append((Object)_utilityClassName, "\t");
                _builder.append(") Utils.deepCopy(lastReceivedState);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            String _get = this.transition2Method.get(t);
            _builder.append(_get, "\t");
            _builder.append("(\"");
            String _name_3 = s.getName();
            _builder.append(_name_3, "\t");
            _builder.append("\", ");
            _builder.append((Object)transitionIndex, "\t");
            _builder.append(", result");
            EList _parameters_1 = event.getParameters();
            for (Parameter p_1 : _parameters_1) {
                _builder.append(", ");
                _builder.append("commaVar_", "\t");
                String _name_4 = p_1.getName();
                _builder.append(_name_4, "\t");
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("return checkTransitionsResult(result);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateNonTriggeredTransitionBody(NonTriggeredTransition t, State s, InterfaceEvent ev, int transitionIndex) {
        StringConcatenation _builder = new StringConcatenation();
        EList _clauses = t.getClauses();
        for (Clause c : _clauses) {
            TransitionFragment rootFragment = this.clauseFragments.get(t).get(c).getRootFragment();
            _builder.newLineIfNotEmpty();
            boolean _contains = rootFragment.getHeadNotifications().contains(ev);
            if (!_contains) continue;
            String _methodName = rootFragment.getMethodName();
            _builder.append(_methodName);
            _builder.append("(\"");
            String _name = s.getName();
            _builder.append(_name);
            _builder.append("\", ");
            _builder.append((Object)transitionIndex);
            _builder.append(", message, result);");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateNonTriggeredTransitionMethodInState(InterfaceEvent event, List<NonTriggeredTransition> transitions, List<TransitionFragment> fragments, State s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CInterfaceDecisionResult ");
        String _name = s.getName();
        _builder.append(_name);
        _builder.append("_");
        String _name_1 = event.getName();
        _builder.append(_name_1);
        _builder.append("(CObservedMessage message) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("List<CExecutionContext> result = new ArrayList<CExecutionContext>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("String subState = stateOfDecisionClass.getSubState();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(subState != null) {");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("switch(subState) {");
        _builder.newLine();
        for (TransitionFragment f : fragments) {
            _builder.append("\t        ");
            Object _get = f.getActions().get(0);
            NonTriggeredTransition parentTransition = (NonTriggeredTransition)EcoreUtil2.getContainerOfType((EObject)((EObject)_get), NonTriggeredTransition.class);
            _builder.newLineIfNotEmpty();
            _builder.append("\t        ");
            _builder.append("case \"");
            String _subState = f.getSubState();
            _builder.append(_subState, "\t        ");
            _builder.append("\": ");
            String _methodName = f.getMethodName();
            _builder.append(_methodName, "\t        ");
            _builder.append("(\"");
            String _name_2 = s.getName();
            _builder.append(_name_2, "\t        ");
            _builder.append("\", message, ");
            if (parentTransition != null) {
                _builder.append("null, ");
            }
            _builder.append("result); break;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t        ");
        _builder.append("default: return noTransitions;");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        boolean _isEmpty = transitions.isEmpty();
        if (_isEmpty) {
            _builder.append("\t    ");
            _builder.append("return noTransitions;");
            _builder.newLine();
        } else {
            for (NonTriggeredTransition t : transitions) {
                Expression _guard;
                boolean _tripleNotEquals;
                boolean _greaterThan;
                _builder.append("\t    ");
                int transitionIndex = StateMachineUtilities.transitionsForState((State)s).indexOf(t);
                _builder.newLineIfNotEmpty();
                _builder.append("\t    ");
                _builder.append("//begin transition");
                _builder.newLine();
                int _indexOf = transitions.indexOf(t);
                boolean bl = _greaterThan = _indexOf > 0;
                if (_greaterThan) {
                    _builder.append("\t    ");
                    _builder.append("stateOfDecisionClass = (");
                    CharSequence _utilityClassName = ConstraintsRulesGenerator.utilityClassName(this.signature);
                    _builder.append((Object)_utilityClassName, "\t    ");
                    _builder.append(") Utils.deepCopy(lastReceivedState);");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl2 = _tripleNotEquals = (_guard = t.getGuard()) != null;
                if (_tripleNotEquals) {
                    _builder.append("\t    ");
                    _builder.append("if(");
                    CharSequence _generateExpression = this.generateExpression(t.getGuard());
                    _builder.append((Object)_generateExpression, "\t    ");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t    ");
                    _builder.append("    ");
                    CharSequence _generateNonTriggeredTransitionBody = this.generateNonTriggeredTransitionBody(t, s, event, transitionIndex);
                    _builder.append((Object)_generateNonTriggeredTransitionBody, "\t        ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t    ");
                    _builder.append("}");
                    _builder.newLine();
                } else {
                    _builder.append("\t    ");
                    CharSequence _generateNonTriggeredTransitionBody_1 = this.generateNonTriggeredTransitionBody(t, s, event, transitionIndex);
                    _builder.append((Object)_generateNonTriggeredTransitionBody_1, "\t    ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t    ");
                _builder.append("//end of transition");
                _builder.newLine();
            }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return checkTransitionsResult(result);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public boolean emptyTransitionsInState(final InterfaceEvent event, State s) {
        boolean _xifexpression = false;
        if (event instanceof Notification) {
            List allTransitions = StateMachineUtilities.transitionsForState((State)s);
            for (Transition t : allTransitions) {
                EList _clauses = t.getClauses();
                for (Clause c : _clauses) {
                    boolean _not;
                    ClauseFragments fragments = this.clauseFragments.get(t).get(c);
                    Functions.Function1<TransitionFragment, Boolean> _function = new Functions.Function1<TransitionFragment, Boolean>(){

                        public Boolean apply(TransitionFragment it) {
                            return it.getHeadNotifications().contains(event);
                        }
                    };
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)fragments.getSubTransitionFragments(), (Functions.Function1)_function));
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        return false;
                    }
                    if (!(t instanceof NonTriggeredTransition) || !fragments.getRootFragment().getHeadNotifications().contains(event)) continue;
                    return false;
                }
            }
            return true;
        }
        EObject _eContainer = s.eContainer();
        Functions.Function1<TriggeredTransition, Boolean> _function = new Functions.Function1<TriggeredTransition, Boolean>(){

            public Boolean apply(TriggeredTransition t) {
                InterfaceEvent _trigger = t.getTrigger();
                return Objects.equal((Object)_trigger, (Object)event);
            }
        };
        _xifexpression = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)StateMachineUtilities.getTriggeredTransitions((StateMachine)((StateMachine)_eContainer), (State)s), (Functions.Function1)_function));
        return _xifexpression;
    }

    public List<TriggeredTransition> getTriggeredTransitionsInState(final InterfaceEvent event, State s) {
        ArrayList<TriggeredTransition> _xblockexpression = null;
        ArrayList<TriggeredTransition> result = new ArrayList<TriggeredTransition>();
        EObject _eContainer = s.eContainer();
        List allTriggeredTransitions = StateMachineUtilities.getTriggeredTransitions((StateMachine)((StateMachine)_eContainer), (State)s);
        Functions.Function1<TriggeredTransition, Boolean> _function = new Functions.Function1<TriggeredTransition, Boolean>(){

            public Boolean apply(TriggeredTransition t) {
                InterfaceEvent _trigger = t.getTrigger();
                return Objects.equal((Object)_trigger, (Object)event);
            }
        };
        Iterables.addAll(result, (Iterable)IterableExtensions.filter((Iterable)allTriggeredTransitions, (Functions.Function1)_function));
        _xblockexpression = result;
        return _xblockexpression;
    }

    public List<NonTriggeredTransition> getNonTriggeredTransitionsInState(final Notification n, State s) {
        ArrayList<NonTriggeredTransition> _xblockexpression = null;
        EObject _eContainer = s.eContainer();
        List transitions = StateMachineUtilities.getNonTriggeredTransitions((StateMachine)((StateMachine)_eContainer), (State)s);
        final ArrayList<NonTriggeredTransition> result = new ArrayList<NonTriggeredTransition>();
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(final Transition t) {
                Functions.Function1<Clause, Boolean> _function = new Functions.Function1<Clause, Boolean>(){

                    public Boolean apply(Clause c) {
                        return (this).InterfaceDecisionGenerator.this.clauseFragments.get(t).get(c).getRootFragment().getHeadNotifications().contains(n);
                    }
                };
                return IterableExtensions.exists((Iterable)t.getClauses(), (Functions.Function1)_function);
            }
        };
        Consumer<Transition> _function_1 = new Consumer<Transition>(){

            @Override
            public void accept(Transition it) {
                result.add((NonTriggeredTransition)it);
            }
        };
        IterableExtensions.filter((Iterable)transitions, (Functions.Function1)_function).forEach(_function_1);
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected CharSequence _generateActionInContext(AssignmentAction a, InterfaceEvent ev) {
        return this.generateAction((Action)a);
    }

    protected CharSequence _generateActionInContext(IfAction ifact, InterfaceEvent ev) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if(");
        CharSequence _generateExpression = this.generateExpression(ifact.getGuard());
        _builder.append((Object)_generateExpression);
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        EList _actions = ifact.getThenList().getActions();
        for (Action a : _actions) {
            _builder.append("\t");
            CharSequence _generateActionInContext = this.generateActionInContext(a, ev);
            _builder.append((Object)_generateActionInContext, "\t");
            _builder.newLineIfNotEmpty();
        }
        ActionList _elseList = ifact.getElseList();
        boolean bl = _tripleNotEquals = _elseList != null;
        if (_tripleNotEquals) {
            _builder.append("} else {");
            _builder.newLine();
            EList _actions_1 = ifact.getElseList().getActions();
            for (Action a_1 : _actions_1) {
                _builder.append("\t");
                CharSequence _generateActionInContext_1 = this.generateActionInContext(a_1, ev);
                _builder.append((Object)_generateActionInContext_1, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        return _builder;
    }

    protected CharSequence _generateActionInContext(IfHelperAction ifact, InterfaceEvent ev) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if(");
        CharSequence _generateExpression = this.generateExpression(ifact.getCondition());
        _builder.append((Object)_generateExpression);
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        List _thenActions = ifact.getThenActions();
        for (Object a : _thenActions) {
            _builder.append("   ");
            CharSequence _generateActionInContext = this.generateActionInContext(a, ev);
            _builder.append((Object)_generateActionInContext, "   ");
            _builder.newLineIfNotEmpty();
        }
        List _elseActions = ifact.getElseActions();
        boolean bl = _tripleNotEquals = _elseActions != null;
        if (_tripleNotEquals) {
            _builder.append("} else {");
            _builder.newLine();
            List _elseActions_1 = ifact.getElseActions();
            for (Object a_1 : _elseActions_1) {
                _builder.append("    ");
                CharSequence _generateActionInContext_1 = this.generateActionInContext(a_1, ev);
                _builder.append((Object)_generateActionInContext_1, "    ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        return _builder;
    }

    protected CharSequence _generateActionInContext(FunctionFragmentCall fc, InterfaceEvent ev) {
        StringConcatenation _builder = new StringConcatenation();
        String _methodName = fc.getFunctionFragment().getMethodName();
        _builder.append(_methodName);
        _builder.append("(stateName, message, context, result);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateActionInContext(RecordFieldAssignmentAction a, InterfaceEvent ev) {
        return this.generateAction((Action)a);
    }

    protected CharSequence _generateActionInContext(CommandReply a, InterfaceEvent ev) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messagePatternFromAction = this.messagePatternFromAction((EObject)a, ev);
        _builder.append((Object)_messagePatternFromAction);
        _builder.newLineIfNotEmpty();
        _builder.append("context.addToExpectedMessages(new CMessageMultiplicityPattern().setMessagePattern(mp).setInterfaceState((CState)Utils.deepCopy(stateOfDecisionClass)));");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateActionInContext(EventCall a, InterfaceEvent ev) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messagePatternFromAction = this.messagePatternFromAction((EObject)a, ev);
        _builder.append((Object)_messagePatternFromAction);
        _builder.newLineIfNotEmpty();
        _builder.append("context.addToExpectedMessages(new CMessageMultiplicityPattern(mp, ");
        _builder.append((Object)ActionsUtilities.getNormalizedMultiplicity((EventCall)a).lower);
        _builder.append(", ");
        _builder.append((Object)ActionsUtilities.getNormalizedMultiplicity((EventCall)a).upper);
        _builder.append(").setInterfaceState((CState)Utils.deepCopy(stateOfDecisionClass)));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateActionInContext(ParallelComposition pc, InterfaceEvent ev) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("pc = new CParallelCompositionPattern();");
        _builder.newLine();
        List _flatten = ActionsUtilities.flatten((PCFragment)pc);
        for (Action c : _flatten) {
            CharSequence _messagePatternFromAction = this.messagePatternFromAction((EObject)c, ev);
            _builder.append((Object)_messagePatternFromAction);
            _builder.newLineIfNotEmpty();
            _builder.append("pc.addElement(new CMessageMultiplicityPattern(mp, ");
            if (c instanceof EventCall) {
                _builder.append((Object)ActionsUtilities.getNormalizedMultiplicity((EventCall)((EventCall)c)).lower);
                _builder.append(", ");
                _builder.append((Object)ActionsUtilities.getNormalizedMultiplicity((EventCall)((EventCall)c)).upper);
            } else {
                _builder.append("1, 1");
            }
            _builder.append("));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("context.addToExpectedMessages(pc.setInterfaceState((CState)Utils.deepCopy(stateOfDecisionClass)));");
        return _builder;
    }

    protected CharSequence _messagePatternFromAction(CommandReplyWithVars a, InterfaceEvent ev) {
        int _size;
        boolean _greaterThan;
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        TriggeredTransition parentTransition = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)a, TriggeredTransition.class);
        String commandName = parentTransition.getTrigger().getName();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("mp = new CReplyPattern(); ");
        if (commandName != null) {
            _builder.append("mp.setName(\"");
            _builder.append(commandName);
            _builder.append("\");");
        }
        _builder.newLineIfNotEmpty();
        Expression _condition = a.getCondition();
        boolean bl = _tripleNotEquals = _condition != null;
        if (_tripleNotEquals) {
            _builder.append("_condition = (env, params) -> {");
            CharSequence _utilityClassName = ConstraintsRulesGenerator.utilityClassName(this.signature);
            _builder.append((Object)_utilityClassName);
            _builder.append(" stateOfDecisionClass = (");
            CharSequence _utilityClassName_1 = ConstraintsRulesGenerator.utilityClassName(this.signature);
            _builder.append((Object)_utilityClassName_1);
            _builder.append(") env; return ");
            CharSequence _generateExpression = this.generateExpression(a.getCondition());
            _builder.append((Object)_generateExpression);
            _builder.append(";};");
            _builder.newLineIfNotEmpty();
            _builder.append("mp.setPrecondition(_condition);");
            _builder.newLine();
        }
        boolean bl2 = _greaterThan = (_size = a.getParameters().size()) > 0;
        if (_greaterThan) {
            _builder.append("mp");
            EList _parameters = a.getParameters();
            for (Variable p : _parameters) {
                _builder.append(".addParameter(new CVariable(\"");
                String _name = p.getName();
                _builder.append(_name);
                _builder.append("\", ");
                CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)p.getType());
                _builder.append((Object)_javaReferenceType);
                _builder.append(".class))");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _messagePatternFromAction(EventWithVars a, InterfaceEvent ev) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("mp = new CNotificationPattern(\"");
        String _name = a.getEvent().getName();
        _builder.append(_name);
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        Expression _condition = a.getCondition();
        boolean bl = _tripleNotEquals = _condition != null;
        if (_tripleNotEquals) {
            _builder.append("_condition = (env, params) -> {");
            CharSequence _utilityClassName = ConstraintsRulesGenerator.utilityClassName(this.signature);
            _builder.append((Object)_utilityClassName);
            _builder.append(" stateOfDecisionClass = (");
            CharSequence _utilityClassName_1 = ConstraintsRulesGenerator.utilityClassName(this.signature);
            _builder.append((Object)_utilityClassName_1);
            _builder.append(") env; return ");
            CharSequence _generateExpression = this.generateExpression(a.getCondition());
            _builder.append((Object)_generateExpression);
            _builder.append(";};");
            _builder.newLineIfNotEmpty();
            _builder.append("mp.setPrecondition(_condition);");
            _builder.newLine();
        }
        EList _parameters = a.getParameters();
        for (Variable p : _parameters) {
            _builder.append("mp.addParameter(new CVariable(\"");
            String _name_1 = p.getName();
            _builder.append(_name_1);
            _builder.append("\", ");
            CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)p.getType());
            _builder.append((Object)_javaReferenceType);
            _builder.append(".class));");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateActionInContext(StateTransitionAction a, InterfaceEvent ev) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _subState = a.toSubState();
        if (_subState) {
            boolean _isInNonTriggeredRoot = a.isInNonTriggeredRoot();
            if (_isInNonTriggeredRoot) {
                _builder.append("if(context.expectedMessagesEmpty()) {");
                _builder.newLine();
                _builder.append("    ");
                String _methodName = a.getTransitionFragment().getMethodName();
                _builder.append(_methodName, "    ");
                _builder.append("(stateName, message, context, result);");
                _builder.newLineIfNotEmpty();
                _builder.append("} else {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stateOfDecisionClass.setSubState(\"");
                String _nextState = a.getNextState();
                _builder.append(_nextState, "    ");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("updateState(stateOfDecisionClass, stateName, context);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("result.add(context);");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            } else {
                _builder.append("stateOfDecisionClass.setSubState(\"");
                String _nextState_1 = a.getNextState();
                _builder.append(_nextState_1);
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append("updateState(stateOfDecisionClass, stateName, context);");
                _builder.newLine();
                _builder.append("result.add(context);");
                _builder.newLine();
            }
        } else {
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            _builder.append("stateOfDecisionClass.setSubState(null);");
            _builder.newLine();
            _builder.append("stateOfDecisionClass.set_");
            String _machineName = a.getMachineName();
            _builder.append(_machineName);
            _builder.append("(");
            String _nextState_2 = a.getNextState();
            boolean bl = _tripleNotEquals = _nextState_2 != null;
            if (_tripleNotEquals) {
                _builder.append("\"");
                String _nextState_3 = a.getNextState();
                _builder.append(_nextState_3);
                _builder.append("\"");
            } else {
                _builder.append("stateName");
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("updateState(stateOfDecisionClass, stateName, ");
            String _nextState_4 = a.getNextState();
            boolean bl2 = _tripleNotEquals_1 = _nextState_4 != null;
            if (_tripleNotEquals_1) {
                _builder.append("\"");
                String _nextState_5 = a.getNextState();
                _builder.append(_nextState_5);
                _builder.append("\"");
            } else {
                _builder.append("stateName");
            }
            _builder.append(", context);");
            _builder.newLineIfNotEmpty();
            _builder.append("result.add(context);");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _messagePatternFromAction(EventCall a, InterfaceEvent ev) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("mp = new CNotificationPattern(); mp.setName(\"");
        String _name = a.getEvent().getName();
        _builder.append(_name);
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        EList _parameters = a.getParameters();
        for (Expression p : _parameters) {
            _builder.append("mp.addParameter(");
            CharSequence _generateExpression = this.generateExpression(p);
            _builder.append((Object)_generateExpression);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateActionInContext(EventWithVars a, InterfaceEvent ev) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if(!message.getName().equals(\"");
        String _name = a.getEvent().getName();
        _builder.append(_name);
        _builder.append("\")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        int _size = a.getParameters().size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            _builder.append("stateOfDecisionClass.set_");
            _builder.append("commaVar_");
            String _get = this.triggerVariables.get(a.getParameters().get(i.intValue()));
            _builder.append(_get);
            _builder.append("((");
            CharSequence _javaType = this.toJavaType((EObject)((Variable)a.getParameters().get(i.intValue())).getType());
            _builder.append((Object)_javaType);
            _builder.append(") message.getParameters().get(");
            _builder.append((Object)i);
            _builder.append("));");
            _builder.newLineIfNotEmpty();
        }
        Expression _condition = a.getCondition();
        boolean bl = _tripleNotEquals = _condition != null;
        if (_tripleNotEquals) {
            _builder.append("if(!");
            CharSequence _generateExpression = this.generateExpression(a.getCondition());
            _builder.append((Object)_generateExpression);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("return;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("mp = new CNotificationPattern(); mp.setName(\"");
        String _name_1 = a.getEvent().getName();
        _builder.append(_name_1);
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        EList _parameters = a.getParameters();
        for (Variable p : _parameters) {
            _builder.append("mp.addParameter(new CAny());");
            _builder.newLine();
        }
        _builder.append("context.addToExpectedMessages(new CMessageMultiplicityPattern(mp, 1, 1).setInterfaceState((CState)Utils.deepCopy(stateOfDecisionClass)));");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateActionInContext(CommandReplyWithVars a, InterfaceEvent ev) {
        boolean _greaterThan;
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        TriggeredTransition parentTransition = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)a, TriggeredTransition.class);
        String commandName = parentTransition.getTrigger().getName();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if(!message.getName().equals(\"");
        _builder.append(commandName);
        _builder.append("\")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        int _size = a.getParameters().size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            _builder.append("stateOfDecisionClass.set_");
            _builder.append("commaVar_");
            String _get = this.triggerVariables.get(a.getParameters().get(i.intValue()));
            _builder.append(_get);
            _builder.append("((");
            CharSequence _javaType = this.toJavaType((EObject)((Variable)a.getParameters().get(i.intValue())).getType());
            _builder.append((Object)_javaType);
            _builder.append(") message.getParameters().get(");
            _builder.append((Object)i);
            _builder.append("));");
            _builder.newLineIfNotEmpty();
        }
        Expression _condition = a.getCondition();
        boolean bl = _tripleNotEquals = _condition != null;
        if (_tripleNotEquals) {
            _builder.append("if(!");
            CharSequence _generateExpression = this.generateExpression(a.getCondition());
            _builder.append((Object)_generateExpression);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("return;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("mp = new CReplyPattern(); mp.setName(\"");
        _builder.append(commandName);
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        int _size_1 = a.getParameters().size();
        boolean bl2 = _greaterThan = _size_1 > 0;
        if (_greaterThan) {
            _builder.append("mp");
            EList _parameters = a.getParameters();
            for (Variable p : _parameters) {
                _builder.append(".addParameter(new CAny())");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("context.addToExpectedMessages(new CMessageMultiplicityPattern().setMessagePattern(mp).setInterfaceState((CState)Utils.deepCopy(stateOfDecisionClass)));");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _messagePatternFromAction(CommandReply a, InterfaceEvent ev) {
        boolean _greaterThan;
        StringConcatenation _xblockexpression = null;
        String commandName = "";
        if (ev != null && ev instanceof Command) {
            commandName = ev.getName();
        } else {
            boolean _tripleNotEquals;
            CommandEvent _command = a.getCommand();
            boolean bl = _tripleNotEquals = _command != null;
            if (_tripleNotEquals) {
                commandName = a.getCommand().getEvent().getName();
            } else {
                TriggeredTransition parentTransition = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)a, TriggeredTransition.class);
                if (parentTransition != null) {
                    commandName = parentTransition.getTrigger().getName();
                }
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("mp = new CReplyPattern(); ");
        if (commandName != null) {
            _builder.append("mp.setName(\"");
            _builder.append(commandName);
            _builder.append("\");");
        }
        _builder.newLineIfNotEmpty();
        int _size = a.getParameters().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("mp");
            EList _parameters = a.getParameters();
            for (Expression p : _parameters) {
                _builder.append(".addParameter(");
                CharSequence _generateExpression = this.generateExpression(p);
                _builder.append((Object)_generateExpression);
                _builder.append(")");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence getEventName(Transition t, Clause c) {
        StringConcatenation _xifexpression = null;
        if (t instanceof TriggeredTransition) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            String _name = ((TriggeredTransition)t).getTrigger().getName();
            _builder.append(_name, " ");
            _xifexpression = _builder;
        } else {
            StringConcatenation _xblockexpression = null;
            Set eventCalls = this.clauseFragments.get(t).get(c).getRootFragment().getHeadNotifications();
            StringConcatenation _xifexpression_1 = null;
            boolean _isEmpty = eventCalls.isEmpty();
            if (_isEmpty) {
                StringConcatenation _builder_1;
                _xifexpression_1 = _builder_1 = new StringConcatenation();
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(" ");
                String _name_1 = ((Notification[])Conversions.unwrapArray((Object)eventCalls, Notification.class))[0].getName();
                _builder_2.append(_name_1, " ");
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static CharSequence decisionClassName(Signature s) {
        StringConcatenation _builder = new StringConcatenation();
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)s).toString("_");
        _builder.append(_string);
        _builder.append("DecisionClass");
        return _builder;
    }

    public static CharSequence decisionClassName(Interface i) {
        StringConcatenation _builder = new StringConcatenation();
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)i).toString("_");
        _builder.append(_string);
        _builder.append("DecisionClass");
        return _builder;
    }

    @Override
    public CharSequence generateVariableReference(ExpressionVariable expr) {
        CharSequence _xblockexpression = null;
        EObject parent = expr.getVariable().eContainer();
        CharSequence _xifexpression = null;
        if (parent instanceof TriggeredTransition) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("stateOfDecisionClass.get_");
            _builder.append("commaVar_");
            String _get = this.triggerVariables.get(expr.getVariable());
            _builder.append(_get);
            _builder.append("()");
            _xifexpression = _builder;
        } else {
            CharSequence _xifexpression_1 = null;
            if (parent instanceof ActionWithVars) {
                StringConcatenation _xblockexpression_1 = null;
                EObject parentOfParent = ((ActionWithVars)parent).eContainer();
                StringConcatenation _xifexpression_2 = null;
                if (parentOfParent instanceof ParallelComposition || parentOfParent instanceof PCFragmentDefinition) {
                    StringConcatenation _xblockexpression_2 = null;
                    int index = ((ActionWithVars)parent).getParameters().indexOf((Object)expr.getVariable());
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("((");
                    CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)expr.getVariable().getType());
                    _builder_1.append((Object)_javaReferenceType);
                    _builder_1.append(")params.get(");
                    _builder_1.append((Object)index);
                    _builder_1.append("))");
                    _xifexpression_2 = _xblockexpression_2 = _builder_1;
                } else {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("stateOfDecisionClass.get_");
                    _builder_1.append("commaVar_");
                    String _get_1 = this.triggerVariables.get(expr.getVariable());
                    _builder_1.append(_get_1);
                    _builder_1.append("()");
                    _xifexpression_2 = _builder_1;
                }
                _xblockexpression_1 = _xifexpression_2;
                _xifexpression_1 = _xblockexpression_1;
            } else {
                _xifexpression_1 = super.generateVariableReference(expr);
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public CharSequence generateActionInContext(Object a, InterfaceEvent ev) {
        if (a instanceof CommandReply) {
            return this._generateActionInContext((CommandReply)a, ev);
        }
        if (a instanceof CommandReplyWithVars) {
            return this._generateActionInContext((CommandReplyWithVars)a, ev);
        }
        if (a instanceof EventCall) {
            return this._generateActionInContext((EventCall)a, ev);
        }
        if (a instanceof AssignmentAction) {
            return this._generateActionInContext((AssignmentAction)a, ev);
        }
        if (a instanceof EventWithVars) {
            return this._generateActionInContext((EventWithVars)a, ev);
        }
        if (a instanceof IfAction) {
            return this._generateActionInContext((IfAction)a, ev);
        }
        if (a instanceof ParallelComposition) {
            return this._generateActionInContext((ParallelComposition)a, ev);
        }
        if (a instanceof RecordFieldAssignmentAction) {
            return this._generateActionInContext((RecordFieldAssignmentAction)a, ev);
        }
        if (a instanceof FunctionFragmentCall) {
            return this._generateActionInContext((FunctionFragmentCall)a, ev);
        }
        if (a instanceof IfHelperAction) {
            return this._generateActionInContext((IfHelperAction)a, ev);
        }
        if (a instanceof StateTransitionAction) {
            return this._generateActionInContext((StateTransitionAction)a, ev);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(a, ev).toString());
    }

    public CharSequence messagePatternFromAction(EObject a, InterfaceEvent ev) {
        if (a instanceof CommandReply) {
            return this._messagePatternFromAction((CommandReply)a, ev);
        }
        if (a instanceof CommandReplyWithVars) {
            return this._messagePatternFromAction((CommandReplyWithVars)a, ev);
        }
        if (a instanceof EventCall) {
            return this._messagePatternFromAction((EventCall)a, ev);
        }
        if (a instanceof EventWithVars) {
            return this._messagePatternFromAction((EventWithVars)a, ev);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(a, ev).toString());
    }
}

