/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.editor.ServerEditor;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorInput;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class CloudFoundryActionProvider
extends CommonActionProvider {
    public void init(ICommonActionExtensionSite actionSite) {
        StructuredViewer viewer;
        super.init(actionSite);
        ICommonViewerSite site = actionSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (viewer = actionSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer serversViewer = (CommonViewer)viewer;
            serversViewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    IStructuredSelection selection;
                    Object[] selectedObjects;
                    ISelection s = event.getSelection();
                    if (s instanceof IStructuredSelection && (selectedObjects = (selection = (IStructuredSelection)s).toArray()).length == 1 && selectedObjects[0] instanceof ModuleServer) {
                        ModuleServer moduleServer = (ModuleServer)selectedObjects[0];
                        CloudFoundryActionProvider.this.openApplicationPage(moduleServer);
                    }
                }
            });
        }
    }

    private void openApplicationPage(ModuleServer moduleServer) {
        IModule[] modules = moduleServer.getModule();
        IServer server = moduleServer.getServer();
        CloudFoundryServer cloudServer = (CloudFoundryServer)server.loadAdapter(CloudFoundryServer.class, null);
        if (cloudServer != null && modules != null && modules.length == 1) {
            IWorkbenchWindow workbenchWindow = ServerUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            try {
                ServerEditor editor = (ServerEditor)page.openEditor((IEditorInput)new ServerEditorInput(server.getId()), "org.eclipse.wst.server.ui.editor");
                Method method = MultiPageEditorPart.class.getDeclaredMethod("setActivePage", Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)editor, 1);
                CloudFoundryApplicationsEditorPage editorPage = (CloudFoundryApplicationsEditorPage)((Object)editor.getSelectedPage());
                editorPage.selectAndReveal(modules[0]);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e.getStatus(), 1);
            }
            catch (SecurityException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.cft.server.ui", Messages.CloudFoundryActionProvider_ERROR_REFLECTION_CF_APP_PAGE, (Throwable)e), 1);
            }
            catch (NoSuchMethodException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.cft.server.ui", Messages.CloudFoundryActionProvider_ERROR_REFLECTION_CF_APP_PAGE, (Throwable)e), 1);
            }
            catch (IllegalArgumentException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.cft.server.ui", Messages.CloudFoundryActionProvider_ERROR_REFLECTION_CF_APP_PAGE, (Throwable)e), 1);
            }
            catch (IllegalAccessException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.cft.server.ui", Messages.CloudFoundryActionProvider_ERROR_REFLECTION_CF_APP_PAGE, (Throwable)e), 1);
            }
            catch (InvocationTargetException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.cft.server.ui", Messages.CloudFoundryActionProvider_ERROR_REFLECTION_CF_APP_PAGE, (Throwable)e), 1);
            }
        }
    }
}

