/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.pde;

import com.google.inject.Injector;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cbi.targetplatform.TargetPlatformStandaloneSetup;
import org.eclipse.cbi.targetplatform.pde.Converter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class ConverterApplication
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Map arguments = context.getArguments();
        String[] args = (String[])arguments.get("application.args");
        if (args.length <= 0) {
            System.out.println("Must provide path to a target form file");
            return -256;
        }
        String path = args[0];
        try {
            File pathAsFile = new File(path);
            if (pathAsFile.isFile()) {
                path = pathAsFile.getAbsoluteFile().toURI().toString();
            }
        }
        catch (RuntimeException pathAsFile) {
            // empty catch block
        }
        Injector injector = new TargetPlatformStandaloneSetup().createInjector();
        TargetPlatformStandaloneSetup.doSetup();
        Converter converter = new Converter();
        injector.injectMembers((Object)converter);
        URI uri = ConverterApplication.normalize(URI.createURI((String)path));
        Diagnostic diagnostic = converter.generateTargetDefinitionFile(uri, ConverterApplication.createPrintingMonitor());
        if (diagnostic.getSeverity() >= 2) {
            for (Diagnostic child : diagnostic.getChildren()) {
                ConverterApplication.printDiagnostic(child, "");
            }
        }
        if (diagnostic.getSeverity() == 4) {
            System.out.println("Problems occurred during generation of target platform definition file.");
            return -1;
        }
        if (diagnostic.getSeverity() == 8) {
            System.out.println("Operation cancelled.");
            return -2;
        }
        System.out.println("The target platform definition file has been successfully generated.");
        return 0;
    }

    private static IProgressMonitor createPrintingMonitor() {
        return BasicMonitor.toIProgressMonitor((Monitor)new BasicMonitor.Printing(System.out));
    }

    private static void printDiagnostic(Diagnostic diagnostic, String indent) {
        if (diagnostic.getSeverity() > 0) {
            System.out.print(indent);
            String severity = ConverterApplication.getSeverityString(diagnostic);
            System.out.println(String.valueOf(severity) + " " + diagnostic.getMessage());
            Iterator i = diagnostic.getChildren().iterator();
            while (i.hasNext()) {
                ConverterApplication.printDiagnostic((Diagnostic)i.next(), String.valueOf(indent) + "  ");
            }
        }
    }

    private static String getSeverityString(Diagnostic diagnostic) {
        String severity;
        switch (diagnostic.getSeverity()) {
            case 0: {
                severity = "[OK]     ";
                break;
            }
            case 1: {
                severity = "[INFO]   ";
                break;
            }
            case 2: {
                severity = "[WARNING]";
                break;
            }
            case 4: {
                severity = "[ERROR]  ";
                break;
            }
            case 8: {
                severity = "[CANCEL] ";
                break;
            }
            default: {
                severity = Integer.toHexString(diagnostic.getSeverity());
            }
        }
        return severity;
    }

    private static URI normalize(URI uri) {
        String fragment = uri.fragment();
        String query = uri.query();
        URI trimmedURI = uri.trimFragment().trimQuery();
        URI result = trimmedURI;
        String scheme = result.scheme();
        if (scheme == null) {
            result = result.hasAbsolutePath() ? URI.createURI((String)("file:" + result)) : URI.createFileURI((String)new File(result.toString()).getAbsolutePath());
        }
        if (result == trimmedURI) {
            return uri;
        }
        if (query != null) {
            result = result.appendQuery(query);
        }
        if (fragment != null) {
            result = result.appendFragment(fragment);
        }
        return result;
    }

    public void stop() {
    }
}

