/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.pde;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.cbi.targetplatform.TargetPlatformBundleActivator;
import org.eclipse.cbi.targetplatform.model.TargetPlatform;
import org.eclipse.cbi.targetplatform.model.TargetPlatformPackage;
import org.eclipse.cbi.targetplatform.pde.TargetDefinitionGenerator;
import org.eclipse.cbi.targetplatform.resolved.ResolvedTargetPlatform;
import org.eclipse.cbi.targetplatform.util.LocationIndexBuilder;
import org.eclipse.cbi.targetplatform.util.MavenLocationIndexBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.xtext.resource.XtextResourceSet;

public class Converter {
    private static final Pattern SEQUENCE_NUMBER__PATTERN = Pattern.compile("sequenceNumber\\s*=\\s*\"[0-9]+\"");
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private LocationIndexBuilder indexBuilder;
    @Inject
    private MavenLocationIndexBuilder mavenIndexBuilder;
    @Inject
    private IProvisioningAgent agent;

    public Diagnostic generateTargetDefinitionFile(URI uri, IProgressMonitor monitor) {
        BasicDiagnostic ret = new BasicDiagnostic("org.eclipse.cbi.targetplatform", 0, "Diagnostic of the generation of the target platform.", null);
        if (!"targetplatform".equals(uri.fileExtension()) && !"tpd".equals(uri.fileExtension())) {
            ret.merge((Diagnostic)new BasicDiagnostic(4, "org.eclipse.cbi.targetplatform", -1, "The target platform file '" + uri + "' must end with '.tpd' or '.targetplatform' extension.", null));
        } else {
            Diagnostic diagnostic = this.doGenerateTargetDefinitionFile(uri, monitor);
            if (diagnostic.getSeverity() >= 2) {
                ret.merge(diagnostic);
            }
        }
        return ret;
    }

    private Diagnostic doGenerateTargetDefinitionFile(URI uri, IProgressMonitor monitor) {
        BasicDiagnostic ret = new BasicDiagnostic();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            Resource resource = this.loadTargetPlatform(uri);
            subMonitor.worked(2);
            Diagnostic resourceDiagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true);
            if (resourceDiagnostic.getSeverity() >= 2) {
                ret.merge(resourceDiagnostic);
            }
            if (resourceDiagnostic.getSeverity() < 4) {
                TargetPlatform targetPlatform = null;
                if (resource != null && !resource.getContents().isEmpty()) {
                    targetPlatform = (TargetPlatform)resource.getContents().get(0);
                }
                if (targetPlatform == null) {
                    ret.merge((Diagnostic)new BasicDiagnostic(4, "org.eclipse.cbi.targetplatform", -1, "Error occurred while loading the file " + uri + ".", null));
                } else if (subMonitor.isCanceled()) {
                    ret.merge(Diagnostic.CANCEL_INSTANCE);
                } else {
                    Diagnostic diagnostic;
                    SubMonitor diagnosticianMonitor = subMonitor.newChild(90).setWorkRemaining(targetPlatform.getLocations().size());
                    Diagnostic validation = new CustomDiagnostician(diagnosticianMonitor).validate((EObject)targetPlatform);
                    if (validation.getSeverity() >= 2) {
                        ret.merge(validation);
                    } else if (subMonitor.isCanceled()) {
                        ret.merge(Diagnostic.CANCEL_INSTANCE);
                    }
                    if (validation.getSeverity() < 4 && (diagnostic = this.doGenerateTargetDefinitionFile(uri, targetPlatform, (IProgressMonitor)subMonitor.newChild(8))).getSeverity() >= 2) {
                        ret.merge(diagnostic);
                    }
                    subMonitor.setWorkRemaining(0);
                }
            }
        }
        catch (Exception e) {
            ret.merge(BasicDiagnostic.toDiagnostic((Throwable)e));
        }
        return ret;
    }

    private Diagnostic doGenerateTargetDefinitionFile(URI uri, TargetPlatform targetPlatform, IProgressMonitor monitor) {
        BasicDiagnostic ret = new BasicDiagnostic();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IMetadataRepositoryManager repositoryManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            ResolvedTargetPlatform resolvedTargetPlatform = ResolvedTargetPlatform.create(targetPlatform, this.indexBuilder, this.mavenIndexBuilder);
            subMonitor.worked(5);
            if (subMonitor.isCanceled()) {
                ret.merge(Diagnostic.CANCEL_INSTANCE);
            } else {
                Diagnostic diagnostic = resolvedTargetPlatform.resolve(repositoryManager, (IProgressMonitor)subMonitor.newChild(90));
                if (diagnostic.getSeverity() >= 2) {
                    ret.merge(diagnostic);
                }
                if (subMonitor.isCanceled()) {
                    ret.merge(Diagnostic.CANCEL_INSTANCE);
                } else if (ret.getSeverity() < 4) {
                    diagnostic = this.doGenerateTargetDefinitionFile(uri, resolvedTargetPlatform);
                    if (diagnostic.getSeverity() >= 2) {
                        ret.merge(diagnostic);
                    }
                    subMonitor.worked(5);
                }
            }
        }
        catch (Exception e) {
            ret.merge(BasicDiagnostic.toDiagnostic((Throwable)e));
        }
        return ret;
    }

    private Diagnostic doGenerateTargetDefinitionFile(URI uri, ResolvedTargetPlatform resolvedTargetPlatform) {
        BasicDiagnostic ret = new BasicDiagnostic();
        TargetDefinitionGenerator generator = new TargetDefinitionGenerator();
        String xml = generator.generate(resolvedTargetPlatform, (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        URI targetDefinitionLocation = uri.trimFileExtension().appendFileExtension("target");
        Diagnostic diagnostic = this.serialize(targetDefinitionLocation, xml);
        if (diagnostic.getSeverity() >= 2) {
            ret.merge(diagnostic);
        }
        return ret;
    }

    private Diagnostic serialize(URI targetPlatformLocation, String xml) {
        BasicDiagnostic ret = new BasicDiagnostic();
        URI targetDefinitionLocation = targetPlatformLocation.trimFileExtension().appendFileExtension("target");
        if (this.hasContentDifferencesOtherThanSequenceNumber(targetDefinitionLocation, xml)) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(new File(targetDefinitionLocation.toFileString())));){
                    ((OutputStream)outputStream).write(xml.getBytes());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                ret.merge(BasicDiagnostic.toDiagnostic((Throwable)e));
            }
        } else {
            ret.merge((Diagnostic)new BasicDiagnostic(1, "org.eclipse.cbi.targetplatform", -1, "The target definition '" + targetDefinitionLocation + "' did not change since previous generation, we did not overwrite it.", null));
        }
        return ret;
    }

    private boolean hasContentDifferencesOtherThanSequenceNumber(URI targetDefinitionLocation, String xml) {
        try {
            File targetDefinition = new File(targetDefinitionLocation.toFileString());
            if (targetDefinition.exists()) {
                String newXml;
                String oldXml = Files.asCharSource((File)targetDefinition, (Charset)Charsets.UTF_8).read();
                return !(oldXml = SEQUENCE_NUMBER__PATTERN.matcher(oldXml).replaceFirst("")).equals(newXml = SEQUENCE_NUMBER__PATTERN.matcher(xml).replaceFirst(""));
            }
        }
        catch (IOException e) {
            TargetPlatformBundleActivator.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.cbi.targetplatform", e.getMessage()));
        }
        return true;
    }

    private Resource loadTargetPlatform(URI fileLocation) {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        return resourceSet.getResource(fileLocation, true);
    }

    private static class CustomDiagnostician
    extends Diagnostician {
        private final SubMonitor monitor;

        public CustomDiagnostician(SubMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            if (this.monitor.isCanceled()) {
                return true;
            }
            if (eClass == TargetPlatformPackage.Literals.LOCATION) {
                context.put(IProgressMonitor.class, this.monitor.newChild(1));
            }
            return super.validate(eClass, eObject, diagnostics, context);
        }
    }
}

