/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import java.io.IOException;
import org.eclipse.egf.model.pattern.BackCall;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.SuperCall;
import org.eclipse.egf.model.pattern.util.PatternSwitch;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.egf.pattern.utils.TemplateFileHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public abstract class AssemblyContentProvider
extends PatternSwitch<String> {
    protected static final String OK = "ok";
    protected final Pattern pattern;
    protected StringBuilder content;

    public AssemblyContentProvider(Pattern pattern) {
        this.pattern = pattern;
    }

    protected abstract void call(MethodCall var1) throws PatternException;

    protected abstract void call(PatternCall var1) throws PatternException;

    protected abstract void call(BackCall var1) throws PatternException;

    protected abstract void call(SuperCall var1) throws PatternException;

    protected abstract void addMethodBodies() throws PatternException;

    protected abstract void call(PatternInjectedCall var1) throws PatternException;

    public String caseMethodCall(MethodCall object) {
        try {
            this.call(object);
            return OK;
        }
        catch (PatternException e) {
            throw new WrappedException(e);
        }
    }

    public String casePatternInjectedCall(PatternInjectedCall object) {
        try {
            this.call(object);
        }
        catch (PatternException e) {
            throw new WrappedException(e);
        }
        return OK;
    }

    public String caseBackCall(BackCall object) {
        try {
            this.call(object);
        }
        catch (PatternException e) {
            throw new WrappedException(e);
        }
        return OK;
    }

    public String casePatternCall(PatternCall object) {
        try {
            this.call(object);
        }
        catch (PatternException e) {
            throw new WrappedException(e);
        }
        return OK;
    }

    public String caseSuperCall(SuperCall object) {
        try {
            this.call(object);
        }
        catch (PatternException e) {
            throw new WrappedException(e);
        }
        return OK;
    }

    public String defaultCase(EObject object) {
        throw new IllegalStateException(NLS.bind((String)EGFPatternMessages.assembly_error1, (Object)object.eClass().getName()));
    }

    protected String getMethodContent(PatternMethod method) throws PatternException {
        try {
            return TemplateFileHelper.getContent(method);
        }
        catch (IOException e) {
            throw new PatternException((Throwable)e);
        }
    }

    public void setContent(StringBuilder content) {
        this.content = content;
    }

    static class WrappedException
    extends RuntimeException {
        static final long serialVersionUID = 1L;

        public WrappedException(Throwable cause) {
            super(cause);
        }
    }
}

