/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.progress;

import com.google.common.base.Strings;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.marker.GradleErrorMarker;
import org.eclipse.buildship.core.internal.util.progress.ProblemEventAdapter;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.problems.FileLocation;
import org.gradle.tooling.events.problems.LineInFileLocation;
import org.gradle.tooling.events.problems.Location;
import org.gradle.tooling.events.problems.OffsetInFileLocation;
import org.gradle.tooling.events.problems.ProblemAggregation;
import org.gradle.tooling.events.problems.ProblemAggregationEvent;
import org.gradle.tooling.events.problems.ProblemContext;
import org.gradle.tooling.events.problems.ProblemDefinition;
import org.gradle.tooling.events.problems.ProblemEvent;
import org.gradle.tooling.events.problems.Severity;
import org.gradle.tooling.events.problems.SingleProblemEvent;

public class ProblemsReportingProgressListener
implements ProgressListener {
    private InternalGradleBuild gradleBuild;

    public ProblemsReportingProgressListener(InternalGradleBuild gradleBuild) {
        this.gradleBuild = gradleBuild;
    }

    public void statusChanged(ProgressEvent event) {
        if (event instanceof ProblemEvent) {
            ProblemEvent problemEvent = (ProblemEvent)event;
            try {
                if (problemEvent instanceof SingleProblemEvent) {
                    this.reportProblem((SingleProblemEvent)problemEvent);
                } else if (problemEvent instanceof ProblemAggregationEvent) {
                    this.reportProblem((ProblemAggregationEvent)problemEvent);
                }
            }
            catch (Exception e) {
                CorePlugin.logger().warn("Cannot report problem " + String.valueOf(problemEvent), e);
            }
        }
    }

    private void reportProblem(SingleProblemEvent event) {
        List locations = event.getLocations();
        GradleErrorMarker.createProblemMarker(this.toMarkerSeverity(event.getDefinition().getSeverity()), this.findMarkerResource(locations), this.gradleBuild, ProblemsReportingProgressListener.markerMessage(event), ProblemsReportingProgressListener.stacktraceStringFor(event.getFailure().getFailure()), this.markerPositionConfiguration(locations), ProblemEventAdapter.adapterFor(event));
    }

    private void reportProblem(ProblemAggregationEvent event) {
        ProblemAggregation aggregation = event.getProblemAggregation();
        ProblemDefinition definition = aggregation.getDefinition();
        List contexts = aggregation.getProblemContext();
        for (ProblemContext context : contexts) {
            List locations = context.getLocations();
            GradleErrorMarker.createProblemMarker(this.toMarkerSeverity(definition.getSeverity()), this.findMarkerResource(locations), this.gradleBuild, ProblemsReportingProgressListener.markerMessage(context.getDetails().getDetails(), context.getDetails().getDetails(), definition.getId().getDisplayName()), ProblemsReportingProgressListener.stacktraceStringFor(context.getFailure().getFailure()), this.markerPositionConfiguration(locations), ProblemEventAdapter.adapterFor(definition, context));
        }
    }

    private IResource findMarkerResource(List<Location> locations) {
        return locations.stream().filter(FileLocation.class::isInstance).map(FileLocation.class::cast).findFirst().map(fl -> ProblemsReportingProgressListener.toResource(fl)).orElseGet(() -> {
            IFile result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)this.rootProjectPath()));
            return result == null ? ResourcesPlugin.getWorkspace().getRoot() : result;
        });
    }

    private String rootProjectPath() {
        return this.gradleBuild.getBuildConfig().getRootProjectDirectory().getAbsolutePath();
    }

    private Consumer<IMarker> markerPositionConfiguration(List<Location> locations) {
        for (Location location : locations) {
            if (location instanceof OffsetInFileLocation) {
                return marker -> {
                    OffsetInFileLocation offsetLocation = (OffsetInFileLocation)location;
                    int startOffset = offsetLocation.getOffset();
                    int endOffset = offsetLocation.getLength();
                    try {
                        marker.setAttribute("charStart", startOffset);
                        marker.setAttribute("charEnd", startOffset + endOffset);
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            if (!(location instanceof LineInFileLocation)) continue;
            return marker -> {
                Integer lineNumber = ProblemsReportingProgressListener.lineNumberOf((FileLocation)location);
                if (lineNumber >= 0) {
                    try {
                        marker.setAttribute("lineNumber", (Object)lineNumber);
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        return notUsed -> {};
    }

    private static String markerMessage(SingleProblemEvent problem) {
        String result = problem.getContextualLabel().getContextualLabel();
        if (result == null) {
            result = problem.getDetails().getDetails();
        }
        if (result == null) {
            result = problem.getDefinition().getId().getDisplayName();
        }
        return Strings.nullToEmpty((String)result);
    }

    private static String markerMessage(String contextualLabel, String details, String definitionDisplayName) {
        String result = contextualLabel;
        if (result == null) {
            result = details;
        }
        if (result == null) {
            result = definitionDisplayName;
        }
        return Strings.nullToEmpty((String)result);
    }

    private static String stacktraceStringFor(Failure failure) {
        if (failure == null) {
            return null;
        }
        return failure.getDescription();
    }

    private static IResource toResource(FileLocation location) {
        IPath absolutePath = Path.fromOSString((String)location.getPath());
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile workspacePath = workspaceRoot.getFileForLocation(absolutePath);
        if (workspacePath != null && workspacePath.exists()) {
            return workspacePath;
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private static Integer lineNumberOf(FileLocation location) {
        if (location instanceof LineInFileLocation && ((LineInFileLocation)location).getLine() > 0) {
            return ((LineInFileLocation)location).getLine();
        }
        return -1;
    }

    public int toMarkerSeverity(Severity severity) {
        if (severity == Severity.ERROR) {
            return 2;
        }
        if (severity == Severity.ADVICE) {
            return 0;
        }
        return 1;
    }
}

