/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.ExprUtil;
import org.eclipse.birt.data.engine.olap.api.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.CubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.DimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMirroredDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.AddingNestAggregations;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinitionIOUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CubeQueryDefinitionIOUtilTest {
    private File tempFile;
    private String queryResultID = "qurs0";

    @Before
    public void cubeQueryDefinitionIOUtilSetUp() throws Exception {
        this.tempFile = File.createTempFile(CubeQueryDefinitionIOUtilTest.class.getSimpleName(), null);
        this.tempFile.deleteOnExit();
    }

    @After
    public void cubeQueryDefinitionIOUtilTearDown() throws Exception {
        this.tempFile.delete();
    }

    @Test
    public void testSaveAndLoad() throws IOException, BirtException {
        FileArchiveWriter writer = new FileArchiveWriter(this.tempFile.getAbsolutePath());
        ICubeQueryDefinition toSave = this.createQueryDefn();
        DataEngineContext context = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writer);
        CubeQueryDefinitionIOUtil.save((String)this.queryResultID, (DataEngineContext)context, (ICubeQueryDefinition)toSave);
        writer.flush();
        writer.finish();
        FileArchiveReader reader = new FileArchiveReader(this.tempFile.getAbsolutePath());
        ICubeQueryDefinition loaded = CubeQueryDefinitionIOUtil.load((String)this.queryResultID, (DataEngineContext)DataEngineContext.newInstance((int)4, null, (IDocArchiveReader)reader, (IDocArchiveWriter)writer));
        reader.close();
        Assert.assertEquals((Object)toSave.getName(), (Object)loaded.getName());
        Assert.assertEquals((Object)toSave.cacheQueryResults(), (Object)loaded.cacheQueryResults());
        Assert.assertEquals((long)toSave.getFilterOption(), (long)loaded.getFilterOption());
        this.assertEqualBindings(toSave.getBindings(), loaded.getBindings());
        Assert.assertEquals((long)toSave.getFilters().size(), (long)loaded.getFilters().size());
        int i = 0;
        while (i < toSave.getFilters().size()) {
            this.assertEqualFilter((IFilterDefinition)toSave.getFilters().get(i), (IFilterDefinition)loaded.getFilters().get(i));
            ++i;
        }
        Assert.assertEquals((long)toSave.getSorts().size(), (long)loaded.getSorts().size());
        i = 0;
        while (i < toSave.getSorts().size()) {
            this.assertEqualSortDefinition((ISortDefinition)toSave.getSorts().get(i), (ISortDefinition)loaded.getSorts().get(i));
            ++i;
        }
        Assert.assertEquals((long)toSave.getMeasures().size(), (long)loaded.getMeasures().size());
        i = 0;
        while (i < toSave.getMeasures().size()) {
            this.assertEqualMeasure((IMeasureDefinition)toSave.getMeasures().get(i), (IMeasureDefinition)loaded.getMeasures().get(i));
            ++i;
        }
        Assert.assertEquals((long)toSave.getComputedMeasures().size(), (long)loaded.getComputedMeasures().size());
        i = 0;
        while (i < toSave.getComputedMeasures().size()) {
            this.assertEqualComputedMeasure((IComputedMeasureDefinition)toSave.getComputedMeasures().get(i), (IComputedMeasureDefinition)loaded.getComputedMeasures().get(i));
            ++i;
        }
        this.assertEqualEdge(toSave.getEdge(1), loaded.getEdge(1));
        this.assertEqualEdge(toSave.getEdge(2), loaded.getEdge(2));
        this.assertEqualEdge(toSave.getEdge(3), loaded.getEdge(3));
        Assert.assertEquals((long)toSave.getCubeOperations().length, (long)loaded.getCubeOperations().length);
        i = 0;
        while (i < toSave.getCubeOperations().length) {
            this.assertEqualCubeOperation(toSave.getCubeOperations()[i], loaded.getCubeOperations()[i]);
            ++i;
        }
    }

    private ICubeQueryDefinition createQueryDefn() throws DataException {
        CubeQueryDefinition cqd = new CubeQueryDefinition("query");
        cqd.setCacheQueryResults(true);
        cqd.setFilterOption(1);
        for (IBinding b : this.createBindings()) {
            cqd.addBinding(b);
        }
        cqd.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("true")));
        Object[] objectArray = new Object[3];
        objectArray[1] = 89;
        objectArray[2] = "tt";
        cqd.addFilter((IFilterDefinition)new CubeFilterDefinition((IBaseExpression)new ScriptExpression("false"), (ILevelDefinition)((IHierarchyDefinition)this.createDimension("dim1").getHierarchy().get(0)).getLevels().get(0), ((IHierarchyDefinition)this.createDimension("dim1").getHierarchy().get(0)).getLevels().toArray(new ILevelDefinition[0]), objectArray));
        for (ISortDefinition sort : this.createSortDefns()) {
            cqd.addSort(sort);
        }
        IMeasureDefinition md = cqd.createMeasure("md1");
        this.initMeasue(md, "SUM");
        md = cqd.createMeasure("md2");
        this.initMeasue(md, null);
        IComputedMeasureDefinition cmd = cqd.createComputedMeasure("cmd1", 2, (IBaseExpression)new ScriptExpression("5"));
        this.initComputedMeasure(cmd);
        cmd = cqd.createComputedMeasure("cmd1", 1, (IBaseExpression)new ScriptExpression("false"));
        this.initComputedMeasure(cmd);
        IEdgeDefinition ed = cqd.createEdge(1);
        this.initEdge(ed, true);
        ed = cqd.createEdge(3);
        this.initEdge(ed, false);
        cqd.addCubeOperation((ICubeOperation)new AddingNestAggregations(this.createBindings().toArray(new IBinding[0])));
        cqd.addCubeOperation((ICubeOperation)new AddingNestAggregations(this.createBindings().toArray(new IBinding[0])));
        return cqd;
    }

    private List<IBinding> createBindings() throws DataException {
        ArrayList<IBinding> result = new ArrayList<IBinding>();
        int i = 0;
        while (i <= 1) {
            Binding b = new Binding(String.valueOf(i));
            b.setAggrFunction("SUM");
            b.setDataType(2);
            b.setExpression((IBaseExpression)new ScriptExpression("5+5"));
            b.setFilter((IBaseExpression)new ScriptExpression("true"));
            int j = 0;
            while (j <= 1) {
                b.addArgument((IBaseExpression)new ScriptExpression("5+5"));
                ++j;
            }
            j = 0;
            while (j <= 1) {
                b.addAggregateOn("level" + j);
                ++j;
            }
            result.add((IBinding)b);
            ++i;
        }
        return result;
    }

    private List<ISortDefinition> createSortDefns() throws DataException {
        ArrayList<ISortDefinition> result = new ArrayList<ISortDefinition>();
        SortDefinition sd = new SortDefinition();
        sd.setColumn("col");
        sd.setExpression("true");
        sd.setSortDirection(1);
        sd.setSortStrength(-1);
        sd.setSortLocale(new ULocale("CN"));
        result.add((ISortDefinition)sd);
        int i = 0;
        while (i <= 1) {
            CubeSortDefinition csd = new CubeSortDefinition();
            if (i == 1) {
                csd.setSortStrength(-2);
                csd.setAxisQualifierLevels(((IHierarchyDefinition)this.createDimension("dim1").getHierarchy().get(0)).getLevels().toArray(new ILevelDefinition[0]));
                csd.setAxisQualifierValues(new Object[]{1, "tt"});
            }
            csd.setColumn("col");
            csd.setExpression("true");
            csd.setSortDirection(1);
            if (i == 1) {
                csd.setSortLocale(new ULocale("CN"));
            }
            if (i == 1) {
                csd.setTargetLevel(csd.getAxisQualifierLevels()[0]);
            }
            ++i;
        }
        return result;
    }

    private IDimensionDefinition createDimension(String name) {
        DimensionDefinition dd = new DimensionDefinition(name);
        this.initDim((IDimensionDefinition)dd);
        return dd;
    }

    private void initDim(IDimensionDefinition dd) {
        IHierarchyDefinition hd1 = dd.createHierarchy("hierarchy1");
        hd1.createLevel("level1");
        hd1.createLevel("level2");
        IHierarchyDefinition hd2 = dd.createHierarchy("hierarchy2");
        hd2.createLevel("level1");
        hd2.createLevel("level2");
    }

    private void assertEqualDim(IDimensionDefinition dd1, IDimensionDefinition dd2) {
        if (dd1 == null) {
            Assert.assertEquals(null, (Object)dd2);
            return;
        }
        Assert.assertEquals((Object)dd1.getName(), (Object)dd2.getName());
        int i = 0;
        for (IHierarchyDefinition hd : dd1.getHierarchy()) {
            Assert.assertEquals((Object)hd.getName(), (Object)((IHierarchyDefinition)dd2.getHierarchy().get(i)).getName());
            int j = 0;
            for (ILevelDefinition ld : hd.getLevels()) {
                Assert.assertEquals((Object)ld.getName(), (Object)((ILevelDefinition)((IHierarchyDefinition)dd2.getHierarchy().get(i)).getLevels().get(j)).getName());
                ++j;
            }
            ++i;
        }
    }

    private void assertEqualHierarchy(IHierarchyDefinition hd1, IHierarchyDefinition hd2) {
        if (hd1 == null) {
            Assert.assertEquals(null, (Object)hd2);
            return;
        }
        Assert.assertEquals((Object)hd1.getName(), (Object)hd2.getName());
        this.assertEqualDim(hd1.getDimension(), hd2.getDimension());
        int j = 0;
        for (ILevelDefinition ld : hd1.getLevels()) {
            Assert.assertEquals((Object)ld.getName(), (Object)((ILevelDefinition)hd2.getLevels().get(j)).getName());
            ++j;
        }
    }

    private void assertEqualLevel(ILevelDefinition ld1, ILevelDefinition ld2) {
        if (ld1 == null) {
            Assert.assertEquals(null, (Object)ld2);
            return;
        }
        Assert.assertTrue((ld2 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)ld1.getName(), (Object)ld2.getName());
        this.assertEqualHierarchy(ld1.getHierarchy(), ld2.getHierarchy());
    }

    private void assertEqualBinding(IBinding b1, IBinding b2) throws DataException {
        Assert.assertEquals((Object)b1.getBindingName(), (Object)b2.getBindingName());
        Assert.assertEquals((long)b1.getDataType(), (long)b2.getDataType());
        Assert.assertEquals((Object)b1.getAggrFunction(), (Object)b2.getAggrFunction());
        this.assertEqualExpr(b1.getExpression(), b2.getExpression());
        this.assertEqualExpr(b1.getFilter(), b2.getFilter());
        int i = 0;
        while (i < b1.getArguments().size()) {
            this.assertEqualExpr((IBaseExpression)b1.getArguments().get(i), (IBaseExpression)b2.getArguments().get(i));
            ++i;
        }
        i = 0;
        while (i < b1.getAggregatOns().size()) {
            Assert.assertEquals(b1.getAggregatOns().get(i), b2.getAggregatOns().get(i));
            ++i;
        }
    }

    private void assertEqualLocale(ULocale u1, ULocale u2) {
        if (u1 == null) {
            Assert.assertEquals(null, (Object)u2);
            return;
        }
        Assert.assertEquals((Object)u1.getBaseName(), (Object)u2.getBaseName());
    }

    private void assertEqualExpr(IBaseExpression expr1, IBaseExpression expr2) {
        if (expr1 == null) {
            Assert.assertEquals(null, (Object)expr2);
            return;
        }
        Assert.assertTrue((boolean)(expr1 instanceof IScriptExpression));
        Assert.assertTrue((boolean)(expr2 instanceof IScriptExpression));
        Assert.assertEquals((Object)((IScriptExpression)expr1).getText(), (Object)((IScriptExpression)expr2).getText());
    }

    private void assertEqualBindings(List<IBinding> bs1, List<IBinding> bs2) throws DataException {
        Assert.assertEquals((long)bs1.size(), (long)bs2.size());
        int i = 0;
        for (IBinding b1 : bs1) {
            this.assertEqualBinding(b1, bs2.get(i));
            ++i;
        }
    }

    private void initMeasue(IMeasureDefinition md, String aggrFunc) {
        md.setAggrFunction(aggrFunc);
    }

    private void initComputedMeasure(IComputedMeasureDefinition cmd) {
        cmd.setAggrFunction("SUM");
    }

    private void assertEqualMeasure(IMeasureDefinition md1, IMeasureDefinition md2) {
        Assert.assertEquals((Object)md1.getName(), (Object)md2.getName());
        Assert.assertEquals((Object)md1.getAggrFunction(), (Object)md2.getAggrFunction());
    }

    private void assertEqualComputedMeasure(IComputedMeasureDefinition md1, IComputedMeasureDefinition md2) throws DataException {
        this.assertEqualMeasure((IMeasureDefinition)md1, (IMeasureDefinition)md2);
        Assert.assertEquals((long)md1.getDataType(), (long)md2.getDataType());
        this.assertEqualExpr(md1.getExpression(), md2.getExpression());
    }

    private void initEdge(IEdgeDefinition ed, boolean createMirrorDefn) throws DataException {
        IDimensionDefinition dd = ed.createDimension("dim1");
        this.initDim(dd);
        dd = ed.createDimension("dim2");
        this.initDim(dd);
        if (createMirrorDefn) {
            ed.setMirrorStartingLevel((ILevelDefinition)((IHierarchyDefinition)dd.getHierarchy().get(0)).getLevels().get(0));
        }
        IEdgeDrillFilter edf = ed.createDrillFilter("edf1");
        this.initEdgeDrillFilter(edf);
        edf = ed.createDrillFilter("edf2");
        this.initEdgeDrillFilter(edf);
    }

    private void initEdgeDrillFilter(IEdgeDrillFilter edf) throws DataException {
        edf.addLevelFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("true")));
        edf.addLevelFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
        for (ISortDefinition sd : this.createSortDefns()) {
            edf.addLevelSort(sd);
        }
        edf.setTargetHierarchy((IHierarchyDefinition)this.createDimension("dim1").getHierarchy().get(0));
        edf.setTargetLevelName(((ILevelDefinition)edf.getTargetHierarchy().getLevels().get(0)).getName());
        ArrayList<Object[]> tuples = new ArrayList<Object[]>();
        tuples.add(new Object[]{"45", 45, true});
        tuples.add(new Object[0]);
        tuples.add(new Object[]{1, "tt"});
        edf.setTuple(tuples);
    }

    private void assertEqualEdgeDrillFilter(IEdgeDrillFilter edf1, IEdgeDrillFilter edf2) {
        Assert.assertEquals((long)edf1.getLevelFilter().size(), (long)edf2.getLevelFilter().size());
        int i = 0;
        while (i < edf1.getLevelFilter().size()) {
            this.assertEqualExpr(((FilterDefinition)edf1.getLevelFilter().get(i)).getExpression(), ((FilterDefinition)edf2.getLevelFilter().get(i)).getExpression());
            ++i;
        }
        Assert.assertEquals((long)edf1.getLevelSort().size(), (long)edf2.getLevelSort().size());
        i = 0;
        while (i < edf1.getLevelSort().size()) {
            ISortDefinition s1 = (ISortDefinition)edf1.getLevelSort().get(i);
            ISortDefinition s2 = (ISortDefinition)edf2.getLevelSort().get(i);
            this.assertEqualSortDefinition(s1, s2);
            ++i;
        }
        this.assertEqualHierarchy(edf1.getTargetHierarchy(), edf2.getTargetHierarchy());
        Assert.assertEquals((Object)edf1.getTargetLevelName(), (Object)edf2.getTargetLevelName());
        Assert.assertTrue((boolean)Arrays.deepEquals(edf1.getTuple().toArray(), edf2.getTuple().toArray()));
    }

    private void assertEqualEdge(IEdgeDefinition ed1, IEdgeDefinition ed2) {
        if (ed1 == null) {
            Assert.assertEquals(null, (Object)ed2);
            return;
        }
        Assert.assertEquals((Object)ed1.getName(), (Object)ed2.getName());
        Assert.assertEquals((long)ed1.getDimensions().size(), (long)ed2.getDimensions().size());
        int i = 0;
        for (IDimensionDefinition dd : ed1.getDimensions()) {
            this.assertEqualDim(dd, (IDimensionDefinition)ed2.getDimensions().get(i));
            ++i;
        }
        this.assertEqualMirroredDefn(ed1.getMirroredDefinition(), ed2.getMirroredDefinition());
        Assert.assertEquals((long)ed1.getDrillFilter().size(), (long)ed2.getDrillFilter().size());
        i = 0;
        for (IEdgeDrillFilter edf : ed1.getDrillFilter()) {
            this.assertEqualEdgeDrillFilter(edf, (IEdgeDrillFilter)ed2.getDrillFilter().get(i));
            ++i;
        }
    }

    private void assertEqualMirroredDefn(IMirroredDefinition md1, IMirroredDefinition md2) {
        if (md1 == null) {
            Assert.assertTrue((md2 == null ? 1 : 0) != 0);
            return;
        }
        Assert.assertTrue((md2 != null ? 1 : 0) != 0);
        this.assertEqualLevel(md1.getMirrorStartingLevel(), md2.getMirrorStartingLevel());
        Assert.assertEquals((Object)md1.isBreakHierarchy(), (Object)md2.isBreakHierarchy());
    }

    private void assertEqualCubeOperation(ICubeOperation co1, ICubeOperation co2) throws DataException {
        Assert.assertEquals(co1.getClass(), co2.getClass());
        this.assertEqualBindings(Arrays.asList(co1.getNewBindings()), Arrays.asList(co1.getNewBindings()));
    }

    private void assertEqualFilter(IFilterDefinition fd1, IFilterDefinition fd2) throws DataException {
        if (fd1 == null) {
            Assert.assertEquals(null, (Object)fd2);
            return;
        }
        Assert.assertEquals(fd1.getClass(), fd2.getClass());
        Assert.assertEquals((Object)true, (Object)ExprUtil.isEqualExpression((IBaseExpression)fd1.getExpression(), (IBaseExpression)fd2.getExpression()));
        if (fd1 instanceof ICubeFilterDefinition) {
            ICubeFilterDefinition csd1 = (ICubeFilterDefinition)fd1;
            ICubeFilterDefinition csd2 = (ICubeFilterDefinition)fd2;
            Assert.assertEquals((long)csd1.getAxisQualifierLevels().length, (long)csd2.getAxisQualifierLevels().length);
            int i = 0;
            ILevelDefinition[] iLevelDefinitionArray = csd1.getAxisQualifierLevels();
            int n = iLevelDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILevelDefinition ld = iLevelDefinitionArray[n2];
                this.assertEqualLevel(ld, csd2.getAxisQualifierLevels()[i]);
                ++i;
                ++n2;
            }
            Assert.assertTrue((boolean)Arrays.deepEquals(csd1.getAxisQualifierValues(), csd2.getAxisQualifierValues()));
        }
    }

    private void assertEqualSortDefinition(ISortDefinition sd1, ISortDefinition sd2) {
        if (sd1 == null) {
            Assert.assertEquals(null, (Object)sd2);
            return;
        }
        Assert.assertEquals(sd1.getClass(), sd2.getClass());
        Assert.assertEquals((Object)sd1.getColumn(), (Object)sd2.getColumn());
        Assert.assertEquals((long)sd1.getSortDirection(), (long)sd2.getSortDirection());
        Assert.assertEquals((long)sd1.getSortStrength(), (long)sd2.getSortStrength());
        this.assertEqualExpr((IBaseExpression)sd1.getExpression(), (IBaseExpression)sd2.getExpression());
        this.assertEqualLocale(sd1.getSortLocale(), sd2.getSortLocale());
        if (sd1 instanceof ICubeSortDefinition) {
            ICubeSortDefinition s1 = (ICubeSortDefinition)sd1;
            ICubeSortDefinition s2 = (ICubeSortDefinition)sd2;
            Assert.assertTrue((boolean)Arrays.equals(s1.getAxisQualifierValues(), s2.getAxisQualifierValues()));
            if (s1.getAxisQualifierLevels() == null) {
                Assert.assertEquals(null, (Object[])s2.getAxisQualifierLevels());
            } else {
                Assert.assertTrue((s2.getAxisQualifierLevels() != null ? 1 : 0) != 0);
                Assert.assertEquals((long)s1.getAxisQualifierLevels().length, (long)s2.getAxisQualifierLevels().length);
                int i = 0;
                ILevelDefinition[] iLevelDefinitionArray = s1.getAxisQualifierLevels();
                int n = iLevelDefinitionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILevelDefinition ld = iLevelDefinitionArray[n2];
                    this.assertEqualLevel(ld, s2.getAxisQualifierLevels()[i]);
                    ++i;
                    ++n2;
                }
            }
            this.assertEqualLevel(s1.getTargetLevel(), s2.getTargetLevel());
        }
    }
}

