/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import org.eclipse.birt.data.aggregation.impl.BuildInAggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.junit.Assert;
import org.junit.Test;

public class FinanceTest {
    private BuildInAggregationFactory buildInAggrFactory = new BuildInAggregationFactory();

    @Test
    public void testIrr() throws Exception {
        double[] b = new double[]{-70000.0, 12000.0, 15000.0, 18000.0, 21000.0, 26000.0};
        double[] a = new double[]{-70000.0, 12000.0, 15000.0};
        double[] c = new double[]{-70000.0, 12000.0, 15000.0, 18000.0, 21000.0};
        double[] d = new double[]{-70000.0, 22000.0, 25000.0, 30000.0, 31000.0};
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("irr");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"IRR", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < b.length) {
            ac.onRow(new Object[]{new Double(b[i]), new Double(0.1)});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((double)0.0866, (double)((Double)ac.getValue()), (double)1.0E-4);
        ac.start();
        i = 0;
        while (i < a.length) {
            ac.onRow(new Object[]{new Double(a[i]), new Double(-0.6)});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((double)-0.44, (double)((Double)ac.getValue()), (double)0.01);
        ac.start();
        i = 0;
        while (i < a.length) {
            ac.onRow(new Object[]{new Double(a[i]), new Double(2.3)});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((double)Double.NaN, (double)((Double)ac.getValue()), (double)0.01);
        ac.start();
        i = 0;
        while (i < c.length) {
            ac.onRow(new Object[]{new Double(c[i]), new Double(-0.1)});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((double)-0.021244, (double)((Double)ac.getValue()), (double)1.0E-6);
        ac.start();
        i = 0;
        while (i < d.length) {
            ac.onRow(new Object[]{new Double(d[i]), new Double(0.05)});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((double)0.19, (double)((Double)ac.getValue()), (double)0.01);
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testMirr() throws Exception {
        double[] a = new double[]{-120000.0, 39000.0, 30000.0, 21000.0, 37000.0, 46000.0};
        double[] b = new double[]{-120000.0, 39000.0, 30000.0, 21000.0};
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("mirr");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"MIRR", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)3L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[2].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < a.length) {
            ac.onRow(new Object[]{new Double(a[i]), new Double(0.1), new Double(0.14)});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((double)0.13475911082831482, (double)((Double)ac.getValue()), (double)Double.MIN_VALUE);
        ac.start();
        i = 0;
        while (i < b.length) {
            ac.onRow(new Object[]{new Double(b[i]), new Double(0.1), new Double(0.12)});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((double)-0.048044655249980806, (double)((Double)ac.getValue()), (double)Double.MIN_VALUE);
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testNpv() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("npv");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"NPV", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertFalse((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        double[] a = new double[]{-10000.0, 3000.0, 4200.0, 6800.0};
        ac.start();
        int i = 0;
        while (i < a.length) {
            ac.onRow(new Object[]{new Double(a[i]), new Double(0.1)});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((double)1188.4434123352216, (double)((Double)ac.getValue()), (double)Double.MIN_VALUE);
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testRunningNpv() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("runningnpv");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"RUNNINGNPV", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertFalse((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        double[] a = new double[]{-10000.0, 3000.0, 4200.0, 6800.0};
        double[] b = new double[]{-9090.90909090909, -6611.570247933883, -3456.0480841472577, 1188.4434123352216};
        ac.start();
        int i = 0;
        while (i < a.length) {
            ac.onRow(new Object[]{new Double(a[i]), new Double(0.1), new Double(0.14)});
            Assert.assertEquals((double)b[i], (double)((Double)ac.getValue()), (double)Double.MIN_VALUE);
            ++i;
        }
        ac.finish();
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
    }
}

