/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.List;
import java.util.Map;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.shared.common.sanity.SanityManager;

class Lock
implements Latch,
Control {
    private final CompatibilitySpace space;
    private final Lockable ref;
    private final Object qualifier;
    int count;

    protected Lock(CompatibilitySpace space, Lockable ref, Object qualifier) {
        this.space = space;
        this.ref = ref;
        this.qualifier = qualifier;
    }

    @Override
    public final Lockable getLockable() {
        return this.ref;
    }

    @Override
    public final CompatibilitySpace getCompatabilitySpace() {
        return this.space;
    }

    @Override
    public final Object getQualifier() {
        return this.qualifier;
    }

    @Override
    public final int getCount() {
        return this.count;
    }

    final Lock copy() {
        return new Lock(this.space, this.ref, this.qualifier);
    }

    void grant() {
        ++this.count;
        this.ref.lockEvent(this);
    }

    int unlock(int unlockCount) {
        if (unlockCount > this.count) {
            unlockCount = this.count;
        }
        this.count -= unlockCount;
        if (this.count == 0) {
            this.ref.unlockEvent(this);
        }
        return unlockCount;
    }

    public final int hashCode() {
        return this.ref.hashCode() ^ this.space.hashCode();
    }

    public final boolean equals(Object other) {
        if (other instanceof Lock) {
            Lock ol = (Lock)other;
            return this.space == ol.space && this.ref.equals(ol.ref) && this.qualifier == ol.qualifier;
        }
        return false;
    }

    @Override
    public LockControl getLockControl() {
        return new LockControl(this, this.ref);
    }

    @Override
    public Lock getLock(CompatibilitySpace compatibilitySpace, Object qualifier) {
        if (this.space == compatibilitySpace && this.qualifier == qualifier) {
            return this;
        }
        return null;
    }

    @Override
    public Control shallowClone() {
        return this;
    }

    @Override
    public ActiveLock firstWaiter() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean unlock(Latch lockInGroup, int unlockCount) {
        if (unlockCount == 0) {
            unlockCount = lockInGroup.getCount();
        }
        if (unlockCount > this.getCount()) {
            SanityManager.THROWASSERT(this + " unlockCount " + unlockCount + " is greater than lockCount " + this.getCount());
        }
        if (!this.equals(lockInGroup)) {
            SanityManager.THROWASSERT(this + " mismatched locks " + lockInGroup);
        }
        this.unlock(unlockCount);
        return false;
    }

    public void addWaiters(Map waiters) {
    }

    @Override
    public Lock getFirstGrant() {
        return this;
    }

    @Override
    public List getGranted() {
        return null;
    }

    @Override
    public List getWaiting() {
        return null;
    }

    @Override
    public boolean isGrantable(boolean noWaitersBeforeMe, CompatibilitySpace compatibilitySpace, Object requestQualifier) {
        if (this.space == compatibilitySpace && this.ref.lockerAlwaysCompatible()) {
            return true;
        }
        return this.ref.requestCompatible(requestQualifier, this.qualifier);
    }
}

