/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import org.apache.poi.ss.usermodel.Cell;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IStyledElement;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import uk.co.spudsoft.birt.emitters.excel.Area;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.CellContentHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.FlattenedTableHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;

public class StringCellHandler
extends CellContentHandler {
    private String result = null;

    public StringCellHandler(IContentEmitter emitter, Logger log, IHandler parent, ICellContent cell) {
        super(emitter, log, parent, cell);
    }

    @Override
    public void endCell(HandlerState state, ICellContent cell) throws BirtException {
        this.endCellContent(state, cell, this.lastElement, null, null);
    }

    @Override
    protected void endCellContent(HandlerState state, ICellContent birtCell, IContent element, Cell cell, Area area) {
        if (this.lastValue != null) {
            this.result = this.lastValue instanceof String ? (String)this.lastValue : this.lastValue.toString();
        }
    }

    public void visit(Object obj) throws BirtException {
        if (obj instanceof ICellContent) {
            this.contentVisitor.visitCell((ICellContent)obj, null);
        } else if (obj instanceof ILabelContent) {
            this.contentVisitor.visitLabel((ILabelContent)obj, null);
        } else if (obj instanceof ITextContent) {
            this.contentVisitor.visitText((ITextContent)obj, null);
        } else if (obj instanceof IAutoTextContent) {
            this.contentVisitor.visitAutoText((IAutoTextContent)obj, null);
        } else if (obj instanceof IForeignContent) {
            this.contentVisitor.visitForeign((IForeignContent)obj, null);
        } else {
            this.log.warn(0, "Not visiting " + String.valueOf(obj.getClass()), null);
        }
    }

    public String getString() {
        if (this.result == null && this.lastValue != null) {
            this.result = this.lastValue instanceof String ? (String)this.lastValue : this.lastValue.toString();
        }
        if (this.result == null) {
            this.result = "";
        }
        return this.result;
    }

    @Override
    public void startTable(HandlerState state, ITableContent table) throws BirtException {
        state.setHandler(new FlattenedTableHandler(this, this.log, this, table));
        state.getHandler().startTable(state, table);
    }

    @Override
    public void emitText(HandlerState state, ITextContent text) throws BirtException {
        String textText = text.getText();
        this.log.debug("text:", textText);
        this.emitContent(state, (IContent)text, textText, !"inline".equals(StringCellHandler.getStyleProperty((IStyledElement)text, 63, "block")));
    }

    @Override
    public void emitData(HandlerState state, IDataContent data) throws BirtException {
        this.emitContent(state, (IContent)data, data.getValue(), !"inline".equals(StringCellHandler.getStyleProperty((IStyledElement)data, 63, "block")));
    }

    @Override
    public void emitLabel(HandlerState state, ILabelContent label) throws BirtException {
        String labelText = label.getLabelText() != null ? label.getLabelText() : label.getText();
        this.log.debug("labelText:" + labelText);
        this.emitContent(state, (IContent)label, labelText, !"inline".equals(StringCellHandler.getStyleProperty((IStyledElement)label, 63, "block")));
    }

    @Override
    public void emitAutoText(HandlerState state, IAutoTextContent autoText) throws BirtException {
        this.emitContent(state, (IContent)autoText, autoText.getText(), !"inline".equals(StringCellHandler.getStyleProperty((IStyledElement)autoText, 63, "block")));
    }

    @Override
    public void emitForeign(HandlerState state, IForeignContent foreign) throws BirtException {
        this.log.debug("Handling foreign content of type " + foreign.getRawType());
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            HTML2Content.html2Content((IForeignContent)foreign);
            this.contentVisitor.visitChildren((IContent)foreign, null);
        }
    }

    @Override
    public void emitImage(HandlerState state, IImageContent image) throws BirtException {
    }

    @Override
    public void endContainer(HandlerState state, IContainerContent container) throws BirtException {
        this.lastCellContentsWasBlock = !"inline".equals(StringCellHandler.getStyleProperty((IStyledElement)container, 63, "block"));
    }
}

