/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jetty.osgi.JettyServerFactory;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.util.OSGiClassLoader;
import org.eclipse.jetty.osgi.util.Util;
import org.eclipse.jetty.server.Server;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyBootstrapActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(JettyBootstrapActivator.class);
    public static final String JETTY_ETC_FILES = "jetty.etc.config.urls";
    public static final List<String> DEFAULT_JETTY_XML_FILES = List.of("etc/jetty.xml", "etc/jetty-http.xml", "etc/jetty-deploy.xml");
    public static final String DEFAULT_JETTY_ETC_FILES = String.join((CharSequence)",", DEFAULT_JETTY_XML_FILES);
    public static final String DEFAULT_JETTYHOME = "/jettyhome";
    private ServiceRegistration<?> _registeredServer;

    public void start(BundleContext context) throws Exception {
        ServiceReference[] references = context.getAllServiceReferences("org.eclipse.jetty.http.HttpFieldPreEncoder", null);
        if (references == null || references.length == 0) {
            LOG.warn("OSGi support for java.util.ServiceLoader may not be present. You may experience runtime errors.");
        }
        this.startDefaultJettyServer(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this._registeredServer != null) {
            try {
                this._registeredServer.unregister();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                this._registeredServer = null;
            }
        }
    }

    private void startDefaultJettyServer(BundleContext bundleContext) throws Exception {
        String jettyHomeSysProp = System.getProperty("jetty.home");
        String jettyHomeBundleSysProp = System.getProperty("jetty.home.bundle");
        File jettyHomeDir = null;
        Bundle jettyHomeBundle = null;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (jettyHomeSysProp != null) {
            if ((jettyHomeSysProp = Util.resolvePropertyValue(jettyHomeSysProp)).startsWith("\"") && jettyHomeSysProp.endsWith("\"") || jettyHomeSysProp.startsWith("'") && jettyHomeSysProp.endsWith("'")) {
                jettyHomeSysProp = jettyHomeSysProp.substring(1, jettyHomeSysProp.length() - 1);
            }
            if (jettyHomeBundleSysProp != null) {
                LOG.warn("Both jetty.home and jetty.home.bundle property defined: jetty.home.bundle ignored.");
            }
            if (!(jettyHomeDir = new File(jettyHomeSysProp)).exists() || !jettyHomeDir.isDirectory()) {
                LOG.warn("Unable to locate the jetty.home folder {}", (Object)jettyHomeSysProp);
                return;
            }
            Util.setProperty(properties, "jetty.home", jettyHomeDir.getAbsolutePath());
        } else if (jettyHomeBundleSysProp != null) {
            jettyHomeBundleSysProp = Util.resolvePropertyValue(jettyHomeBundleSysProp);
            for (Bundle b : bundleContext.getBundles()) {
                if (b.getState() == 1 || !b.getSymbolicName().equals(jettyHomeBundleSysProp)) continue;
                jettyHomeBundle = b;
                break;
            }
            if (jettyHomeBundle == null) {
                LOG.warn("Unable to find the jetty.home.bundle named {}", (Object)jettyHomeBundleSysProp);
                return;
            }
        }
        if (jettyHomeDir == null && jettyHomeBundle == null) {
            LOG.warn("No default jetty created.");
            return;
        }
        List<URL> configURLs = jettyHomeDir != null ? this.getJettyConfigurationURLs(jettyHomeDir) : this.getJettyConfigurationURLs(jettyHomeBundle, properties);
        LOG.info("Configuring the default jetty server with {}", configURLs);
        String home = (String)((Dictionary)properties).get("jetty.home");
        String base = (String)((Dictionary)properties).get("jetty.base");
        if (base == null) {
            base = home;
        }
        LOG.info("JETTY.HOME={}  JETTY.BASE={}", (Object)home, (Object)base);
        ClassLoader contextCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = jettyHomeBundle != null ? new OSGiClassLoader(JettyBootstrapActivator.class.getClassLoader(), jettyHomeBundle) : JettyBootstrapActivator.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            ((Dictionary)properties).put("managedServerName", "defaultJettyServer");
            Util.setProperty(properties, "jetty.home", home);
            Util.setProperty(properties, "jetty.base", base);
            for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
                String skey;
                if (!(prop.getKey() instanceof String) || JETTY_ETC_FILES.equals(skey = (String)prop.getKey()) || "jetty.home".equals(skey) || "jetty.base".equals(skey) || !skey.startsWith("jetty.")) continue;
                Util.setProperty(properties, skey, prop.getValue());
            }
            Server defaultServer = JettyServerFactory.createServer("defaultJettyServer", properties, configURLs);
            this._registeredServer = bundleContext.registerService(Server.class.getName(), (Object)defaultServer, properties);
            LOG.info("Default jetty server configured");
        }
        catch (Exception e) {
            LOG.warn("Failed to start default jetty server", (Throwable)e);
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCl);
        }
    }

    private List<URL> getJettyConfigurationURLs(File jettyhome) throws MalformedURLException {
        ArrayList<URL> configURLs = new ArrayList<URL>();
        String jettyetc = System.getProperty(JETTY_ETC_FILES, DEFAULT_JETTY_ETC_FILES);
        StringTokenizer tokenizer = new StringTokenizer(jettyetc, ";,", false);
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken().trim();
            if (!next.startsWith("/") && next.indexOf(58) == -1) {
                configURLs.add(new File(jettyhome, next).toURI().toURL());
                continue;
            }
            configURLs.add(new URL(next));
        }
        return configURLs;
    }

    private List<URL> getJettyConfigurationURLs(Bundle configurationBundle, Dictionary properties) throws Exception {
        ArrayList<URL> configURLs = new ArrayList<URL>();
        String files = System.getProperty(JETTY_ETC_FILES, DEFAULT_JETTY_ETC_FILES);
        StringTokenizer tokenizer = new StringTokenizer(files, ";,", false);
        while (tokenizer.hasMoreTokens()) {
            Path path;
            String etcFile = tokenizer.nextToken().trim();
            if (etcFile.startsWith("/") || etcFile.contains(":")) {
                configURLs.add(new URL(etcFile));
                continue;
            }
            Enumeration<URL> enUrls = BundleFileLocatorHelperFactory.getFactory().getHelper().findEntries(configurationBundle, etcFile);
            String home = null;
            if (enUrls == null || !enUrls.hasMoreElements()) {
                home = DEFAULT_JETTYHOME;
                String tmp = DEFAULT_JETTYHOME + (DEFAULT_JETTYHOME.endsWith("/") ? "" : "/") + etcFile;
                enUrls = BundleFileLocatorHelperFactory.getFactory().getHelper().findEntries(configurationBundle, tmp);
                LOG.info("Configuring jetty from bundle: {} with {}", (Object)configurationBundle.getSymbolicName(), (Object)tmp);
            }
            if (properties.get("jetty.home") == null && (path = this.findDir(configurationBundle, home)) != null) {
                properties.put("jetty.home", path.toUri().toString());
            }
            if (enUrls == null || !enUrls.hasMoreElements()) {
                throw new IllegalStateException("Unable to locate a jetty configuration file for " + etcFile);
            }
            URL url = BundleFileLocatorHelperFactory.getFactory().getHelper().getFileURL(enUrls.nextElement());
            configURLs.add(url);
        }
        return configURLs;
    }

    private Path findDir(Bundle bundle, String dir) {
        if (bundle == null) {
            return null;
        }
        try {
            File f = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
            URL u = f.toURI().toURL();
            u = BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(u);
            Path p = Paths.get(u.toURI());
            if (dir != null) {
                return p.resolve(dir);
            }
            return p;
        }
        catch (Exception e) {
            LOG.warn("Bad bundle location", (Throwable)e);
            return null;
        }
    }
}

