/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jetty.deploy.Deployer;
import org.eclipse.jetty.osgi.AbstractContextProvider;
import org.eclipse.jetty.osgi.BundleMetadata;
import org.eclipse.jetty.osgi.BundleProvider;
import org.eclipse.jetty.osgi.ContextFactory;
import org.eclipse.jetty.osgi.util.Util;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWebAppProvider
extends AbstractContextProvider
implements BundleProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BundleWebAppProvider.class);
    private final Map<Bundle, ContextHandler> _bundleMap = new HashMap<Bundle, ContextHandler>();
    private ServiceRegistration<?> _serviceRegForBundles;
    private WebAppTracker _webappTracker;

    public BundleWebAppProvider(Server server, Deployer deployer, String environment, ContextFactory contextFactory) {
        super(server, deployer, environment, contextFactory);
    }

    protected void doStart() throws Exception {
        String serverName = (String)this.getServer().getAttribute("managedServerName");
        this._webappTracker = new WebAppTracker(FrameworkUtil.getBundle(this.getClass()).getBundleContext(), serverName);
        this._webappTracker.open();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("managedServerName", serverName);
        this._serviceRegForBundles = FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(BundleProvider.class.getName(), (Object)this, properties);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._webappTracker.close();
        if (this._serviceRegForBundles != null) {
            try {
                this._serviceRegForBundles.unregister();
            }
            catch (Exception e) {
                LOG.warn("Unable to unregister {}", this._serviceRegForBundles, (Object)e);
            }
        }
        this._bundleMap.clear();
        super.doStop();
    }

    @Override
    public boolean isDeployable(Bundle bundle) {
        if (!super.isDeployable(bundle)) {
            return false;
        }
        if (!StringUtil.isBlank((String)Util.getManifestHeaderValue("Jetty-WarResourcePath", bundle.getHeaders()))) {
            return true;
        }
        if (!StringUtil.isBlank((String)Util.getManifestHeaderValue("Web-ContextPath", bundle.getHeaders()))) {
            return true;
        }
        return bundle.getEntry("/WEB-INF/web.xml") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bundleAdded(Bundle bundle) throws Exception {
        if (bundle == null) {
            return false;
        }
        if (!this.isDeployable(bundle)) {
            return false;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.getServer().getAttribute("org.eclipse.jetty.osgi.server.classLoader"));
        try {
            Dictionary headers = bundle.getHeaders();
            String staticResourcesLocation = Util.getManifestHeaderValue("Jetty-WarResourcePath", headers);
            if (staticResourcesLocation != null) {
                BundleMetadata app = new BundleMetadata(bundle, staticResourcesLocation);
                ContextHandler contextHandler = this.createContextHandler(app);
                this._bundleMap.put(bundle, contextHandler);
                this.getContextHandlerManagement().deploy(contextHandler);
                boolean bl = true;
                return bl;
            }
            if (bundle.getEntry("/WEB-INF/web.xml") != null) {
                String base = ".";
                BundleMetadata app = new BundleMetadata(bundle, base);
                ContextHandler contextHandler = this.createContextHandler(app);
                this._bundleMap.put(bundle, contextHandler);
                this.getContextHandlerManagement().deploy(contextHandler);
                boolean bl = true;
                return bl;
            }
            if (headers.get("Web-ContextPath") != null) {
                String base = ".";
                BundleMetadata app = new BundleMetadata(bundle, base);
                ContextHandler contextHandler = this.createContextHandler(app);
                this._bundleMap.put(bundle, contextHandler);
                this.getContextHandlerManagement().deploy(contextHandler);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public boolean bundleRemoved(Bundle bundle) {
        ContextHandler contextHandler = this._bundleMap.remove(bundle);
        if (contextHandler != null) {
            this.getContextHandlerManagement().undeploy(contextHandler);
            return true;
        }
        return false;
    }

    public class WebAppTracker
    extends BundleTracker<Object> {
        protected String _managedServerName;

        public WebAppTracker(BundleContext bundleContext, String managedServerName) {
            super(bundleContext, 48, null);
            this._managedServerName = managedServerName;
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            try {
                String serverName = (String)bundle.getHeaders().get("managedServerName");
                if ((StringUtil.isBlank((String)serverName) && this._managedServerName.equals("defaultJettyServer") || !StringUtil.isBlank((String)serverName) && serverName.equals(this._managedServerName)) && BundleWebAppProvider.this.bundleAdded(bundle)) {
                    return bundle;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to add bundle {}", (Object)bundle, (Object)e);
            }
            return null;
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            try {
                BundleWebAppProvider.this.bundleRemoved(bundle);
            }
            catch (Exception e) {
                LOG.warn("Unable to remove bundle {}", (Object)bundle, (Object)e);
            }
        }
    }
}

