/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import org.eclipse.core.runtime.Platform;

public class ImageUtil {
    private ImageUtil() {
    }

    public static Map<ImageCompParam, Integer> getDefaultCompParams() {
        HashMap<ImageCompParam, Integer> params = new HashMap<ImageCompParam, Integer>();
        params.put(ImageCompParam.XBLOCKS, 20);
        params.put(ImageCompParam.YBLOCKS, 20);
        params.put(ImageCompParam.TOLERANCE, 3);
        params.put(ImageCompParam.STABILIZER, 10);
        params.put(ImageCompParam.DEBUG, 2);
        return params;
    }

    public static Map<ImageCompParam, Integer> mergeDefaultCompParams(Map<ImageCompParam, Integer> params) {
        Map<ImageCompParam, Integer> result = ImageUtil.getDefaultCompParams();
        if (params != null) {
            result.putAll(params);
        }
        return result;
    }

    public static Image compare(BufferedImage golden, BufferedImage actual, Map<ImageCompParam, Integer> p) {
        Map<ImageCompParam, Integer> params = ImageUtil.mergeDefaultCompParams(p);
        BufferedImage noMatch = ImageUtil.imageToBufferedImage(actual);
        Graphics2D gc = noMatch.createGraphics();
        gc.setColor(Color.RED);
        golden = ImageUtil.imageToBufferedImage(GrayFilter.createDisabledImage(golden));
        actual = ImageUtil.imageToBufferedImage(GrayFilter.createDisabledImage(actual));
        int goldenBlockXSize = golden.getWidth() / params.get((Object)ImageCompParam.XBLOCKS);
        int goldenBlockYSize = golden.getHeight() / params.get((Object)ImageCompParam.YBLOCKS);
        int actualBlockXSize = actual.getWidth() / params.get((Object)ImageCompParam.XBLOCKS);
        int actualBlockYSize = actual.getHeight() / params.get((Object)ImageCompParam.YBLOCKS);
        boolean match = true;
        int y = 0;
        while (y < params.get((Object)ImageCompParam.YBLOCKS)) {
            if (params.get((Object)ImageCompParam.DEBUG) > 0) {
                System.out.print("|");
            }
            int x = 0;
            while (x < params.get((Object)ImageCompParam.XBLOCKS)) {
                int actualBrightness;
                int goldenBrightness = ImageUtil.getAverageBrightness(golden.getSubimage(x * goldenBlockXSize, y * goldenBlockYSize, goldenBlockXSize - 1, goldenBlockYSize - 1), params);
                int diff = Math.abs(goldenBrightness - (actualBrightness = ImageUtil.getAverageBrightness(actual.getSubimage(x * actualBlockXSize, y * actualBlockYSize, actualBlockXSize - 1, actualBlockYSize - 1), params)));
                if (diff > params.get((Object)ImageCompParam.TOLERANCE)) {
                    gc.drawRect(x * actualBlockXSize, y * actualBlockYSize, actualBlockXSize - 1, actualBlockYSize - 1);
                    match = false;
                }
                if (params.get((Object)ImageCompParam.DEBUG) == 1) {
                    System.out.print(diff > params.get((Object)ImageCompParam.TOLERANCE) ? "X" : " ");
                }
                if (params.get((Object)ImageCompParam.DEBUG) == 2) {
                    System.out.print(diff + (x < params.get((Object)ImageCompParam.XBLOCKS) - 1 ? "," : ""));
                }
                ++x;
            }
            if (params.get((Object)ImageCompParam.DEBUG) > 0) {
                System.out.println("|");
            }
            ++y;
        }
        return match ? null : noMatch;
    }

    public static Image compare(String golden, String actual) throws IOException {
        return ImageUtil.compare(ImageUtil.loadImageFromFile(golden), ImageUtil.loadImageFromFile(actual), ImageUtil.getDefaultCompParams());
    }

    public static Image compare(String golden, String actual, Map<ImageCompParam, Integer> params) throws IOException {
        if (ImageUtil.mergeDefaultCompParams(params).get((Object)ImageCompParam.DEBUG) > 0) {
            System.out.print("Golden: " + golden);
            System.out.print("Actual: " + actual);
        }
        return ImageUtil.compare(ImageUtil.loadImageFromFile(golden), ImageUtil.loadImageFromFile(actual), params);
    }

    public static Image compare(Image golden, Image actual, Map<ImageCompParam, Integer> params) {
        return ImageUtil.compare(ImageUtil.imageToBufferedImage(golden), ImageUtil.imageToBufferedImage(actual), params);
    }

    protected static int getAverageBrightness(BufferedImage img, Map<ImageCompParam, Integer> p) {
        Map<ImageCompParam, Integer> params = ImageUtil.mergeDefaultCompParams(p);
        Raster r = img.getData();
        int total = 0;
        int y = 0;
        while (y < r.getHeight()) {
            int x = 0;
            while (x < r.getWidth()) {
                total += r.getSample(r.getMinX() + x, r.getMinY() + y, 0);
                ++x;
            }
            ++y;
        }
        return total / (r.getWidth() / params.get((Object)ImageCompParam.STABILIZER) * (r.getHeight() / params.get((Object)ImageCompParam.STABILIZER)));
    }

    public static BufferedImage imageToBufferedImage(Image img) {
        assert (img != null);
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(img, null, null);
        return bi;
    }

    public static void saveImageToFile(Image img, String filename, String format) throws IOException {
        assert (img != null);
        BufferedImage bi = ImageUtil.imageToBufferedImage(img);
        File outputfile = new File(filename);
        ImageIO.write((RenderedImage)bi, format, outputfile);
    }

    public static void saveJPG(Image img, String filename) throws IOException {
        ImageUtil.saveImageToFile(img, filename, "jpg");
    }

    public static void savePNG(Image img, String filename) throws IOException {
        ImageUtil.saveImageToFile(img, filename, "png");
    }

    public static Image loadImageFromFile(String filename) throws IOException {
        return ImageIO.read(new File(filename));
    }

    public static boolean isRenderingTestApplicable() {
        return !Platform.getOS().equals("win32") || Boolean.getBoolean("birt.rendering.tests.enabled");
    }

    public static void main(String[] args) throws IOException {
        Image ic = ImageUtil.compare("C:\\8\\golden.jpg", "C:\\8\\actual.jpg");
        System.out.println("Match: " + (ic == null));
        if (ic != null) {
            ImageUtil.savePNG(ic, "C:\\8\\diff.png ");
        }
    }

    public static enum ImageCompParam {
        XBLOCKS,
        YBLOCKS,
        TOLERANCE,
        STABILIZER,
        DEBUG;

    }
}

