/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.RenderOption;

public class RenderTaskTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/render_task_design.xml";

    public void setUp() {
        this.removeFile("reportdocument");
        this.removeFile("design.rptdesign");
        this.copyResource(REPORT_DESIGN_RESOURCE, "design.rptdesign");
        this.engine = this.createReportEngine();
    }

    public void tearDown() {
        this.engine.shutdown();
        this.removeFile("design.rptdesign");
        this.removeFile("reportdocument");
    }

    public void testRenderOnTransientFile() throws Exception {
        ArchiveFile archive = new ArchiveFile("reportdocument", "rw");
        IReportRunnable report = this.engine.openReportDesign("design.rptdesign");
        IRunTask task = this.engine.createRunTask(report);
        ArchiveWriter writer = new ArchiveWriter((IArchiveFile)archive);
        task.run((IDocArchiveWriter)writer);
        task.close();
        archive.saveAs("test.archive");
        ArchiveReader reader = new ArchiveReader((IArchiveFile)archive);
        IReportDocument reportDoc = this.engine.openReportDocument(null, (IDocArchiveReader)reader, new HashMap());
        RenderTaskTest.assertTrue((boolean)reportDoc.getVersion().equals("2.6.1"));
        IRenderTask renderTask = this.engine.createRenderTask(reportDoc);
        long pageNumber = reportDoc.getPageCount();
        RenderTaskTest.assertEquals((long)3L, (long)pageNumber);
        long i = 1L;
        while (i <= pageNumber) {
            renderTask.setPageNumber(i);
            this.assertRender(renderTask, "page" + i + ".html");
            ++i;
        }
        archive.close();
    }

    public void testRender() {
        try {
            this.createReportDocument();
            this.doRenderTest();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RenderTaskTest.fail();
        }
    }

    public void testRenderPerformance() {
        try {
            this.test(1000);
            this.test(1000);
            this.test(10000);
            this.test(100000);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RenderTaskTest.fail();
        }
    }

    private void test(int data) throws EngineException, Exception {
        this.createReportDocument1(data);
        long time1 = 0L;
        long time2 = 0L;
        PrintWriter writer = new PrintWriter(new FileOutputStream("./performance.txt", true));
        int i = 0;
        while (i < 50) {
            double percent = (double)((time2 += this.doRenderTest1(true)) - (time1 += this.doRenderTest1(false))) / (double)time1;
            String result = data + " : " + time1 + "    " + time2 + "    " + percent;
            System.out.println(result);
            writer.println(result);
            writer.flush();
            ++i;
        }
        writer.close();
    }

    protected void createReportDocument1(int data) throws EngineException {
        IReportRunnable report = this.engine.openReportDesign("design.rptdesign");
        IRunTask task = this.engine.createRunTask(report);
        task.setParameterValue("count", (Object)data);
        task.run("reportdocument");
        task.close();
    }

    protected long doRenderTest1(boolean usingFilterStream) throws Exception {
        long start = System.currentTimeMillis();
        IReportDocument reportDoc = this.engine.openReportDocument("reportdocument");
        IRenderTask task = this.engine.createRenderTask(reportDoc);
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        OutputStream out = new FileOutputStream("./test.html");
        if (usingFilterStream) {
            out = new CounterOutputStream(out);
        }
        option.setOutputStream(out);
        task.setRenderOption((IRenderOption)option);
        task.render();
        task.close();
        out.close();
        reportDoc.close();
        return System.currentTimeMillis() - start;
    }

    protected void doRenderTest() throws Exception {
        IReportDocument reportDoc = this.engine.openReportDocument("reportdocument");
        RenderTaskTest.assertTrue((boolean)reportDoc.getVersion().equals("2.6.1"));
        IRenderTask task = this.engine.createRenderTask(reportDoc);
        long pageNumber = reportDoc.getPageCount();
        RenderTaskTest.assertEquals((long)3L, (long)pageNumber);
        long i = 1L;
        while (i <= pageNumber) {
            task.setPageNumber(i);
            this.assertRender(task, "page" + i + ".html");
            ++i;
        }
        task.setPageRange("1, 3");
        this.assertRender(task, "page13.html");
        task.setPageRange("1-2, 3");
        this.assertRender(task, "page123.html");
        task.setPageRange("all");
        this.assertRender(task, "pageAll.html");
        task.setBookmark("__TOC_0");
        this.assertRender(task, "pageToc0.html");
        task.setBookmark("__TOC_1");
        this.assertRender(task, "pageToc1.html");
        task.setBookmark("__TOC_2");
        this.assertRender(task, "pageToc2.html");
        task.close();
        reportDoc.close();
    }

    private void assertRender(IRenderTask task, String outputFileName) throws EngineException {
        this.removeFile(outputFileName);
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        option.setOutputFileName(outputFileName);
        task.setRenderOption((IRenderOption)option);
        task.render();
        File htmlFile = new File(outputFileName);
        RenderTaskTest.assertTrue((boolean)htmlFile.exists());
        RenderTaskTest.assertTrue((htmlFile.length() != 0L ? 1 : 0) != 0);
        this.removeFile(outputFileName);
    }

    public void testRenderPDFFromDocument() throws Exception {
        String outputFileName = ".render_pdf_from_document.pdf";
        this.createReportDocument();
        IReportDocument reportDoc = this.engine.openReportDocument("reportdocument");
        IRenderTask task = this.engine.createRenderTask(reportDoc);
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("pdf");
        option.setOutputFileName(outputFileName);
        task.setRenderOption((IRenderOption)option);
        task.render();
        File pdfFile = new File(outputFileName);
        RenderTaskTest.assertTrue((boolean)pdfFile.exists());
        RenderTaskTest.assertTrue((pdfFile.length() != 0L ? 1 : 0) != 0);
        this.removeFile(outputFileName);
        task.close();
        reportDoc.close();
    }

    public void testCloseOnExitRenderOption() throws EngineException {
        String[] formats;
        String design = "org/eclipse/birt/report/engine/api/testCloseOnExit.rptdesign";
        IReportDocument document = this.createReportDocument(design);
        String[] stringArray = formats = new String[]{"html", "pdf", "postscript", "ppt", "doc", "docx", "xlsx"};
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            if (format.equals("xlsx")) {
                RenderTaskTest.assertEquals((String)(format + "true"), (String)(format + this.isRenderTaskCloseStreamOnExit(document, format, false)));
            } else {
                RenderTaskTest.assertEquals((String)(format + "true"), (String)(format + this.isRenderTaskCloseStreamOnExit(document, format, true)));
            }
            ++n2;
        }
        document.close();
    }

    public void testGetPageCount() throws EngineException {
        String design = "org/eclipse/birt/report/engine/api/TestGetPageCount.rptdesign";
        IReportDocument document = this.createReportDocument(design);
        this.test(document, "pdf");
        this.test(document, "html");
    }

    private void test(IReportDocument document, String format) throws EngineException {
        this.testRenderPageCount(document, 1, format, new RenderItemSetter(){

            @Override
            public void setRenderItem(IRenderTask task) throws EngineException {
                task.setReportlet("grid");
            }
        });
        this.testRenderPageCount(document, 1, format, new RenderItemSetter(){

            @Override
            public void setRenderItem(IRenderTask task) throws EngineException {
                task.setPageNumber(1L);
            }
        });
        this.testRenderPageCount(document, 2, format, new RenderItemSetter(){

            @Override
            public void setRenderItem(IRenderTask task) throws EngineException {
                task.setPageRange("1,3");
            }
        });
        this.testRenderPageCount(document, 4, format, new RenderItemSetter(){

            @Override
            public void setRenderItem(IRenderTask task) throws EngineException {
                task.setPageRange("all");
            }
        });
    }

    private void testRenderPageCount(IReportDocument document, int expectedPageCount, String format, RenderItemSetter renderItemSetter) throws EngineException {
        IRenderTask task = this.createRenderTask(document, format);
        renderItemSetter.setRenderItem(task);
        task.render();
        long pageCount = task.getPageCount();
        task.close();
        RenderTaskTest.assertEquals((long)expectedPageCount, (long)pageCount);
    }

    private IRenderTask createRenderTask(IReportDocument document, String format) {
        IRenderTask task = this.engine.createRenderTask(document);
        HTMLRenderOption options = new HTMLRenderOption();
        options.setOutputFormat(format);
        options.setOutputStream((OutputStream)new ByteArrayOutputStream());
        options.setHtmlPagination(true);
        task.setRenderOption((IRenderOption)options);
        return task;
    }

    private boolean isRenderTaskCloseStreamOnExit(IReportDocument document, String format, boolean closeOnExit) throws EngineException {
        IRenderTask task = this.engine.createRenderTask(document);
        RenderOption options = new RenderOption();
        options.setOutputFormat(format);
        TestOutputStream output = new TestOutputStream();
        options.setOutputStream((OutputStream)output);
        options.closeOutputStreamOnExit(closeOnExit);
        task.setRenderOption((IRenderOption)options);
        task.render();
        task.close();
        return output.isClosed() == closeOnExit;
    }

    protected class CounterOutputStream
    extends FilterOutputStream {
        private long size;
        private OutputStream out;
        private boolean counted;

        public CounterOutputStream(OutputStream out) {
            super(out);
            this.size = 0L;
            this.counted = false;
            this.out = out;
        }

        @Override
        public void write(byte[] b) throws IOException {
            boolean count = false;
            if (!this.counted) {
                this.counted = true;
                count = true;
            }
            try {
                this.out.write(b);
                if (count) {
                    this.size += (long)b.length;
                }
            }
            finally {
                if (count) {
                    this.counted = false;
                }
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            boolean count = false;
            if (!this.counted) {
                this.counted = true;
                count = true;
            }
            try {
                this.out.write(b, off, len);
                if (count) {
                    this.size += (long)len;
                }
            }
            finally {
                if (count) {
                    this.counted = false;
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            boolean count = false;
            if (!this.counted) {
                this.counted = true;
                count = true;
            }
            try {
                this.out.write(b);
                if (count) {
                    ++this.size;
                }
            }
            finally {
                if (count) {
                    this.counted = false;
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }

        public long getSize() {
            return this.size;
        }
    }

    private static interface RenderItemSetter {
        public void setRenderItem(IRenderTask var1) throws EngineException;
    }

    private static class TestOutputStream
    extends FilterOutputStream {
        private boolean isClosed = false;

        public TestOutputStream() {
            super(new ByteArrayOutputStream());
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

