/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.birt.report.designer.internal.ui.preferences.CPListElement;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class CPListLabelProvider
extends LabelProvider {
    private String fMissing = Messages.getString((String)"CPListLabelProvider.misssing");
    private static final String[] fgArchiveExtensions = new String[]{"jar", "zip"};

    public String getText(Object element) {
        if (element instanceof CPListElement) {
            return this.getCPListElementText((CPListElement)element);
        }
        return super.getText(element);
    }

    public String getCPListElementText(CPListElement cpentry) {
        IPath path = cpentry.getPath();
        Object label = this.getPathString(path, true);
        if (cpentry.isMissing()) {
            label = (String)label + " " + this.fMissing;
        }
        return label;
    }

    private String getPathString(IPath path, boolean isExternal) {
        if (CPListLabelProvider.isArchivePath(path, true)) {
            String appended = CPListLabelProvider.getPathLabel(path.removeLastSegments(1), isExternal);
            String lastSegment = path.lastSegment();
            return MessageFormat.format("{0} - {1}", lastSegment, appended);
        }
        return CPListLabelProvider.getPathLabel(path, isExternal);
    }

    public static boolean isArchivePath(IPath path, boolean allowAllAchives) {
        if (allowAllAchives) {
            return true;
        }
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            return CPListLabelProvider.isArchiveFileExtension(ext);
        }
        return false;
    }

    public static boolean isArchiveFileExtension(String ext) {
        int i = 0;
        while (i < fgArchiveExtensions.length) {
            if (ext.equalsIgnoreCase(fgArchiveExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Image getCPListElementBaseImage(CPListElement cpentry) {
        if (CPListLabelProvider.isArchivePath(cpentry.getPath(), false)) {
            return ReportPlatformUIImages.getImage("ExtJar");
        }
        return ReportPlatformUIImages.getImage("ExtFol");
    }

    public Image getImage(Object element) {
        if (element instanceof CPListElement) {
            CPListElement cpentry = (CPListElement)element;
            Image image = this.getCPListElementBaseImage(cpentry);
            return image;
        }
        return null;
    }

    public static String getPathLabel(IPath path, boolean isOSPath) {
        String label = isOSPath ? path.toOSString() : path.makeRelative().toString();
        return label;
    }
}

