/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import testutil.BaseTestCase;

public class CursorNavigatorTest
extends BaseTestCase {
    private Scriptable scope;
    private DataEngineImpl de;
    private CubeUtility creator;
    private ICube cube;

    @Before
    public void cursorNavigatorSetUp() throws Exception {
        this.scope = new ImporterTopLevel();
        DataEngineContext context = DataEngineContext.newInstance((int)3, (Scriptable)this.scope, null, null);
        context.setTmpdir(CursorNavigatorTest.getTempDir());
        this.de = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.creator = new CubeUtility();
        this.creator.createCube(this.de);
        this.cube = this.creator.getCube(CubeUtility.cubeName, this.de);
    }

    @After
    public void cursorNavigatorTearDown() throws Exception {
        this.cube.close();
        if (this.de != null) {
            this.de.shutdown();
            this.de = null;
        }
    }

    @Test
    public void testCursorModel1() throws OLAPException, BirtException {
        ICubeQueryDefinition cqd = this.creator.createQueryDefinition();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("SUM");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        EdgeCursor rowCursor = cubeView.getRowEdgeView().getEdgeCursor();
        EdgeCursor columnCursor = cubeView.getColumnEdgeView().getEdgeCursor();
        DimensionCursor countryCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(0);
        DimensionCursor cityCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(1);
        DimensionCursor streetCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(2);
        DimensionCursor timeCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(3);
        columnCursor.beforeFirst();
        Assert.assertTrue((boolean)countryCursor.isBeforeFirst());
        Assert.assertTrue((boolean)cityCursor.isBeforeFirst());
        Assert.assertTrue((boolean)streetCursor.isBeforeFirst());
        Assert.assertTrue((boolean)timeCursor.isBeforeFirst());
        columnCursor.afterLast();
        Assert.assertTrue((boolean)countryCursor.isAfterLast());
        Assert.assertTrue((boolean)cityCursor.isAfterLast());
        Assert.assertTrue((boolean)streetCursor.isAfterLast());
        Assert.assertTrue((boolean)timeCursor.isAfterLast());
        columnCursor.first();
        Assert.assertTrue((boolean)columnCursor.isFirst());
        Assert.assertTrue((boolean)countryCursor.isFirst());
        Assert.assertTrue((boolean)cityCursor.isFirst());
        Assert.assertTrue((boolean)streetCursor.isFirst());
        Assert.assertTrue((boolean)timeCursor.isFirst());
        columnCursor.last();
        Assert.assertTrue((boolean)columnCursor.last());
        Assert.assertTrue((boolean)countryCursor.last());
        Assert.assertTrue((boolean)cityCursor.last());
        Assert.assertTrue((boolean)streetCursor.last());
        Assert.assertTrue((boolean)timeCursor.last());
        columnCursor.setPosition(5L);
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("SH"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A1"));
        Assert.assertTrue((boolean)timeCursor.getObject("level14").equals("2000"));
        columnCursor.previous();
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("SH"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A1"));
        Assert.assertTrue((boolean)timeCursor.getObject("level14").equals("1998"));
        columnCursor.setPosition(24L);
        try {
            countryCursor.getObject("level11");
            Assert.fail((String)"should never get here!!");
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        columnCursor.beforeFirst();
        columnCursor.relative(6);
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("SH"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A1"));
        Assert.assertTrue((boolean)timeCursor.getObject("level14").equals("2000"));
        columnCursor.beforeFirst();
        columnCursor.next();
        columnCursor.next();
        columnCursor.next();
        columnCursor.setPosition(1L);
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("BJ"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A1"));
        Assert.assertTrue((boolean)timeCursor.getObject("level14").equals("2001"));
        columnCursor.beforeFirst();
        columnCursor.setPosition(4L);
        timeCursor.setPosition(1L);
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("SH"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A1"));
        Assert.assertTrue((boolean)timeCursor.getObject("level14").equals("2000"));
        columnCursor.beforeFirst();
        columnCursor.next();
        countryCursor.next();
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("JP"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("IL"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A4"));
        Assert.assertTrue((boolean)timeCursor.getObject("level14").equals("1999"));
        columnCursor.afterLast();
        try {
            streetCursor.getObject("level13");
            Assert.fail((String)"should not get here");
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        columnCursor.beforeFirst();
        columnCursor.setPosition(1L);
        Assert.assertTrue((countryCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((countryCursor.getEdgeEnd() == 7L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeEnd() == 2L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeEnd() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((timeCursor.getEdgeStart() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((timeCursor.getEdgeEnd() == 1L ? 1 : 0) != 0);
        columnCursor.setPosition(9L);
        Assert.assertTrue((countryCursor.getEdgeStart() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((countryCursor.getEdgeEnd() == 11L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeStart() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeEnd() == 10L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeStart() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeEnd() == 10L ? 1 : 0) != 0);
        Assert.assertTrue((timeCursor.getEdgeStart() == 9L ? 1 : 0) != 0);
        Assert.assertTrue((timeCursor.getEdgeEnd() == 9L ? 1 : 0) != 0);
        columnCursor.setPosition(23L);
        Assert.assertTrue((countryCursor.getEdgeStart() == 15L ? 1 : 0) != 0);
        Assert.assertTrue((countryCursor.getEdgeEnd() == 23L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeStart() == 23L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeEnd() == 23L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeStart() == 23L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeEnd() == 23L ? 1 : 0) != 0);
        Assert.assertTrue((timeCursor.getEdgeStart() == 23L ? 1 : 0) != 0);
        Assert.assertTrue((timeCursor.getEdgeEnd() == 23L ? 1 : 0) != 0);
        columnCursor.setPosition(12L);
        Assert.assertTrue((countryCursor.getEdgeStart() == 12L ? 1 : 0) != 0);
        Assert.assertTrue((countryCursor.getEdgeEnd() == 14L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeStart() == 12L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeEnd() == 13L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeStart() == 12L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeEnd() == 12L ? 1 : 0) != 0);
        Assert.assertTrue((timeCursor.getEdgeStart() == 12L ? 1 : 0) != 0);
        Assert.assertTrue((timeCursor.getEdgeEnd() == 12L ? 1 : 0) != 0);
        columnCursor.beforeFirst();
        columnCursor.setPosition(24L);
        Assert.assertTrue((countryCursor.getEdgeStart() == -1L ? 1 : 0) != 0);
        Assert.assertTrue((countryCursor.getEdgeEnd() == -1L ? 1 : 0) != 0);
        this.close(dataCursor);
    }

    @Test
    public void testNavigator() throws DataException, OLAPException, IOException {
        ICubeQueryDefinition cqd = this.creator.createQueryDefinition();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("SUM");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        EdgeCursor rowCursor = cubeView.getRowEdgeView().getEdgeCursor();
        EdgeCursor columnCursor = cubeView.getColumnEdgeView().getEdgeCursor();
        DimensionCursor countryCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(0);
        DimensionCursor cityCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(1);
        DimensionCursor streetCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(2);
        DimensionCursor timeCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(3);
        columnCursor.beforeFirst();
        Object out = "";
        while (columnCursor.next()) {
            out = (String)out + "edgePosition is " + columnCursor.getPosition() + "\n";
            out = (String)out + "country edge start at " + countryCursor.getEdgeStart() + "\n";
            out = (String)out + "country edge end at " + countryCursor.getEdgeEnd() + "\n";
            out = (String)out + "city edge start at " + cityCursor.getEdgeStart() + "\n";
            out = (String)out + "city edge end at " + cityCursor.getEdgeEnd() + "\n";
            out = (String)out + "street edge start at " + streetCursor.getEdgeStart() + "\n";
            out = (String)out + "street edge end at " + streetCursor.getEdgeEnd() + "\n";
            out = (String)out + "time edge start at " + timeCursor.getEdgeStart() + "\n";
            out = (String)out + "time edge end at " + timeCursor.getEdgeEnd() + "\n";
            out = (String)out + "\n";
        }
        System.out.print((String)out);
        this.testOut.print((String)out);
        this.checkOutputFile();
        this.close(dataCursor);
    }

    public void testNavigatorOnSubCursor() throws DataException, OLAPException, IOException {
        ICubeQueryDefinition cqd = this.creator.createQueryDefinition();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("SUM");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        EdgeCursor rowCursor = cubeView.getRowEdgeView().getEdgeCursor();
        EdgeCursor columnCursor = cubeView.getColumnEdgeView().getEdgeCursor();
        BirtCubeView subCubeView = new BirtCubeView(cubeView.getCubeQueryExecutor(), this.cube, null, null);
        columnCursor.beforeFirst();
        rowCursor.next();
        columnCursor.setPosition(8L);
        CubeCursor subCursor = subCubeView.getCubeCursor(new StopSign(), "dimension[\"dimension1\"][\"level11\"]", "dimension[\"dimension5\"][\"level21\"]", cubeView);
        EdgeCursor subRowCursor = subCubeView.getRowEdgeView().getEdgeCursor();
        EdgeCursor subColumnCursor = subCubeView.getColumnEdgeView().getEdgeCursor();
        subRowCursor.beforeFirst();
        subColumnCursor.beforeFirst();
        Assert.assertTrue((boolean)subRowCursor.isBeforeFirst());
        Assert.assertTrue((boolean)subColumnCursor.isBeforeFirst());
        subRowCursor.first();
        subColumnCursor.first();
        Assert.assertTrue((boolean)subRowCursor.isFirst());
        Assert.assertTrue((boolean)subColumnCursor.isFirst());
        Assert.assertTrue((subRowCursor.getPosition() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((subColumnCursor.getPosition() == 0L ? 1 : 0) != 0);
        subColumnCursor.setPosition(3L);
        Assert.assertTrue((subColumnCursor.getPosition() == 3L ? 1 : 0) != 0);
        subRowCursor.beforeFirst();
        subRowCursor.next();
        subColumnCursor.setPosition(3L);
        DimensionCursor c1 = (DimensionCursor)subColumnCursor.getDimensionCursor().get(0);
        DimensionCursor c2 = (DimensionCursor)subColumnCursor.getDimensionCursor().get(1);
        DimensionCursor c3 = (DimensionCursor)subColumnCursor.getDimensionCursor().get(2);
        DimensionCursor c4 = (DimensionCursor)subColumnCursor.getDimensionCursor().get(3);
        Assert.assertTrue((boolean)c1.getObject(0).toString().equals("JP"));
        Assert.assertTrue((boolean)c2.getObject(0).toString().equals("TK"));
        Assert.assertTrue((boolean)c3.getObject(0).toString().equals("A4"));
        Assert.assertTrue((boolean)c4.getObject(0).toString().equals("1999"));
        columnCursor.setPosition(5L);
        subCursor = subCubeView.getCubeCursor(new StopSign(), "dimension[\"dimension1\"][\"level11\"]", "dimension[\"dimension5\"][\"level21\"]", cubeView);
        subRowCursor = subCubeView.getRowEdgeView().getEdgeCursor();
        subColumnCursor = subCubeView.getColumnEdgeView().getEdgeCursor();
        subColumnCursor.setPosition(7L);
        c1 = (DimensionCursor)subColumnCursor.getDimensionCursor().get(0);
        c2 = (DimensionCursor)subColumnCursor.getDimensionCursor().get(1);
        c3 = (DimensionCursor)subColumnCursor.getDimensionCursor().get(2);
        c4 = (DimensionCursor)subColumnCursor.getDimensionCursor().get(3);
        Assert.assertTrue((boolean)c1.getObject(0).toString().equals("CN"));
        Assert.assertTrue((boolean)c2.getObject(0).toString().equals("SZ"));
        Assert.assertTrue((boolean)c3.getObject(0).toString().equals("A1"));
        Assert.assertTrue((boolean)c4.getObject(0).toString().equals("1998"));
        this.close(dataCursor);
    }

    @Test
    public void testNavigatorOnPage() throws Exception {
        ICubeQueryDefinition cqd = this.creator.createQueryDefintionWithPage1();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("AVE");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        Binding totalGrandTotal = new Binding("totalGrandTotal");
        totalGrandTotal.setAggrFunction("SUM");
        totalGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        totalGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        cqd.addBinding((IBinding)totalGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()), this.cube, null, null);
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        EdgeCursor pageCursor = (EdgeCursor)dataCursor.getPageEdge().toArray()[0];
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        pageCursor.setPosition(0L);
        dataCursor.synchronizePages();
        String output = "The NO." + pageCursor.getPosition() + " is:";
        int i = 0;
        while (i < pageCursor.getDimensionCursor().size()) {
            output = output + String.valueOf(((DimensionCursor)pageCursor.getDimensionCursor().get(i)).getObject(0));
            ++i;
        }
        output = output + "\n";
        output = output + this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null);
        output = output + "\n";
        pageCursor.setPosition(3L);
        dataCursor.synchronizePages();
        output = output + "The NO." + pageCursor.getPosition() + " is:";
        i = 0;
        while (i < pageCursor.getDimensionCursor().size()) {
            output = output + String.valueOf(((DimensionCursor)pageCursor.getDimensionCursor().get(i)).getObject(0));
            ++i;
        }
        output = output + "\n";
        output = output + this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null);
        output = output + "\n";
        pageCursor.setPosition(1L);
        dataCursor.synchronizePages();
        output = output + "The NO." + pageCursor.getPosition() + " is:";
        i = 0;
        while (i < pageCursor.getDimensionCursor().size()) {
            output = output + String.valueOf(((DimensionCursor)pageCursor.getDimensionCursor().get(i)).getObject(0));
            ++i;
        }
        output = output + "\n";
        output = output + this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null);
        output = output + "\n";
        pageCursor.last();
        dataCursor.synchronizePages();
        output = output + "The NO." + pageCursor.getPosition() + " is:";
        i = 0;
        while (i < pageCursor.getDimensionCursor().size()) {
            output = output + String.valueOf(((DimensionCursor)pageCursor.getDimensionCursor().get(i)).getObject(0));
            ++i;
        }
        output = output + "\n";
        output = output + this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null);
        output = output + "\n";
        this.testOut.print(output);
        this.checkOutputFile();
        this.close(dataCursor);
    }

    private void close(CubeCursor dataCursor) throws OLAPException {
        int i = 0;
        while (i < dataCursor.getOrdinateEdge().size()) {
            EdgeCursor edge = (EdgeCursor)dataCursor.getOrdinateEdge().get(i);
            edge.close();
            ++i;
        }
        dataCursor.close();
    }
}

