/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.DriverManager;
import org.eclipse.birt.data.engine.odaconsumer.OdaconsumerTestCase;
import org.eclipse.birt.data.engine.odaconsumer.testutil.TraceLogTesterUtil;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConsumerPlugin;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class ConnectionManagerTest
extends OdaconsumerTestCase {
    private ConnectionManager sm_manager;
    private LogConfiguration m_testerLogConfig;
    private File m_logDir;

    ConnectionManager getManager() {
        if (this.sm_manager == null) {
            this.sm_manager = ConnectionManager.getInstance();
        }
        return this.sm_manager;
    }

    @Before
    public void connectionManagerSetUp() throws Exception {
        if (this.getTestName().equals("testPassThruContext") && this.getClass().getName().endsWith("ConnectionManagerTest")) {
            this.m_testerLogConfig = this.getOdaHelperTestLogConfig("org.eclipse.birt.report.data.oda.jdbc");
            this.m_logDir = new File(this.m_testerLogConfig.getLogDirectory());
            TraceLogTesterUtil.getInstance().clearDirectory(this.m_logDir);
        }
    }

    @After
    public void connectionManagerTearDown() throws Exception {
        if (this.getTestName().equals("testPassThruContext") && this.getClass().getName().endsWith("ConnectionManagerTest")) {
            LogConfiguration offLogConfig = new LogConfiguration(Integer.MAX_VALUE, this.m_testerLogConfig.getLogDirectory(), "", "");
            this.setOdaHelperLogConfig("org.eclipse.birt.report.data.oda.jdbc", offLogConfig);
            try {
                TraceLogTesterUtil.getInstance().clearDirectory(this.m_logDir);
                this.m_logDir.delete();
            }
            catch (IOException e) {
                Assert.fail((String)("Problem with tearDown for test 4: " + e.toString()));
            }
            this.m_testerLogConfig = null;
            this.m_logDir = null;
        }
    }

    public final void testGetInstance() {
        Assert.assertNotNull((Object)this.getManager());
    }

    public final void testOpenConnection() throws Exception {
        Properties connProperties = this.getJdbcConnProperties();
        Connection conn = this.getManager().openConnection("org.eclipse.birt.report.data.oda.jdbc", connProperties, null);
        Assert.assertNotNull((Object)conn);
        conn.close();
    }

    public final void testGetMaxConnections() throws DataException {
        Assert.assertEquals((long)this.getManager().getMaxConnections("org.eclipse.birt.report.data.oda.jdbc"), (long)0L);
    }

    public final void testPassThruContext() throws Exception {
        String testClassName = this.getClass().getName();
        if (!testClassName.endsWith("ConnectionManagerTest")) {
            return;
        }
        Assert.assertNotNull((Object)this.m_testerLogConfig);
        Assert.assertNotNull((Object)this.m_logDir);
        this.setOdaHelperLogConfig("org.eclipse.birt.report.data.oda.jdbc", this.m_testerLogConfig);
        Properties connProperties = this.getJdbcConnProperties();
        Properties dummyAppContext = new Properties();
        Connection conn = this.getManager().openConnection("org.eclipse.birt.report.data.oda.jdbc", connProperties, (Map)dummyAppContext);
        Assert.assertNotNull((Object)conn);
        String queryText = "select * from \"testtable\" where \"intColumn\" > ?";
        conn.prepareStatement(queryText, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        conn.close();
        String emptyParen = "\\(\\)\t";
        String[] expectedLogs = new String[]{"OdaDriver.setAppContext\\(\\)\tPassing thru application context ", "OdaConnection.setAppContext\\(\\)\tPassing thru application context ", "OdaQuery.setAppContext\\(\\)\tPassing thru application context "};
        String[] logFiles = this.m_logDir.list();
        Assert.assertNotNull((Object)logFiles);
        Assert.assertEquals((long)1L, (long)logFiles.length);
        String logFileName = String.valueOf(this.m_logDir) + "/" + logFiles[0];
        boolean hasExpectedLogs = TraceLogTesterUtil.getInstance().matchLogPatternsInFile(logFileName, expectedLogs);
        Assert.assertTrue((boolean)hasExpectedLogs);
    }

    private void sanityCheckProperties() throws Exception {
        if (System.getProperty("odaJdbcUrl") == null || System.getProperty("odaJdbcUser") == null || System.getProperty("odaJdbcPassword") == null || System.getProperty("odaJdbcDriver") == null) {
            System.setProperty("odaJdbcUrl", "jdbc:derby:DtETest");
            System.setProperty("odaJdbcUser", "sa");
            System.setProperty("odaJdbcPassword", "sa");
            System.setProperty("odaJdbcDriver", "org.apache.derby.jdbc.EmbeddedDriver");
        }
    }

    protected Properties getJdbcConnProperties() throws Exception {
        this.sanityCheckProperties();
        Properties connProperties = new Properties();
        connProperties.setProperty("odaURL", System.getProperty("odaJdbcUrl"));
        connProperties.setProperty("odaUser", System.getProperty("odaJdbcUser"));
        connProperties.setProperty("odaPassword", System.getProperty("odaJdbcPassword"));
        connProperties.setProperty("odaDriverClass", System.getProperty("odaJdbcDriver"));
        return connProperties;
    }

    private LogConfiguration getOdaHelperTestLogConfig(String dataSourceId) throws Exception {
        String logDir = this.getOdaHelperLogDir(dataSourceId);
        LogConfiguration testLogConfig = new LogConfiguration(500, logDir, "", "");
        return testLogConfig;
    }

    private String getOdaHelperLogDir(String dataSourceId) {
        return OdaConsumerPlugin.getDefault().getStateLocation().append("logs").append("ConnectionManagerTest").toFile().getPath();
    }

    private void setOdaHelperLogConfig(String dataSourceId, LogConfiguration testLogConfig) throws Exception {
        IDriver driverHelper = DriverManager.getInstance().getDriverHelper(dataSourceId);
        Assert.assertTrue((boolean)(driverHelper instanceof OdaDriver));
        OdaDriver odaDrvHelper = (OdaDriver)driverHelper;
        odaDrvHelper.setLogDirectory(testLogConfig.getLogDirectory());
        driverHelper.setLogConfiguration(testLogConfig);
    }
}

