/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ArchiveFileTest
extends TestCase {
    static final String ARCHIVE_FOLDER = "./utest/";
    static final String ARCHIVE_FILE = "./utest/archive.rptdocument";
    static final String TRANSIENT_ARCHIVE_FILE = "./utest/t_archive.rptdocument";
    static final String TEMP_ARCHIVE_FOLDER = "./utest_temp/";

    @Before
    public void setUp() {
        new File(ARCHIVE_FOLDER).mkdirs();
        new File(TEMP_ARCHIVE_FOLDER).mkdirs();
    }

    @After
    public void tearDown() {
        new File(TRANSIENT_ARCHIVE_FILE).delete();
        new File(ARCHIVE_FILE).delete();
        new File(ARCHIVE_FOLDER).delete();
        File tempFolder = new File(TEMP_ARCHIVE_FOLDER);
        File[] fileArray = tempFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
        tempFolder.delete();
    }

    @Test
    public void testArchiveFile() throws IOException {
        ArchiveFile archive = new ArchiveFile(ARCHIVE_FILE, "rw");
        archive.setCacheSize(0L);
        archive.setCacheSize(65536L);
        this.createArchive(archive);
        this.checkArchive(archive);
        ArchiveFileTest.assertTrue((archive.getUsedCache() > 0L ? 1 : 0) != 0);
        ArchiveFileTest.assertTrue((archive.getUsedCache() <= 65536L ? 1 : 0) != 0);
        archive.close();
        ArchiveFileTest.assertTrue((archive.getUsedCache() == 0L ? 1 : 0) != 0);
        archive = new ArchiveFile(ARCHIVE_FILE, "r");
        this.checkArchive(archive);
        archive.close();
    }

    @Test
    public void testArchiveFileNoCache() throws IOException {
        ArchiveFile archive = new ArchiveFile(ARCHIVE_FILE, "rw");
        archive.setCacheSize(0L);
        this.createArchive(archive);
        this.checkArchive(archive);
        ArchiveFileTest.assertEquals((long)archive.getUsedCache(), (long)0L);
        archive.close();
        ArchiveFileTest.assertTrue((archive.getUsedCache() == 0L ? 1 : 0) != 0);
        archive = new ArchiveFile(ARCHIVE_FILE, "rw");
        archive.setCacheSize(65536L);
        this.createArchive(archive);
        this.checkArchive(archive);
        ArchiveFileTest.assertTrue((archive.getUsedCache() > 0L ? 1 : 0) != 0);
        archive.setCacheSize(0L);
        this.createArchive(archive);
        this.checkArchive(archive);
        ArchiveFileTest.assertEquals((long)archive.getUsedCache(), (long)0L);
        archive.close();
        ArchiveFileTest.assertTrue((archive.getUsedCache() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testTransient() throws IOException {
        ArchiveFile archive = new ArchiveFile(TRANSIENT_ARCHIVE_FILE, "rwt");
        this.createArchive(archive);
        this.checkArchive(archive);
        archive.close();
        ArchiveFileTest.assertTrue((!new File(TRANSIENT_ARCHIVE_FILE).exists() ? 1 : 0) != 0);
    }

    @Test
    public void testAppend() throws IOException {
        ArchiveFile archive = new ArchiveFile(ARCHIVE_FILE, "rw");
        this.createArchive(archive);
        archive.close();
        archive = new ArchiveFile(ARCHIVE_FILE, "rw+");
        ArchiveEntry entry = archive.createEntry("/append");
        entry.write(0L, new byte[1], 0, 1);
        entry.close();
        this.checkArchive(archive);
        entry = archive.openEntry("/append");
        ArchiveFileTest.assertTrue((entry != null ? 1 : 0) != 0);
        ArchiveFileTest.assertEquals((long)1L, (long)entry.getLength());
        entry.close();
        archive.close();
        archive = new ArchiveFile(ARCHIVE_FILE, "r");
        this.checkArchive(archive);
        entry = archive.openEntry("/append");
        ArchiveFileTest.assertTrue((entry != null ? 1 : 0) != 0);
        ArchiveFileTest.assertEquals((long)1L, (long)entry.getLength());
        entry.close();
        archive.close();
    }

    @Test
    public void testSaveAs() throws IOException {
        ArchiveFile archive = new ArchiveFile(TRANSIENT_ARCHIVE_FILE, "rwt");
        this.createArchive(archive);
        archive.saveAs(ARCHIVE_FILE);
        archive.close();
        archive = new ArchiveFile(ARCHIVE_FILE, "r");
        this.checkArchive(archive);
        archive.close();
    }

    @Test
    public void testFlush() throws IOException {
        ArchiveFile archive = new ArchiveFile(TRANSIENT_ARCHIVE_FILE, "rw");
        this.createArchive(archive);
        archive.flush();
        ArchiveFile newArchive = new ArchiveFile(TRANSIENT_ARCHIVE_FILE, "r");
        this.checkArchive(newArchive);
        newArchive.close();
        archive.close();
    }

    void createArchive(ArchiveFile archive) throws IOException {
        int entryCount = 1024;
        byte[] b = new byte[entryCount];
        int i = 0;
        while (i < entryCount) {
            ArchiveEntry entry = archive.createEntry("/entry/" + i);
            entry.write(0L, b, 0, i);
            entry.close();
            ++i;
        }
    }

    void checkArchive(ArchiveFile archive) throws IOException {
        int entryCount = 1024;
        int i = 0;
        while (i < entryCount) {
            try (ArchiveEntry entry = archive.openEntry("/entry/" + i);){
                ArchiveFileTest.assertTrue((entry != null ? 1 : 0) != 0);
                ArchiveFileTest.assertEquals((long)i, (long)entry.getLength());
            }
            ++i;
        }
    }

    @Test
    public void testSetTempFileFolder() throws IOException {
        ArchiveFile.setTempFileFolder((String)TEMP_ARCHIVE_FOLDER);
        ArchiveFile archive = new ArchiveFile(TRANSIENT_ARCHIVE_FILE, "rwz");
        this.createArchive(archive);
        File folder = new File(TEMP_ARCHIVE_FOLDER);
        String[] files = folder.list();
        ArchiveFileTest.assertEquals((int)1, (int)files.length);
        ArchiveFileTest.assertTrue((boolean)files[0].startsWith("temp_"));
        ArchiveFileTest.assertTrue((boolean)files[0].endsWith(".archive"));
        this.checkArchive(archive);
        archive.close();
        ArchiveFile.setTempFileFolder(null);
    }
}

