/*
 * Copyright (c) 2023 Bernhard Haumacher et al. All Rights Reserved.
 */
package org.w3c.tidy;

/**
 * Constants for supported HTML schemas.
 */
public enum HtmlVersion {

    /**
     * unknown.
     */
    UNKNOWN,

    /**
     * html 2.0.
     */
    HTML20,

    /**
     * html 3.2.
     */
    HTML32,

    /**
     * html 4.0 strict.
     */
    HTML40_STRICT,

    /**
     * html 4.0 transitional.
     */
    HTML40_LOOSE,

    /**
     * html 4.0 frameset.
     */
    FRAMESET,

    /**
     * xml.
     */
    XML,

    /**
     * netscape.
     */
    NETSCAPE,

    /**
     * microsoft.
     */
    MICROSOFT,

    /**
     * sun.
     */
    SUN,

    /**
     * malformed.
     */
    MALFORMED,

    /**
     * xhtml 1.1.
     */
    XHTML11,

    /**
     * xhtml basic.
     */
    BASIC,
    
    /**
     * HTML 5.
     */
    HTML5,
    
    ;

}
