/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.parser.ReportParser;

public class PageSetupTest
extends TestCase {
    protected Report report;

    public void setUp() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("pagesetup.xml");
        PageSetupTest.assertTrue((in != null ? 1 : 0) != 0);
        ReportParser parser = new ReportParser();
        this.report = parser.parse("pagesetup.xml", in);
        PageSetupTest.assertTrue((this.report != null ? 1 : 0) != 0);
        PageSetupTest.assertTrue((boolean)this.report.getErrors().isEmpty());
    }

    public void testMasterPage() throws Exception {
        PageSetupDesign pageSetup = this.report.getPageSetup();
        PageSetupTest.assertEquals((int)pageSetup.getMasterPageCount(), (int)2);
        SimpleMasterPageDesign page = (SimpleMasterPageDesign)pageSetup.getMasterPage(0);
        PageSetupTest.assertEquals((String)"page", (String)page.getName());
        PageSetupTest.assertEquals((double)29.7, (double)page.getPageHeight().convertTo("cm"), (double)0.1);
        PageSetupTest.assertEquals((double)21.0, (double)page.getPageWidth().convertTo("cm"), (double)0.1);
        PageSetupTest.assertEquals((String)"2.5cm", (String)page.getBottomMargin().toString());
        PageSetupTest.assertEquals((String)"2.5cm", (String)page.getTopMargin().toString());
        PageSetupTest.assertEquals((String)"0.5cm", (String)page.getLeftMargin().toString());
        PageSetupTest.assertEquals((String)"0.5cm", (String)page.getRightMargin().toString());
        page = (SimpleMasterPageDesign)pageSetup.getMasterPage(1);
        PageSetupTest.assertEquals((String)"default", (String)page.getName());
        PageSetupTest.assertEquals((String)"1in", (String)page.getBottomMargin().toString());
        PageSetupTest.assertEquals((String)"1in", (String)page.getTopMargin().toString());
        PageSetupTest.assertEquals((String)"1.25in", (String)page.getLeftMargin().toString());
        PageSetupTest.assertEquals((String)"1.25in", (String)page.getRightMargin().toString());
        PageSetupTest.assertEquals((String)"0.5in", (String)page.getHeaderHeight().toString());
        PageSetupTest.assertEquals((String)"0.5in", (String)page.getFooterHeight().toString());
    }
}

