/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.EngineStatusHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IStatusHandler;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.engine.api.TaskStatusHandler;

public class EngineTaskStatusTest
extends EngineCase {
    static final String DESIGN = "org/eclipse/birt/report/engine/api/status_handler.rptdesign";
    ByteArrayOutputStream engineOutput;
    ByteArrayOutputStream taskOutput;
    EngineStatusHandler engineHandler;
    TaskStatusHandler taskHandler;

    public void setUp() {
        this.engineOutput = new ByteArrayOutputStream();
        EngineConfig config = new EngineConfig();
        this.engineHandler = new EngineStatusHandler(this.engineOutput);
        config.setStatusHandler((IStatusHandler)this.engineHandler);
        this.engine = new ReportEngine(config);
    }

    public void tearDown() {
        if (this.engine != null) {
            this.engine.destroy();
        }
        this.engine = null;
    }

    public void testEngineStatusHandler() {
        try {
            this.useDesignFile(DESIGN);
            IReportRunnable runnable = this.engine.openReportDesign("design.rptdesign");
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            HTMLRenderOption options = new HTMLRenderOption();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            options.setOutputStream((OutputStream)out);
            options.setOutputFormat("html");
            options.setHtmlPagination(true);
            task.setRenderOption((IRenderOption)options);
            task.run();
            task.close();
            this.engine.destroy();
            this.engine = null;
            EngineTaskStatusTest.assertEquals((String)this.engineOutput.toString(), (String)this.engineHandler.getGoldenResult());
        }
        catch (EngineException ex) {
            ex.printStackTrace();
        }
    }

    public void testTaskStatusHandler() {
        try {
            this.taskOutput = new ByteArrayOutputStream();
            this.taskHandler = new TaskStatusHandler(this.taskOutput);
            this.useDesignFile(DESIGN);
            IReportRunnable runnable = this.engine.openReportDesign("design.rptdesign");
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            HTMLRenderOption options = new HTMLRenderOption();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            options.setOutputStream((OutputStream)out);
            options.setOutputFormat("html");
            options.setHtmlPagination(true);
            task.setRenderOption((IRenderOption)options);
            task.setStatusHandler((IStatusHandler)this.taskHandler);
            task.run();
            task.close();
            EngineTaskStatusTest.assertEquals((String)this.taskOutput.toString(), (String)this.taskHandler.getGoldenResult());
        }
        catch (EngineException ex) {
            ex.printStackTrace();
        }
    }

    public void testMixedStatusHandler() {
        try {
            this.useDesignFile(DESIGN);
            IReportRunnable runnable = this.engine.openReportDesign("design.rptdesign");
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            HTMLRenderOption options = new HTMLRenderOption();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            options.setOutputStream((OutputStream)out);
            options.setOutputFormat("html");
            options.setHtmlPagination(true);
            task.setRenderOption((IRenderOption)options);
            task.run();
            task.close();
            EngineTaskStatusTest.assertEquals((String)this.engineOutput.toString(), (String)this.engineHandler.getUnfinishedGoldenResult());
            this.taskOutput = new ByteArrayOutputStream();
            this.taskHandler = new TaskStatusHandler(this.taskOutput);
            task = this.engine.createRunAndRenderTask(runnable);
            options = new HTMLRenderOption();
            out = new ByteArrayOutputStream();
            options.setOutputStream((OutputStream)out);
            options.setOutputFormat("html");
            options.setHtmlPagination(true);
            task.setRenderOption((IRenderOption)options);
            task.setStatusHandler((IStatusHandler)this.taskHandler);
            task.run();
            task.close();
            EngineTaskStatusTest.assertEquals((String)this.taskOutput.toString(), (String)this.taskHandler.getGoldenResult());
            this.taskOutput.reset();
            task = this.engine.createRunAndRenderTask(runnable);
            options = new HTMLRenderOption();
            out = new ByteArrayOutputStream();
            options.setOutputStream((OutputStream)out);
            options.setOutputFormat("html");
            options.setHtmlPagination(true);
            task.setRenderOption((IRenderOption)options);
            task.run();
            task.close();
            this.engine.destroy();
            this.engine = null;
            EngineTaskStatusTest.assertEquals((String)this.engineOutput.toString(), (String)this.engineHandler.getGoldenResult());
            EngineTaskStatusTest.assertEquals((String)this.taskOutput.toString(), (String)"");
        }
        catch (EngineException ex) {
            ex.printStackTrace();
        }
    }
}

