/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class UserPropertyExceptionTest
extends BaseTestCase {
    public void testErrorMessages() throws Exception {
        TableItem table = new TableItem();
        this.os = new ByteArrayOutputStream();
        table.setName("customerTable");
        String propName = "userProp1";
        UserPropertyException error = new UserPropertyException((DesignElement)table, "", "Error.UserPropertyException.NAME_REQUIRED");
        this.print(error);
        error = new UserPropertyException((DesignElement)table, propName, "Error.UserPropertyException.DUPLICATE_NAME");
        this.print(error);
        error = new UserPropertyException((DesignElement)table, propName, "Error.UserPropertyException.INVALID_TYPE");
        this.print(error);
        error = new UserPropertyException((DesignElement)table, propName, "Error.UserPropertyException.MISSING_CHOICES");
        this.print(error);
        error = new UserPropertyException((DesignElement)table, propName, "Error.UserPropertyException.INVALID_DISPLAY_ID");
        this.print(error);
        error = new UserPropertyException((DesignElement)table, propName, "Error.UserPropertyException.NOT_FOUND");
        this.print(error);
        error = new UserPropertyException((DesignElement)table, propName, "Error.UserPropertyException.USER_PROP_DISALLOWED");
        this.print(error);
        error = new UserPropertyException((DesignElement)table, propName, "Error.UserPropertyException.CHOICE_NAME_REQUIRED");
        this.print(error);
        error = new UserPropertyException((DesignElement)table, propName, "Error.UserPropertyException.CHOICE_VALUE_REQUIRED");
        this.print(error);
        error = new UserPropertyException((DesignElement)table, propName, "Error.UserPropertyException.INVALID_CHOICE_VALUE");
        this.print(error);
        this.os.close();
        UserPropertyExceptionTest.assertTrue((boolean)this.compareFile("UserPropertyExceptionError.golden.txt"));
    }

    private void print(UserPropertyException error) {
        block3: {
            String code = error.getErrorCode();
            try {
                this.os.write(code.getBytes());
                int i = code.length();
                while (i < 60) {
                    this.os.write(32);
                    ++i;
                }
                this.os.write(error.getMessage().getBytes());
                this.os.write(10);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }
}

