/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class MemberValueHandleTest
extends BaseTestCase {
    private static final String FILE_NAME = "MemberValueHandleTest.xml";
    private static final String FILE_NAME_EXTENDS = "MemberValueHandleTest_1.xml";

    public void testMemberValue() throws Exception {
        this.openDesign(FILE_NAME);
        DesignElementHandle testTable = this.designHandle.findElement("testTable");
        MemberValueHandleTest.assertNotNull((Object)testTable);
        List valueList = testTable.getListProperty("filter");
        MemberValueHandleTest.assertEquals((int)2, (int)valueList.size());
        FilterConditionElementHandle filter = (FilterConditionElementHandle)valueList.get(0);
        MemberValueHandle memberValue = filter.getMember();
        MemberValueHandle newValue = this.designHandle.getElementFactory().newMemberValue();
        newValue.setLevel(this.designHandle.findLevel("testDimension/testLevel_one"));
        memberValue.add("memberValues", (DesignElementHandle)newValue);
        filter.drop("member", 0);
        this.designHandle.getCommandStack().undo();
        newValue.drop();
    }

    public void testContentElementCommandOnMemberValue() throws Exception {
        this.openDesign(FILE_NAME_EXTENDS);
        DesignElementHandle testTable = this.designHandle.findElement("testTable");
        List valueList = testTable.getListProperty("filter");
        MemberValueHandleTest.assertEquals((int)2, (int)valueList.size());
        FilterConditionElementHandle filter = (FilterConditionElementHandle)valueList.get(0);
        MemberValueHandle memberValue = filter.getMember();
        memberValue.setValue("new value 1");
        this.save();
        MemberValueHandleTest.assertTrue((boolean)this.compareFile("MemberValueHandleTest_golden_1.xml"));
        this.designHandle.getCommandStack().undo();
        this.save();
        MemberValueHandleTest.assertTrue((boolean)this.compareFile("MemberValueHandleTest_golden_2.xml"));
        valueList = (List)memberValue.getProperty("memberValues");
        memberValue = (MemberValueHandle)valueList.get(0);
        memberValue.setValue("new nested value 1");
        this.save();
        MemberValueHandleTest.assertTrue((boolean)this.compareFile("MemberValueHandleTest_golden_3.xml"));
        this.designHandle.getCommandStack().undo();
        this.save();
        MemberValueHandleTest.assertTrue((boolean)this.compareFile("MemberValueHandleTest_golden_4.xml"));
    }
}

