/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.ApiTestUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class FontHandleTest
extends BaseTestCase {
    private FontHandle fontHandle = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("FontHandleTest.xml");
        FontHandleTest.assertNotNull((Object)this.designHandle);
    }

    public void testParse() throws SemanticException {
        SharedStyleHandle myStyle = this.designHandle.findStyle("My-Style");
        FontHandleTest.assertNotNull((Object)myStyle);
        this.fontHandle = myStyle.getFontFamilyHandle();
        FontHandleTest.assertEquals((String)"cursive", (String)this.fontHandle.getStringValue());
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        FontHandleTest.assertEquals((String)"\u8fde\u4f53", (String)this.fontHandle.getDisplayValue());
        FontHandleTest.assertEquals((String)"cursive", (String)this.fontHandle.getStringValue());
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        FontHandleTest.assertEquals((String)"Cursive", (String)this.fontHandle.getDisplayValue());
        SharedStyleHandle style1 = this.designHandle.findStyle("Style1");
        FontHandleTest.assertNotNull((Object)style1);
        this.fontHandle = style1.getFontFamilyHandle();
        FontHandleTest.assertEquals((String)"\"Time New Roman\", \"Arial\"", (String)this.fontHandle.getStringValue());
        String[] names = this.fontHandle.getFontFamilies();
        FontHandleTest.assertEquals((String)"\"Time New Roman\"", (String)names[0]);
        FontHandleTest.assertEquals((String)"\"Arial\"", (String)names[1]);
        this.fontHandle.setValue((Object)"sans-serif");
        FontHandleTest.assertEquals((String)"sans-serif", (String)this.fontHandle.getStringValue());
        Iterator highlightHandles = style1.highlightRulesIterator();
        FontHandleTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        FontHandleTest.assertNotNull((Object)highlightHandle);
        FontHandle fontHandle = highlightHandle.getFontFamilyHandle();
        FontHandleTest.assertNotNull((Object)fontHandle);
        FontHandleTest.assertNull((Object)fontHandle.getStringValue());
        FontHandleTest.assertNull((Object)fontHandle.getFontFamilies());
        SharedStyleHandle style2 = this.designHandle.findStyle("Style2");
        FontHandleTest.assertNotNull((Object)style2);
        fontHandle = null;
        fontHandle = style2.getFontFamilyHandle();
        FontHandleTest.assertNotNull((Object)fontHandle);
        names = fontHandle.getFontFamilies();
        FontHandleTest.assertEquals((int)1, (int)names.length);
        FontHandleTest.assertEquals((String)"serif", (String)names[0]);
        FontHandleTest.assertEquals((String)"lighter", (String)style2.getFontWeight());
        style2.setFontWeight("100");
        FontHandleTest.assertEquals((String)"100", (String)style2.getFontWeight());
        try {
            style2.setFontWeight("450");
            FontHandleTest.fail();
        }
        catch (PropertyValueException e) {
            FontHandleTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.CHOICE_NOT_FOUND");
        }
        highlightHandles = style2.highlightRulesIterator();
        FontHandleTest.assertNotNull((Object)highlightHandles);
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        FontHandleTest.assertNotNull((Object)highlightHandle);
        fontHandle = highlightHandle.getFontFamilyHandle();
        FontHandleTest.assertEquals((String)"\"Arial\"", (String)fontHandle.getStringValue());
        FontHandleTest.assertEquals((String)"\"Arial\"", (String)fontHandle.getDisplayValue());
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        FontHandleTest.assertNull((Object)highlightHandle);
        OdaDataSourceHandle dataSource = (OdaDataSourceHandle)this.designHandle.findDataSource("myDataSource");
        FontHandleTest.assertNotNull((Object)dataSource);
        fontHandle = ApiTestUtil.getFontProperty((DesignElementHandle)dataSource);
        FontHandleTest.assertNull((Object)fontHandle);
    }

    public void testSetValue() throws Exception {
        SharedStyleHandle myStyle = this.designHandle.findStyle("My-Style");
        FontHandleTest.assertNotNull((Object)myStyle);
        this.fontHandle = myStyle.getFontFamilyHandle();
        ThreadResources.setLocale((ULocale)new ULocale("am", "ET"));
        this.fontHandle.setValue((Object)"sans-serif");
        SharedStyleHandle style1 = this.designHandle.findStyle("Style1");
        FontHandleTest.assertNotNull((Object)style1);
        this.fontHandle = style1.getFontFamilyHandle();
        this.fontHandle.setValue((Object)"sans-serif");
        FontHandleTest.assertEquals((String)"sans-serif", (String)this.fontHandle.getStringValue());
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        this.fontHandle.setValue((Object)"\u8fde\u4f53");
        FontHandleTest.assertEquals((String)"cursive", (String)this.fontHandle.getStringValue());
        SharedStyleHandle style2 = this.designHandle.findStyle("Style2");
        FontHandleTest.assertNotNull((Object)style2);
        this.fontHandle = style2.getFontFamilyHandle();
        this.fontHandle.setValue((Object)"cursive, sans-serif, hello");
        style2.setFontWeight("100");
        FontHandleTest.assertEquals((String)"100", (String)style2.getFontWeight());
        Iterator highlightHandles = style2.highlightRulesIterator();
        FontHandleTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        FontHandleTest.assertNotNull((Object)highlightHandle);
        this.fontHandle = highlightHandle.getFontFamilyHandle();
        this.fontHandle.setValue((Object)"fantasy");
        highlightHandle.setFontWeight("900");
    }

    public void testCSSFontList() {
        SharedStyleHandle myStyle = this.designHandle.findStyle("My-Style");
        FontHandleTest.assertNotNull((Object)myStyle);
        this.fontHandle = myStyle.getFontFamilyHandle();
        IChoice[] standardChoices = this.fontHandle.getCSSFontFamilies();
        FontHandleTest.assertEquals((int)5, (int)standardChoices.length);
        FontHandleTest.assertEquals((String)standardChoices[0].getName(), (String)"serif");
        FontHandleTest.assertEquals((String)standardChoices[1].getName(), (String)"sans-serif");
        FontHandleTest.assertEquals((String)standardChoices[2].getName(), (String)"cursive");
        FontHandleTest.assertEquals((String)standardChoices[3].getName(), (String)"fantasy");
        FontHandleTest.assertEquals((String)standardChoices[4].getName(), (String)"monospace");
    }

    public void testDefn() {
        SharedStyleHandle myStyle = this.designHandle.findStyle("Style2");
        this.fontHandle = myStyle.getFontFamilyHandle();
        FontHandleTest.assertEquals((String)"fontFamily", (String)this.fontHandle.getPropertyDefn().getName());
        Iterator iter = myStyle.highlightRulesIterator();
        HighlightRuleHandle handle = (HighlightRuleHandle)iter.next();
        this.fontHandle = handle.getFontFamilyHandle();
        FontHandleTest.assertEquals((String)"highlightRules", (String)this.fontHandle.getPropertyDefn().getName());
        FontHandleTest.assertEquals((String)"fontFamily", (String)this.fontHandle.getContext().getPropDefn().getName());
    }
}

