/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ClientsDerivedIteratorTest
extends BaseTestCase {
    private String fileName = "ClientsDerivedIteratorTest.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign(this.fileName);
        ClientsDerivedIteratorTest.assertEquals((int)0, (int)this.design.getErrorList().size());
    }

    public void testDerivedIterator() throws Exception {
        SlotHandle slotHandle = this.designHandle.getComponents();
        LabelHandle lblHandle = (LabelHandle)slotHandle.get(0);
        int derivedCount = 0;
        ClientsDerivedIteratorTest.assertEquals((String)"Label One", (String)lblHandle.getElement().getName());
        Iterator iter = lblHandle.derivedIterator();
        while (iter.hasNext()) {
            DesignElementHandle derived = (DesignElementHandle)iter.next();
            ClientsDerivedIteratorTest.assertTrue((boolean)(derived.getElement() instanceof Label));
            ++derivedCount;
        }
        ClientsDerivedIteratorTest.assertEquals((int)2, (int)derivedCount);
    }

    public void testClientsIterator() throws Exception {
        StyleElement style = this.design.findStyle("My-Style");
        int clientsCount = 0;
        Iterator iter = style.getHandle((Module)this.design).clientsIterator();
        while (iter.hasNext()) {
            DesignElementHandle client = (DesignElementHandle)iter.next();
            ClientsDerivedIteratorTest.assertTrue((boolean)(client.getElement() instanceof TextItem));
            ++clientsCount;
        }
        ClientsDerivedIteratorTest.assertEquals((int)3, (int)clientsCount);
        DesignElement text = this.design.findElement("My Text");
        iter = text.getHandle((Module)this.design).clientsIterator();
        ClientsDerivedIteratorTest.assertFalse((boolean)iter.hasNext());
    }
}

