/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CellHandleTest
extends BaseTestCase {
    String fileName = "CellHandleTest.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetCellProperty() throws Exception {
        this.openDesign(this.fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table1");
        CellHandle cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"lime", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"lime", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        table = (TableHandle)this.designHandle.findElement("My table2");
        cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"red", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"red", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        CellHandleTest.assertNull((Object)cell.getProperty("backgroundColor"));
        CellHandleTest.assertEquals((Object)"repeat", (Object)cell.getProperty("backgroundRepeat"));
        CellHandleTest.assertEquals(null, (Object)cell.getFactoryPropertyHandle("backgroundColor"));
        table = (TableHandle)this.designHandle.findElement("My table3");
        cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"red", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"red", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        table = (TableHandle)this.designHandle.findElement("My table4");
        cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"silver", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals(null, (Object)cell.getFactoryPropertyHandle("color"));
        table = (TableHandle)this.designHandle.findElement("My table6");
        cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"red", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals(null, (Object)cell.getFactoryPropertyHandle("color"));
        table = (TableHandle)this.designHandle.findElement("My table11");
        cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"red", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"red", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        TableGroupHandle group = (TableGroupHandle)table.getSlot(1).get(0);
        cell = this.getCellInGroup(group, 0, 0, 0);
        CellHandleTest.assertEquals((Object)"red", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"red", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        cell = this.getCellInGroup(group, 0, 0, 1);
        CellHandleTest.assertEquals((Object)"yellow", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"yellow", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        table = (TableHandle)this.designHandle.findElement("My table13");
        cell = this.getCellInTableSlot(table, 0, 0, 0);
        CellHandleTest.assertEquals((Object)"red", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"red", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        cell = this.getCellInTableSlot(table, 0, 0, 3);
        CellHandleTest.assertEquals((Object)"green", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"green", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        cell = this.getCellInTableSlot(table, 3, 0, 0);
        CellHandleTest.assertEquals((Object)"red", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"red", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        cell = this.getCellInTableSlot(table, 3, 0, 1);
        CellHandleTest.assertEquals((Object)"aqua", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"aqua", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"aqua", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"aqua", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        table = (TableHandle)this.designHandle.findElement("My table15");
        cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"green", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals(null, (Object)cell.getFactoryPropertyHandle("color"));
        cell = this.getCellInTableSlot(table, 2, 0, 1);
        CellHandleTest.assertEquals((Object)"green", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals(null, (Object)cell.getFactoryPropertyHandle("color"));
        table = (TableHandle)this.designHandle.findElement("My table14");
        group = (TableGroupHandle)table.getSlot(1).get(0);
        cell = this.getCellInGroup(group, 1, 0, 0);
        CellHandleTest.assertEquals((Object)"green", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"green", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        table = (TableHandle)this.designHandle.findElement("My table17");
        cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"green", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals(null, (Object)cell.getFactoryPropertyHandle("color"));
        cell = this.getCellInTableSlot(table, 2, 0, 1);
        CellHandleTest.assertEquals((Object)"green", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals(null, (Object)cell.getFactoryPropertyHandle("color"));
        table = (TableHandle)this.designHandle.findElement("My table16");
        group = (TableGroupHandle)table.getSlot(1).get(0);
        cell = this.getCellInGroup(group, 1, 0, 0);
        CellHandleTest.assertEquals((Object)"green", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"green", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        table = new ElementFactory((Module)this.design).newTableItem(null, 1);
        this.designHandle.getBody().add((DesignElementHandle)table);
        ColumnHandle columnHandle = (ColumnHandle)table.getColumns().get(0);
        columnHandle.getPrivateStyle().setFontWeight("100");
        cell = (CellHandle)((RowHandle)table.getDetail().get(0)).getCells().get(0);
        CellHandleTest.assertEquals((Object)"100", (Object)cell.getProperty("fontWeight"));
    }

    public void testCssProperties() throws Exception {
        this.openDesign(this.fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table1");
        CellHandle cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"bottom", (Object)cell.getProperty("verticalAlign"));
        table = (TableHandle)this.designHandle.findElement("My table2");
        cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertEquals((Object)"bottom", (Object)cell.getProperty("verticalAlign"));
        table = (TableHandle)this.designHandle.findElement("My table3");
        cell = this.getCellInTableSlot(table, 2, 0, 0);
        CellHandleTest.assertNull((Object)cell.getProperty("verticalAlign"));
    }

    public void testGridCellProperty() throws Exception {
        this.openDesign(this.fileName);
        GridHandle grid = (GridHandle)this.designHandle.findElement("My grid1");
        RowHandle row = (RowHandle)grid.getRows().get(0);
        CellHandle cell = (CellHandle)row.getCells().get(0);
        CellHandleTest.assertEquals((Object)"lime", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"lime", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        SlotHandle slotHandle = cell.getContent();
        AutoTextHandle autoTextHandle = (AutoTextHandle)slotHandle.getContents().get(1);
        CellHandleTest.assertEquals((Object)"total-page", (Object)autoTextHandle.getProperty("type"));
        LabelHandle label = (LabelHandle)this.designHandle.findElement("My label1");
        CellHandleTest.assertEquals((Object)"lime", (Object)label.getProperty("color"));
        grid = (GridHandle)this.designHandle.findElement("My grid2");
        row = (RowHandle)grid.getRows().get(0);
        cell = (CellHandle)row.getCells().get(0);
        CellHandleTest.assertEquals((Object)"aqua", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals(null, (Object)cell.getFactoryPropertyHandle("color"));
        label = (LabelHandle)this.designHandle.findElement("My label21");
        CellHandleTest.assertEquals((Object)"aqua", (Object)label.getProperty("color"));
        label = (LabelHandle)this.designHandle.findElement("My label22");
        CellHandleTest.assertEquals((Object)"lime", (Object)label.getProperty("color"));
        grid = (GridHandle)this.designHandle.findElement("My grid4");
        row = (RowHandle)grid.getRows().get(0);
        cell = (CellHandle)row.getCells().get(0);
        CellHandleTest.assertEquals((Object)"red", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"red", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        cell = (CellHandle)row.getCells().get(1);
        CellHandleTest.assertEquals((Object)"black", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals(null, (Object)cell.getFactoryPropertyHandle("color"));
        cell = (CellHandle)row.getCells().get(2);
        CellHandleTest.assertEquals((Object)"lime", (Object)cell.getProperty("color"));
        CellHandleTest.assertEquals((String)"lime", (String)cell.getFactoryPropertyHandle("color").getStringValue());
        label = (LabelHandle)this.designHandle.findElement("My label41");
        CellHandleTest.assertEquals((Object)"red", (Object)label.getProperty("color"));
        label = (LabelHandle)this.designHandle.findElement("My label42");
        CellHandleTest.assertEquals((Object)"lime", (Object)label.getProperty("color"));
        label = (LabelHandle)this.designHandle.findElement("My label52");
        CellHandleTest.assertNull((Object)label.getProperty("backgroundColor"));
    }

    private CellHandle getCellInGroup(TableGroupHandle group, int slotID, int rowIndex, int cellIndex) {
        RowHandle row = (RowHandle)group.getSlot(slotID).get(rowIndex);
        CellHandle cell = (CellHandle)row.getSlot(0).get(cellIndex);
        return cell;
    }

    private CellHandle getCellInTableSlot(TableHandle table, int slotID, int rowIndex, int cellIndex) {
        RowHandle row = (RowHandle)table.getSlot(slotID).get(rowIndex);
        CellHandle cell = (CellHandle)row.getSlot(0).get(cellIndex);
        return cell;
    }

    public void testTextAlign() throws Exception {
        this.openDesign("CellHandleTest_1.xml");
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("table1");
        CellHandleTest.assertNull((Object)tableHandle.getStringProperty("textAlign"));
        CellHandleTest.assertNull((Object)tableHandle.getFactoryPropertyHandle("textAlign"));
        RowHandle rowHandle = (RowHandle)tableHandle.getHeader().get(0);
        CellHandleTest.assertEquals((String)"center", (String)rowHandle.getStringProperty("textAlign"));
        CellHandleTest.assertEquals((String)"center", (String)rowHandle.getFactoryPropertyHandle("textAlign").getStringValue());
        CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(0);
        CellHandleTest.assertEquals((String)"center", (String)cellHandle.getStringProperty("textAlign"));
        CellHandleTest.assertNull((Object)cellHandle.getFactoryPropertyHandle("textAlign"));
        LabelHandle labelHandle = (LabelHandle)cellHandle.getContent().get(0);
        CellHandleTest.assertEquals((String)"center", (String)labelHandle.getStringProperty("textAlign"));
        CellHandleTest.assertNull((Object)labelHandle.getFactoryPropertyHandle("textAlign"));
        rowHandle = (RowHandle)tableHandle.getDetail().get(0);
        CellHandleTest.assertNull((Object)rowHandle.getStringProperty("textAlign"));
        CellHandleTest.assertNull((Object)rowHandle.getFactoryPropertyHandle("textAlign"));
        tableHandle = (TableHandle)this.designHandle.findElement("table2");
        CellHandleTest.assertEquals((String)"right", (String)tableHandle.getStringProperty("textAlign"));
        CellHandleTest.assertEquals((String)"right", (String)tableHandle.getFactoryPropertyHandle("textAlign").getStringValue());
        rowHandle = (RowHandle)tableHandle.getHeader().get(0);
        CellHandleTest.assertEquals((String)"right", (String)rowHandle.getStringProperty("textAlign"));
        CellHandleTest.assertNull((Object)rowHandle.getFactoryPropertyHandle("textAlign"));
    }
}

