/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.tests.engine.BaseEmitter;

public class IColumnTest
extends BaseEmitter {
    private String reportName = "IColumnTest.rptdesign";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.reportName, this.reportName);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource();
    }

    @Override
    protected String getReportName() {
        return this.reportName;
    }

    public void testIColumn() throws EngineException {
        this.runandrender_emitter("html", false);
    }

    @Override
    public void endTable(ITableContent table) {
        IColumn column = table.getColumn(0);
        IStyle inStyle = column.getInlineStyle();
        IColumnTest.assertEquals((String)"pdf", (String)column.getVisibleFormat());
        IColumnTest.assertTrue((boolean)column.hasDataItemsInDetail());
        IColumnTest.assertEquals((long)15L, (long)column.getInstanceID().getComponentID());
        IColumnTest.assertTrue((boolean)(column.getGenerateBy() instanceof ColumnDesign));
        IColumnTest.assertTrue((column.getWidth().getMeasure() == 1.5 ? 1 : 0) != 0);
        IColumnTest.assertEquals((String)"in", (String)column.getWidth().getUnits());
        System.out.println();
    }

    @Override
    public void endCell(ICellContent cell) {
        IColumnTest.assertEquals((String)"rgb(128, 128, 128)", (String)cell.getStyle().getBackgroundColor());
    }
}

