/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import com.ibm.icu.util.ULocale;
import junit.framework.TestCase;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;

public class CellHandleAdapterTest
extends TestCase {
    private SessionHandle sessionHandle;
    private ReportDesignHandle designHandle;

    protected void setUp() throws Exception {
        super.setUp();
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.getDefault());
        this.designHandle = this.sessionHandle.createDesign();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetChildren() {
        CellHandle cell = this.designHandle.getElementFactory().newCell();
        TextItemHandle text = this.designHandle.getElementFactory().newTextItem("abcd");
        try {
            cell.getContent().add((DesignElementHandle)text);
        }
        catch (ContentException | NameException e) {
            CellHandleAdapterTest.fail((String)"error when add text to tabel cell");
            e.printStackTrace();
        }
        CellHandleAdapter adapter = new CellHandleAdapter((ReportElementHandle)cell, null);
        for (Object obj : adapter.getChildren()) {
            CellHandleAdapterTest.assertTrue((boolean)(obj instanceof TextItemHandle));
        }
    }
}

