/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.birt.core.format.NumberFormatter;
import org.junit.Test;

public class NumberFormatterTest
extends TestCase {
    @Test
    public void testNumericFormat() {
        NumberFormatter numFormat = new NumberFormatter();
        NumberFormatterTest.assertNull((Object)numFormat.getPattern());
        NumberFormat number = NumberFormat.getInstance(Locale.getDefault());
        number.setGroupingUsed(false);
        NumberFormatterTest.assertEquals((String)number.format(1002.234), (String)numFormat.format(1002.234));
        NumberFormatterTest.assertEquals((String)"NaN", (String)numFormat.format(Double.NaN));
    }

    @Test
    public void testApplyPattern() {
        NumberFormatter numFormat = new NumberFormatter(ULocale.US);
        DecimalFormat dec = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        numFormat.applyPattern("#");
        NumberFormatterTest.assertEquals((String)numFormat.format(1002.2), (String)"1002");
        numFormat.applyPattern("0");
        NumberFormatterTest.assertEquals((String)numFormat.format(1002.2), (String)"1002");
        numFormat.applyPattern("###,##0");
        NumberFormatterTest.assertEquals((String)numFormat.format(1002.2), (String)"1,002");
        numFormat.applyPattern("#.0#");
        NumberFormatterTest.assertEquals((String)numFormat.format(1002.2), (String)"1002.2");
        numFormat.applyPattern("###,##0.00 'm/s'");
        NumberFormatterTest.assertEquals((String)numFormat.format(1002.2), (String)"1,002.20 m/s");
        numFormat.applyPattern("#.##");
        NumberFormatterTest.assertEquals((String)numFormat.format(1002L), (String)"1002");
        numFormat.applyPattern("###.#';'");
        NumberFormatterTest.assertEquals((String)numFormat.format(1002.2), (String)"1002.2;");
        NumberFormatterTest.assertEquals((String)numFormat.format(-1002.2), (String)"-1002.2;");
        numFormat.applyPattern("###.#';';#");
        NumberFormatterTest.assertEquals((String)numFormat.format(1002.2), (String)"1002.2;");
        NumberFormatterTest.assertEquals((String)numFormat.format(-1002.2), (String)"1002.2");
        dec.applyPattern("#.00%");
        NumberFormatterTest.assertEquals((String)"1002200.00%", (String)dec.format(10022L));
        dec.applyPattern("0.00E00");
        dec.applyPattern("");
        numFormat.applyPattern("General Number");
        NumberFormat number = NumberFormat.getInstance(Locale.US);
        number.setGroupingUsed(false);
        NumberFormatterTest.assertEquals((String)number.format(1002.2), (String)numFormat.format(1002.2));
        NumberFormatterTest.assertEquals((String)number.format(-1002.2), (String)numFormat.format(-1002.2));
        NumberFormatterTest.assertEquals((String)number.format(0.004), (String)numFormat.format(0.004));
        NumberFormatterTest.assertEquals((String)number.format(0.004123456), (String)numFormat.format(0.004123456));
        NumberFormatterTest.assertEquals((String)number.format(-0.004), (String)numFormat.format(-0.004));
        NumberFormatterTest.assertEquals((String)number.format(0L), (String)numFormat.format(0L));
        numFormat.applyPattern("C");
        number = NumberFormat.getCurrencyInstance(Locale.US);
        NumberFormatterTest.assertEquals((String)number.format(1290.8889), (String)numFormat.format(1290.8889));
        numFormat.applyPattern("Fixed");
        NumberFormatterTest.assertEquals((String)"1002.20", (String)numFormat.format(1002.2));
        NumberFormatterTest.assertEquals((String)"-1002.20", (String)numFormat.format(-1002.2));
        NumberFormatterTest.assertEquals((String)"0.00", (String)numFormat.format(0.004));
        NumberFormatterTest.assertEquals((String)"3333333333.33", (String)numFormat.format(3.33333333333E9));
        NumberFormatterTest.assertEquals((String)"0.00", (String)numFormat.format(0L));
        numFormat.applyPattern("Standard");
        NumberFormatterTest.assertEquals((String)"1,002.20", (String)numFormat.format(1002.2));
        NumberFormatterTest.assertEquals((String)"-1,002.20", (String)numFormat.format(-1002.2));
        NumberFormatterTest.assertEquals((String)"0.00", (String)numFormat.format(0.004));
        NumberFormatterTest.assertEquals((String)"0.00", (String)numFormat.format(0.004123456));
        NumberFormatterTest.assertEquals((String)"-0.00", (String)numFormat.format(-0.004));
        NumberFormatterTest.assertEquals((String)"3,333,333,333.33", (String)numFormat.format(3.33333333333E9));
        NumberFormatterTest.assertEquals((String)"0.00", (String)numFormat.format(0L));
        numFormat.applyPattern("Percent");
        NumberFormatterTest.assertEquals((String)"100220.00%", (String)numFormat.format(1002.2));
        NumberFormatterTest.assertEquals((String)"-100220.00%", (String)numFormat.format(-1002.2));
        NumberFormatterTest.assertEquals((String)"0.40%", (String)numFormat.format(0.004));
        NumberFormatterTest.assertEquals((String)"0.41%", (String)numFormat.format(0.004123456));
        NumberFormatterTest.assertEquals((String)"-0.40%", (String)numFormat.format(-0.004));
        NumberFormatterTest.assertEquals((String)"333333333333.00%", (String)numFormat.format(3.33333333333E9));
        NumberFormatterTest.assertEquals((String)"0.00%", (String)numFormat.format(0L));
        numFormat.applyPattern("P");
        NumberFormatterTest.assertEquals((String)"100,220.00 %", (String)numFormat.format(1002.2));
        NumberFormatterTest.assertEquals((String)"-100,220.00 %", (String)numFormat.format(-1002.2));
        NumberFormatterTest.assertEquals((String)"0.40 %", (String)numFormat.format(0.004));
        NumberFormatterTest.assertEquals((String)"0.41 %", (String)numFormat.format(0.004123456));
        NumberFormatterTest.assertEquals((String)"-0.40 %", (String)numFormat.format(-0.004));
        NumberFormatterTest.assertEquals((String)"333,333,333,333.00 %", (String)numFormat.format(3.33333333333E9));
        NumberFormatterTest.assertEquals((String)"0.00 %", (String)numFormat.format(0L));
        numFormat.applyPattern("Scientific");
        NumberFormatterTest.assertEquals((String)"1.00E03", (String)numFormat.format(1002.2));
        NumberFormatterTest.assertEquals((String)"-1.00E03", (String)numFormat.format(-1002.2));
        NumberFormatterTest.assertEquals((String)"4.00E-03", (String)numFormat.format(0.004));
        NumberFormatterTest.assertEquals((String)"4.12E-03", (String)numFormat.format(0.004123456));
        NumberFormatterTest.assertEquals((String)"-4.00E-03", (String)numFormat.format(-0.004));
        NumberFormatterTest.assertEquals((String)"3.33E09", (String)numFormat.format(3.33333333333E9));
        NumberFormatterTest.assertEquals((String)"0.00E00", (String)numFormat.format(0L));
        NumberFormatterTest.assertEquals((String)"1.00E00", (String)numFormat.format(1L));
        numFormat.applyPattern("e");
        NumberFormatterTest.assertEquals((String)"1.002200E03", (String)numFormat.format(1002.2));
        NumberFormatterTest.assertEquals((String)"-1.002200E03", (String)numFormat.format(-1002.2));
        NumberFormatterTest.assertEquals((String)"4.000000E-03", (String)numFormat.format(0.004));
        NumberFormatterTest.assertEquals((String)"4.123456E-03", (String)numFormat.format(0.004123456));
        NumberFormatterTest.assertEquals((String)"-4.000000E-03", (String)numFormat.format(-0.004));
        NumberFormatterTest.assertEquals((String)"3.333333E09", (String)numFormat.format(3.33333333333E9));
        NumberFormatterTest.assertEquals((String)"0.000000E00", (String)numFormat.format(0L));
        NumberFormatterTest.assertEquals((String)"1.000000E00", (String)numFormat.format(1L));
        numFormat.applyPattern("x");
        NumberFormatterTest.assertEquals((String)"3ea", (String)numFormat.format(1002L));
        NumberFormatterTest.assertEquals((String)"fffffffffffffc16", (String)numFormat.format(-1002L));
        NumberFormatterTest.assertEquals((String)"3ea", (String)numFormat.format(1002.22));
        numFormat.applyPattern("d");
        NumberFormatterTest.assertEquals((String)"1,002", (String)numFormat.format(1002L));
        NumberFormatterTest.assertEquals((String)"-1,002", (String)numFormat.format(-1002L));
        NumberFormatterTest.assertEquals((String)"1,002.009", (String)numFormat.format(1002.009));
        numFormat = new NumberFormatter("tttt");
        numFormat.applyPattern("zzz");
    }

    @Test
    public void testGetPattern() {
        NumberFormatter numFormat = new NumberFormatter("$###,##0.00;'Negative'");
        NumberFormatterTest.assertEquals((String)numFormat.getPattern(), (String)"$###,##0.00;'Negative'");
    }

    @Test
    public void testFormatBigDecimal() {
        NumberFormatter numFormat = new NumberFormatter("$###,##0.00;'Negative'", ULocale.US);
        NumberFormatterTest.assertEquals((String)numFormat.format(new BigDecimal(2139.3)), (String)"$2,139.30");
        NumberFormatterTest.assertEquals((String)numFormat.format(new BigDecimal(2.139)), (String)"$2.14");
        NumberFormatterTest.assertEquals((String)numFormat.format(new BigDecimal(-2.13)), (String)"Negative2.13");
        NumberFormatterTest.assertEquals((String)numFormat.format(new BigDecimal(0.0)), (String)"$0.00");
        NumberFormatterTest.assertEquals((String)numFormat.format(new BigDecimal(2000)), (String)"$2,000.00");
        NumberFormatterTest.assertEquals((String)numFormat.format(new BigDecimal(20)), (String)"$20.00");
        NumberFormatterTest.assertEquals((String)numFormat.format(new BigDecimal(-2000)), (String)"Negative2,000.00");
        NumberFormatterTest.assertEquals((String)numFormat.format(new BigDecimal(0)), (String)"$0.00");
        numFormat.applyPattern("d");
        NumberFormatterTest.assertEquals((String)numFormat.format(new BigDecimal(2.139)), (String)"2.139");
    }

    @Test
    public void testMinusZero() {
        NumberFormatter numFormat = new NumberFormatter(ULocale.US);
        double[] smallValues = new double[]{-0.49, -0.049, -0.0049, -4.9E-4, -4.9E-7};
        double[] bigValues = new double[]{-0.51, -0.051, -0.0051, -5.1E-4, -5.1E-7};
        numFormat.applyPattern("#");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[0]), (String)"-0");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[0]), (String)"-1");
        numFormat.applyPattern("0");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[0]), (String)"-0");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[0]), (String)"-1");
        numFormat.applyPattern("###,##0");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[3]), (String)"-0");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[3]), (String)"-0");
        numFormat.applyPattern("#.0#");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[2]), (String)"-.0");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[2]), (String)"-.01");
        numFormat.applyPattern("###,##0.00 'm/s'");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[2]), (String)"-0.00 m/s");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.01 m/s");
        numFormat.applyPattern("#.##");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[2]), (String)"-0");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.01");
        numFormat.applyPattern("###.#';'");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[1]), (String)"-0;");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[1]), (String)"-0.1;");
        numFormat.applyPattern("###.#';';#");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[1]), (String)"0");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[1]), (String)"0.1");
        numFormat.applyPattern("#.00%");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[2]), (String)"-.49%");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[2]), (String)"-.51%");
        numFormat.applyPattern("Fixed");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[2]), (String)"-0.00");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.01");
        numFormat.applyPattern("Standard");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[2]), (String)"-0.00");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.01");
        numFormat.applyPattern("Percent");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[2]), (String)"-0.49%");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.51%");
        numFormat.applyPattern("P");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[2]), (String)"-0.49 %");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.51 %");
        numFormat.applyPattern("Scientific");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[2]), (String)"-4.90E-03");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[2]), (String)"-5.10E-03");
        numFormat.applyPattern("e");
        NumberFormatterTest.assertEquals((String)numFormat.format(smallValues[4]), (String)"-4.900000E-07");
        NumberFormatterTest.assertEquals((String)numFormat.format(bigValues[4]), (String)"-5.100000E-07");
    }

    @Test
    public void testPatternAttributes() {
        String res;
        double value;
        int vindex;
        String pattern;
        ULocale arabic = new ULocale("ar");
        ULocale english = new ULocale("en");
        String[] patterns = new String[]{"General Number", "General Number{DigitSubstitution=true}"};
        double[] values = new double[]{123.12, 902.023};
        String[][] araGoldens = new String[][]{{"123.12", "902.023"}, {"\u0661\u0662\u0663\u066b\u0661\u0662", "\u0669\u0660\u0662\u066b\u0660\u0662\u0663"}};
        String[][] engGoldens = new String[][]{{"123.12", "902.023"}, {"123.12", "902.023"}};
        NumberFormatter nf = null;
        int pindex = 0;
        while (pindex < patterns.length) {
            pattern = patterns[pindex];
            nf = new NumberFormatter(pattern, arabic);
            vindex = 0;
            while (vindex < values.length) {
                value = values[vindex];
                res = nf.format(value);
                try {
                    NumberFormatterTest.assertEquals((String)araGoldens[1][vindex], (String)new String(res.getBytes("UTF-8"), "UTF-8"));
                }
                catch (Exception e1) {
                    NumberFormatterTest.fail((String)e1.toString());
                }
                ++vindex;
            }
            ++pindex;
        }
        pindex = 0;
        while (pindex < patterns.length) {
            pattern = patterns[pindex];
            nf = new NumberFormatter(pattern, english);
            vindex = 0;
            while (vindex < values.length) {
                value = values[vindex];
                res = nf.format(value);
                NumberFormatterTest.assertTrue((boolean)res.equals(engGoldens[pindex][vindex]));
                ++vindex;
            }
            ++pindex;
        }
    }

    @Test
    public void testRoundingMode() {
        String result;
        String pattern = "###0.0{RoundingMode=HALF_EVEN;}";
        double[] values = new double[]{3.0, 3.01, 3.02, 3.03, 3.04, 3.05, 3.06, 3.07, 3.08, 3.09};
        String[] upGoldens = new String[]{"3.0", "3.0", "3.0", "3.0", "3.0", "3.1", "3.1", "3.1", "3.1", "3.1"};
        String[] evenGoldens = new String[]{"3.0", "3.0", "3.0", "3.0", "3.0", "3.0", "3.1", "3.1", "3.1", "3.1"};
        NumberFormatter nf = new NumberFormatter(pattern, ULocale.US);
        int index = 0;
        while (index < values.length) {
            result = nf.format(values[index]);
            NumberFormatterTest.assertTrue((boolean)result.equals(evenGoldens[index]));
            ++index;
        }
        pattern = "###0.0{RoundingMode=HALF_UP;}";
        nf = new NumberFormatter(pattern, ULocale.US);
        index = 0;
        while (index < values.length) {
            result = nf.format(values[index]);
            NumberFormatterTest.assertTrue((boolean)result.equals(upGoldens[index]));
            ++index;
        }
    }
}

