/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class DynamicParameterTest
extends BaseTestCase {
    static final String INPUT_FILE_NAME = "DynamicParameterTest.xml";
    static final String INPUT_FILE_NAME1 = "DynamicParameterTest1.xml";
    static final String OUTPUT_FILE_NAME = "DynamicParameterTest_out.xml";
    static final String GOLDEN_FILE_NAME = "DynamicParameterTest_golden.xml";

    public DynamicParameterTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(DynamicParameterTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/DynamicParameterTest.xml");
        this.copyInputToFile("input/DynamicParameterTest1.xml");
        this.copyGoldenToFile("golden/DynamicParameterTest_golden.xml");
        this.openDesign(INPUT_FILE_NAME);
    }

    public void testPropertiesOfDynamicParameter() throws Exception {
        SlotHandle params = this.designHandle.getParameters();
        ScalarParameterHandle handle = (ScalarParameterHandle)params.get(0);
        SlotHandle dataset = this.designHandle.getDataSets();
        DataSetHandle ds = (DataSetHandle)dataset.get(0);
        DynamicParameterTest.assertEquals((String)"dataset1", (String)ds.getName());
        DynamicParameterTest.assertEquals((String)"dataset2", (String)dataset.get(1).getName());
        DynamicParameterTest.assertEquals((String)"dynamic", (String)handle.getValueType());
        DynamicParameterTest.assertEquals((String)"dateTime", (String)handle.getDataType());
        handle.setPromptText("abc");
        DynamicParameterTest.assertEquals((String)"abc", (String)handle.getPromptText());
        handle.setDataSetName("dataset1");
        handle.setValueExpr("row[\"ORDERDATE\"]");
        DynamicParameterTest.assertEquals((String)"row[\"ORDERDATE\"]", (String)handle.getValueExpr());
        handle.setControlType("list-box");
        DynamicParameterTest.assertEquals((String)"list-box", (String)handle.getControlType());
        handle.setDefaultValue("10/15/2005");
        DynamicParameterTest.assertEquals((String)"10/15/2005", (String)handle.getDefaultValue());
        handle.setCategory("Long Date");
        DynamicParameterTest.assertEquals((String)"Long Date", (String)handle.getCategory());
        handle.setListlimit(20);
        DynamicParameterTest.assertEquals((int)20, (int)handle.getListlimit());
        DynamicParameterTest.assertFalse((boolean)handle.isMustMatch());
        DynamicParameterTest.assertTrue((boolean)handle.isFixedOrder());
        handle = (ScalarParameterHandle)params.get(1);
        DynamicParameterTest.assertEquals((String)"dynamic", (String)handle.getValueType());
        DynamicParameterTest.assertEquals((String)"float", (String)handle.getDataType());
        handle.setDataSetName("dataset2");
        handle.setValueExpr("row[\"Amount\"]");
        DynamicParameterTest.assertEquals((String)"row[\"Amount\"]", (String)handle.getValueExpr());
        DynamicParameterTest.assertEquals((String)"list-box", (String)handle.getControlType());
        DynamicParameterTest.assertFalse((boolean)handle.isHidden());
        DynamicParameterTest.assertEquals((String)"scalar para help", (String)handle.getHelpText());
        DynamicParameterTest.assertFalse((boolean)handle.isConcealValue());
        DynamicParameterTest.assertFalse((boolean)handle.allowBlank());
        DynamicParameterTest.assertTrue((boolean)handle.allowNull());
        DynamicParameterTest.assertEquals((String)"left", (String)handle.getAlignment());
        DynamicParameterTest.assertEquals((String)"##,###.##", (String)handle.getPattern());
        DynamicParameterTest.assertEquals((int)5, (int)handle.getListlimit());
        try {
            this.openDesign(INPUT_FILE_NAME1);
        }
        catch (DesignFileException designFileException) {
            // empty catch block
        }
        String TempFile = this.genOutputFile(OUTPUT_FILE_NAME);
        this.designHandle.saveAs(TempFile);
        DynamicParameterTest.assertTrue((boolean)this.compareTextFile(GOLDEN_FILE_NAME, OUTPUT_FILE_NAME));
    }
}

