/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import testutil.BaseTestCase;

public class MirrorCursorNavigatorTest
extends BaseTestCase {
    private Scriptable scope;
    private DataEngineImpl de;
    private CubeUtility creator;
    private ICube cube;

    @Before
    public void mirrorCursorNavigatorSetUp() throws Exception {
        this.scope = new ImporterTopLevel();
        DataEngineContext context = DataEngineContext.newInstance((int)3, (Scriptable)this.scope, null, null);
        context.setTmpdir(MirrorCursorNavigatorTest.getTempDir());
        this.de = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.creator = new CubeUtility();
        this.creator.createCube(this.de);
        this.cube = this.creator.getCube(CubeUtility.cubeName, this.de);
    }

    @After
    public void mirrorCursorNavigatorTearDown() throws Exception {
        this.cube.close();
        if (this.de != null) {
            this.de.shutdown();
            this.de = null;
        }
    }

    @Test
    public void testNavigator() throws DataException, OLAPException {
        ICubeQueryDefinition cqd = this.creator.createMirroredQueryDefinition("cube", true);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        EdgeCursor rowCursor = cubeView.getRowEdgeView().getEdgeCursor();
        EdgeCursor columnCursor = cubeView.getColumnEdgeView().getEdgeCursor();
        DimensionCursor countryCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(0);
        DimensionCursor cityCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(1);
        DimensionCursor streetCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(2);
        DimensionCursor yearCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(3);
        DimensionCursor productLineCursor = (DimensionCursor)rowCursor.getDimensionCursor().get(0);
        DimensionCursor productNameCursor = (DimensionCursor)rowCursor.getDimensionCursor().get(1);
        columnCursor.beforeFirst();
        Assert.assertTrue((boolean)columnCursor.isBeforeFirst());
        Assert.assertTrue((boolean)countryCursor.isBeforeFirst());
        Assert.assertTrue((boolean)cityCursor.isBeforeFirst());
        Assert.assertTrue((boolean)streetCursor.isBeforeFirst());
        Assert.assertTrue((boolean)yearCursor.isBeforeFirst());
        columnCursor.afterLast();
        Assert.assertTrue((boolean)columnCursor.isAfterLast());
        Assert.assertTrue((boolean)countryCursor.isAfterLast());
        Assert.assertTrue((boolean)cityCursor.isAfterLast());
        Assert.assertTrue((boolean)streetCursor.isAfterLast());
        Assert.assertTrue((boolean)yearCursor.isAfterLast());
        columnCursor.first();
        countryCursor.afterLast();
        cityCursor.afterLast();
        streetCursor.afterLast();
        yearCursor.afterLast();
        Assert.assertTrue((boolean)countryCursor.isAfterLast());
        Assert.assertTrue((boolean)cityCursor.isAfterLast());
        Assert.assertTrue((boolean)streetCursor.isAfterLast());
        Assert.assertTrue((boolean)yearCursor.isAfterLast());
        columnCursor.first();
        columnCursor.next();
        cityCursor.afterLast();
        streetCursor.afterLast();
        yearCursor.afterLast();
        Assert.assertTrue((boolean)countryCursor.isFirst());
        Assert.assertTrue((boolean)cityCursor.isAfterLast());
        Assert.assertTrue((boolean)streetCursor.isAfterLast());
        Assert.assertTrue((boolean)yearCursor.isAfterLast());
        columnCursor.first();
        Assert.assertTrue((boolean)columnCursor.isFirst());
        Assert.assertTrue((boolean)countryCursor.isFirst());
        Assert.assertTrue((boolean)cityCursor.isFirst());
        Assert.assertTrue((boolean)streetCursor.isFirst());
        Assert.assertTrue((boolean)yearCursor.isFirst());
        columnCursor.last();
        Assert.assertTrue((boolean)columnCursor.last());
        Assert.assertTrue((boolean)countryCursor.last());
        Assert.assertTrue((boolean)cityCursor.last());
        Assert.assertTrue((boolean)streetCursor.last());
        Assert.assertTrue((boolean)yearCursor.last());
        columnCursor.setPosition(5L);
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("BJ"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A2"));
        Assert.assertTrue((boolean)yearCursor.getObject("level14").equals("1998"));
        columnCursor.setPosition(85L);
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("JP"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("IL"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A2"));
        Assert.assertTrue((boolean)yearCursor.getObject("level14").equals("1998"));
        columnCursor.setPosition(220L);
        try {
            countryCursor.getObject("level11");
            Assert.fail((String)"should never get here!!");
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        columnCursor.setPosition(225L);
        columnCursor.previous();
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("US"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("NY"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A4"));
        Assert.assertTrue((boolean)yearCursor.getObject("level14").equals("2002"));
        columnCursor.setPosition(86L);
        columnCursor.previous();
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("JP"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("IL"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A2"));
        Assert.assertTrue((boolean)yearCursor.getObject("level14").equals("1998"));
        columnCursor.beforeFirst();
        columnCursor.relative(6);
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("BJ"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A2"));
        Assert.assertTrue((boolean)yearCursor.getObject("level14").equals("1998"));
        columnCursor.beforeFirst();
        columnCursor.next();
        columnCursor.next();
        columnCursor.next();
        columnCursor.setPosition(1L);
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("BJ"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A1"));
        Assert.assertTrue((boolean)yearCursor.getObject("level14").equals("1999"));
        columnCursor.beforeFirst();
        columnCursor.setPosition(80L);
        streetCursor.setPosition(1L);
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("JP"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("IL"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A2"));
        Assert.assertTrue((boolean)yearCursor.getObject("level14").equals("1998"));
        columnCursor.beforeFirst();
        columnCursor.setPosition(80L);
        columnCursor.next();
        countryCursor.next();
        Assert.assertTrue((boolean)countryCursor.getObject("level11").equals("UN"));
        Assert.assertTrue((boolean)cityCursor.getObject("level12").equals("LD"));
        Assert.assertTrue((boolean)streetCursor.getObject("level13").equals("A1"));
        Assert.assertTrue((boolean)yearCursor.getObject("level14").equals("1999"));
        columnCursor.afterLast();
        try {
            streetCursor.getObject("level13");
            Assert.fail((String)"should not get here");
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        columnCursor.beforeFirst();
        columnCursor.next();
        Assert.assertTrue((countryCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((countryCursor.getEdgeEnd() == 79L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeEnd() == 19L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeEnd() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((yearCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((yearCursor.getEdgeEnd() == 0L ? 1 : 0) != 0);
        columnCursor.beforeFirst();
        columnCursor.setPosition(1L);
        Assert.assertTrue((countryCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((countryCursor.getEdgeEnd() == 79L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeEnd() == 19L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeEnd() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((yearCursor.getEdgeStart() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((yearCursor.getEdgeEnd() == 1L ? 1 : 0) != 0);
        columnCursor.setPosition(81L);
        Assert.assertTrue((countryCursor.getEdgeStart() == 80L ? 1 : 0) != 0);
        Assert.assertTrue((countryCursor.getEdgeEnd() == 119L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeStart() == 80L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeEnd() == 99L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeStart() == 80L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeEnd() == 84L ? 1 : 0) != 0);
        Assert.assertTrue((yearCursor.getEdgeStart() == 81L ? 1 : 0) != 0);
        Assert.assertTrue((yearCursor.getEdgeEnd() == 81L ? 1 : 0) != 0);
        columnCursor.setPosition(146L);
        Assert.assertTrue((countryCursor.getEdgeStart() == 120L ? 1 : 0) != 0);
        Assert.assertTrue((countryCursor.getEdgeEnd() == 159L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeStart() == 140L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeEnd() == 159L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeStart() == 145L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeEnd() == 149L ? 1 : 0) != 0);
        Assert.assertTrue((yearCursor.getEdgeStart() == 146L ? 1 : 0) != 0);
        Assert.assertTrue((yearCursor.getEdgeEnd() == 146L ? 1 : 0) != 0);
        columnCursor.beforeFirst();
        columnCursor.setPosition(220L);
        Assert.assertTrue((countryCursor.getEdgeStart() == -1L ? 1 : 0) != 0);
        Assert.assertTrue((countryCursor.getEdgeEnd() == -1L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeStart() == -1L ? 1 : 0) != 0);
        Assert.assertTrue((cityCursor.getEdgeEnd() == -1L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeStart() == -1L ? 1 : 0) != 0);
        Assert.assertTrue((streetCursor.getEdgeEnd() == -1L ? 1 : 0) != 0);
        Assert.assertTrue((yearCursor.getEdgeStart() == -1L ? 1 : 0) != 0);
        Assert.assertTrue((yearCursor.getEdgeEnd() == -1L ? 1 : 0) != 0);
        this.close(dataCursor);
    }

    private void close(CubeCursor dataCursor) throws OLAPException {
        int i = 0;
        while (i < dataCursor.getOrdinateEdge().size()) {
            EdgeCursor edge = (EdgeCursor)dataCursor.getOrdinateEdge().get(i);
            edge.close();
            ++i;
        }
        dataCursor.close();
    }
}

