/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.util;

import junit.framework.TestCase;
import org.eclipse.birt.chart.util.NameSet;

public class NameSetTest
extends TestCase {
    String[] set = new String[]{"Name 1", "Name 2", "Name 3"};
    NameSet nameSet;

    protected void setUp() throws Exception {
        super.setUp();
        this.nameSet = new NameSet("-", "-", this.set);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.nameSet = null;
    }

    public void testGetNames() {
        NameSetTest.assertEquals((Object)this.set, (Object)this.nameSet.getNames());
    }

    public void testGetDisplayNames() {
        String[] a = this.nameSet.getDisplayNames();
        int i = 0;
        while (i < 3) {
            NameSetTest.assertEquals((String)("!-" + this.set[i] + "-!"), (String)a[i]);
            ++i;
        }
    }

    public void testGetNameIndex() {
        NameSetTest.assertEquals((int)0, (int)this.nameSet.getNameIndex("Name 1"));
        NameSetTest.assertEquals((int)2, (int)this.nameSet.getNameIndex("Name 3"));
        NameSetTest.assertEquals((int)-1, (int)this.nameSet.getNameIndex("Not Found"));
    }

    public void testGetSafeNameIndex() {
        NameSetTest.assertEquals((int)0, (int)this.nameSet.getSafeNameIndex("Name 1"));
        NameSetTest.assertEquals((int)2, (int)this.nameSet.getSafeNameIndex("Name 3"));
        NameSetTest.assertEquals((int)0, (int)this.nameSet.getSafeNameIndex("Not Found"));
    }

    public void testGetDisplayNameByName() {
        NameSetTest.assertEquals((String)"!-Name 1-!", (String)this.nameSet.getDisplayNameByName("Name 1"));
        NameSetTest.assertNull((Object)this.nameSet.getDisplayNameByName("Not Found"));
    }

    public void testGetNameByDisplayName() {
        NameSetTest.assertEquals((String)"Name 1", (String)this.nameSet.getNameByDisplayName("!-Name 1-!"));
        NameSetTest.assertNull((Object)this.nameSet.getNameByDisplayName("Not Found"));
    }
}

