/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.model.attribute;

import junit.framework.TestCase;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.impl.PaletteImpl;

public class PaletteTest
extends TestCase {
    private void testColorDefinition(Palette p, int index, int red, int green, int blue) {
        ColorDefinition cd = (ColorDefinition)p.getEntries().get(index);
        PaletteTest.assertEquals((int)red, (int)cd.getRed());
        PaletteTest.assertEquals((int)green, (int)cd.getGreen());
        PaletteTest.assertEquals((int)blue, (int)cd.getBlue());
    }

    public void testShift() {
        Palette p = PaletteImpl.create((int)0, (boolean)true);
        p.shift(0);
        PaletteTest.assertEquals((int)32, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 80, 166, 218);
        this.testColorDefinition(p, 8, 192, 192, 192);
        p.shift(-1);
        PaletteTest.assertEquals((int)32, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 242, 88, 106);
        this.testColorDefinition(p, 8, 255, 255, 128);
        this.testColorDefinition(p, 31, 80, 166, 218);
        p.shift(1);
        PaletteTest.assertEquals((int)32, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 255, 128, 0);
        this.testColorDefinition(p, 8, 128, 128, 0);
        p.shift(-32);
        PaletteTest.assertEquals((int)32, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 80, 166, 218);
        this.testColorDefinition(p, 8, 192, 192, 192);
        p.shift(33);
        PaletteTest.assertEquals((int)32, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 80, 166, 218);
        this.testColorDefinition(p, 8, 192, 192, 192);
    }

    public void testShiftWithSize() {
        Palette p = PaletteImpl.create((int)0, (boolean)true);
        p.shift(0, 32);
        PaletteTest.assertEquals((int)32, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 80, 166, 218);
        this.testColorDefinition(p, 8, 192, 192, 192);
        p.shift(-1, 8);
        PaletteTest.assertEquals((int)8, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 242, 88, 106);
        this.testColorDefinition(p, 7, 80, 166, 218);
        p.shift(-1, 3);
        PaletteTest.assertEquals((int)3, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 242, 88, 106);
        this.testColorDefinition(p, 1, 232, 172, 57);
        this.testColorDefinition(p, 2, 80, 166, 218);
        p.shift(1, 8);
        PaletteTest.assertEquals((int)8, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 128, 128, 0);
        this.testColorDefinition(p, 1, 80, 166, 218);
        p.shift(1, 3);
        PaletteTest.assertEquals((int)3, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 232, 172, 57);
        this.testColorDefinition(p, 1, 80, 166, 218);
        this.testColorDefinition(p, 2, 242, 88, 106);
        p.shift(0, 33);
        PaletteTest.assertEquals((int)32, (int)p.getEntries().size());
        this.testColorDefinition(p, 0, 80, 166, 218);
        this.testColorDefinition(p, 8, 192, 192, 192);
    }
}

