/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.TableBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IReportElementFigure;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ViewportLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class TableFigure
extends FreeformViewport
implements IReportElementFigure {
    private static final String BORDER_TEXT = Messages.getString((String)"TableFigure.BORDER_TEXT");
    private Image img;
    private int alignment;
    private Point position = new Point(-1, -1);
    private int repeat;
    private Insets margin = new Insets();
    private Dimension size = new Dimension();
    private Dimension propertySize = new Dimension();
    private double percentageHeight = 1.0;
    private double percentageWidth = 1.0;
    private int backgroundImageDPI = 0;

    public int getBackgroundImageDPI() {
        return this.backgroundImageDPI;
    }

    public void setBackgroundImageDPI(int backgroundImageDPI) {
        this.backgroundImageDPI = backgroundImageDPI;
    }

    public TableFigure() {
        TableBorder border = new TableBorder();
        border.setIndicatorLabel(BORDER_TEXT);
        border.setIndicatorIcon(ReportPlatformUIImages.getImage("Table"));
        this.setBorder((Border)border);
        this.setLayoutManager((LayoutManager)new TableViewportLayout());
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        this.getContents().invalidate();
        return ((LayeredPane)((LayeredPane)this.getContents()).getLayer((Object)"Printable Layers")).getLayer((Object)"Primary Layer").getMinimumSize(wHint, hHint);
    }

    protected void paintBorder(Graphics graphics) {
    }

    protected void paintFigure(Graphics graphics) {
        int y;
        int x;
        Image image;
        if (this.isOpaque()) {
            if (this.getBorder() instanceof BaseBorder) {
                graphics.fillRectangle(this.getBounds().getCopy().crop(((BaseBorder)this.getBorder()).getBorderInsets()));
            } else {
                graphics.fillRectangle(this.getBounds());
            }
        }
        if ((image = this.getImage()) == null) {
            return;
        }
        Rectangle area = this.getBounds();
        if (this.position != null && this.position.x != -1) {
            x = area.x + this.position.x;
        } else {
            switch (this.alignment & 0x18) {
                case 16: {
                    x = area.x + area.width - this.size.width;
                    break;
                }
                case 8: {
                    x = area.x;
                    break;
                }
                default: {
                    x = (area.width - this.size.width) / 2 + area.x;
                }
            }
        }
        if (this.position != null && this.position.y != -1) {
            y = area.y + this.position.y;
        } else {
            switch (this.alignment & 5) {
                case 1: {
                    y = area.y;
                    break;
                }
                case 4: {
                    y = area.y + area.height - this.size.height;
                    break;
                }
                default: {
                    y = (area.height - this.size.height) / 2 + area.y;
                }
            }
        }
        ArrayList<Point> xyList = this.createImageList(x, y);
        Iterator<Point> iter = xyList.iterator();
        Dimension imageSize = new Rectangle(image.getBounds()).getSize();
        while (iter.hasNext()) {
            Point point = iter.next();
            graphics.drawImage(image, 0, 0, imageSize.width, imageSize.height, point.x, point.y, this.size.width, this.size.height);
        }
        xyList.clear();
    }

    private ArrayList<Point> createImageList(int x, int y) {
        Rectangle area = this.getBounds();
        ArrayList<Point> yList = new ArrayList<Point>();
        if ((this.repeat & 2) == 0) {
            yList.add(new Point(x, y));
        } else {
            int i = 0;
            while (y + this.size.height * i + this.size.height > area.y) {
                yList.add(new Point(x, y + this.size.height * i));
                --i;
            }
            i = 1;
            while (y + this.size.height * i < area.y + area.height) {
                yList.add(new Point(x, y + this.size.height * i));
                ++i;
            }
        }
        ArrayList<Point> xyList = new ArrayList<Point>();
        for (Point point : yList) {
            if ((this.repeat & 1) == 0) {
                xyList.add(point);
                continue;
            }
            int i = 0;
            while (point.x + this.size.width * i + this.size.width > area.x) {
                xyList.add(new Point(point.x + this.size.width * i, point.y));
                --i;
            }
            i = 1;
            while (point.x + this.size.width * i < area.x + area.width) {
                xyList.add(new Point(point.x + this.size.width * i, point.y));
                ++i;
            }
        }
        yList.clear();
        return xyList;
    }

    @Override
    public Image getImage() {
        return this.img;
    }

    @Override
    public void setAlignment(int flag) {
        this.alignment = flag;
    }

    @Override
    public void setPosition(Point point) {
        this.position = point;
    }

    @Override
    public void setRepeat(int flag) {
        this.repeat = flag;
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets newMargin) {
        if (newMargin == null) {
            this.margin = new Insets();
        } else {
            this.margin = new Insets(newMargin);
            if (this.margin.left < 0) {
                this.margin.left = 0;
            }
            if (this.margin.right < 0) {
                this.margin.right = 0;
            }
            if (this.margin.top < 0) {
                this.margin.top = 0;
            }
            if (this.margin.bottom < 0) {
                this.margin.bottom = 0;
            }
        }
    }

    @Override
    public void setImage(Image image) {
        this.setImage(image, 0, 0);
    }

    @Override
    public void setImage(Image image, int backGroundImageHeight, int backGroundImageWidth) {
        this.setImage(image, 0, 0, 1.0, 1.0);
    }

    @Override
    public void setImage(Image image, int backGroundImageHeight, int backGroundImageWidth, double percentageHeight, double percentageWidth) {
        if (this.img == image && this.propertySize.height == backGroundImageHeight && this.propertySize.width == backGroundImageWidth && this.percentageHeight == percentageHeight && this.percentageWidth == percentageWidth) {
            return;
        }
        this.img = image;
        if (this.img != null) {
            this.propertySize.height = backGroundImageHeight;
            this.propertySize.width = backGroundImageWidth;
            this.percentageHeight = percentageHeight;
            this.percentageWidth = percentageWidth;
            if (this.backgroundImageDPI > 0 && backGroundImageHeight <= 0 && backGroundImageWidth > 0) {
                double inch = 1.0;
                inch = (double)image.getBounds().width / (double)this.backgroundImageDPI;
                int originalWidth = (int)MetricUtility.inchToPixel((double)inch);
                double scaleFactor = (double)backGroundImageWidth / (double)originalWidth;
                inch = (double)image.getBounds().height / (double)this.backgroundImageDPI;
                this.size.height = (int)(MetricUtility.inchToPixel((double)inch) * scaleFactor);
                this.size.width = backGroundImageWidth;
            } else if (this.backgroundImageDPI > 0 && backGroundImageWidth <= 0 && backGroundImageHeight > 0) {
                double inch = 1.0;
                inch = (double)image.getBounds().height / (double)this.backgroundImageDPI;
                int originalHeight = (int)MetricUtility.inchToPixel((double)inch);
                double scaleFactor = (double)backGroundImageHeight / (double)originalHeight;
                inch = (double)image.getBounds().width / (double)this.backgroundImageDPI;
                this.size.width = (int)(MetricUtility.inchToPixel((double)inch) * scaleFactor);
                this.size.height = backGroundImageHeight;
            } else if (this.backgroundImageDPI > 0 && backGroundImageHeight <= 0 && backGroundImageWidth <= 0) {
                double inch = (double)image.getBounds().width / (double)this.backgroundImageDPI;
                this.size.width = (int)MetricUtility.inchToPixel((double)inch);
                inch = (double)image.getBounds().height / (double)this.backgroundImageDPI;
                this.size.height = (int)MetricUtility.inchToPixel((double)inch);
            } else if (backGroundImageHeight > 0 && backGroundImageWidth > 0) {
                this.size.height = backGroundImageHeight;
                this.size.width = backGroundImageWidth;
            } else {
                this.size = new Rectangle(image.getBounds()).getSize();
            }
        } else {
            this.size = new Dimension();
        }
        if (percentageHeight != 1.0 && percentageWidth == 1.0 && backGroundImageWidth == 0) {
            percentageWidth = percentageHeight;
        } else if (percentageWidth != 1.0 && percentageHeight == 1.0 && backGroundImageHeight == 0) {
            percentageHeight = percentageWidth;
        }
        this.size.height = (int)((double)this.size.height * percentageHeight);
        this.size.width = (int)((double)this.size.width * percentageWidth);
        this.revalidate();
        this.repaint();
    }

    class TableViewportLayout
    extends ViewportLayout {
        TableViewportLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            TableFigure.this.getContents().invalidateTree();
            return ((FreeformFigure)TableFigure.this.getContents()).getFreeformExtent().getExpanded(TableFigure.this.getInsets()).union(0, 0).getSize();
        }

        protected boolean isSensitiveHorizontally(IFigure parent) {
            return true;
        }

        protected boolean isSensitiveVertically(IFigure parent) {
            return true;
        }

        public void layout(IFigure figure) {
        }
    }
}

