/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.samples.ide.action;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.samples.nls.Messages;
import org.eclipse.birt.report.designer.ui.samplesview.action.IOpenSampleReportAction;
import org.eclipse.birt.report.designer.ui.samplesview.sampleslocator.SampleIncludedSourceEntry;
import org.eclipse.birt.report.designer.ui.samplesview.util.PlaceResources;
import org.eclipse.birt.report.designer.ui.samplesview.view.ReportExamples;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;

public class IDEOpenSampleReportAction
extends Action
implements IOpenSampleReportAction,
Listener {
    private static final String ACTION_TEXT = Messages.getString("SampleReportsView.Action.openSampleReport");
    private static final String SCRIPTING_CATEGORY = "Scripted Data Source";
    private static final String DRILL_TO_DETAILS_CATEGORY = "Drill to Details";
    private ReportExamples composite;
    private IProject reportProject;

    public IDEOpenSampleReportAction() {
        super(ACTION_TEXT);
        this.setToolTipText(Messages.getString("SampleReportsView.Action.openSampleReport.toolTipText.ide"));
        this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"import_enable"));
        this.setDisabledImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"import_edisable"));
        this.setEnabled(false);
    }

    public void setMainComposite(ReportExamples composite) {
        this.composite = composite;
        composite.addSelectedListener((Listener)this);
    }

    public void run() {
        TreeItem item = (TreeItem)this.composite.getSelectedElement();
        final Object selectedElement = item.getData();
        if (selectedElement == null || !(selectedElement instanceof ReportDesignHandle)) {
            return;
        }
        if (item.getParentItem().getText().equals(DRILL_TO_DETAILS_CATEGORY)) {
            this.reportProject = this.createProject(DRILL_TO_DETAILS_CATEGORY, false);
            if (this.reportProject == null) {
                return;
            }
            PlaceResources.copyDrillThroughReport((Shell)this.composite.getShell(), (String)this.reportProject.getLocation().toOSString(), (String)item.getText());
        } else if (item.getParentItem().getText().equals(SCRIPTING_CATEGORY)) {
            this.reportProject = this.createProject(SCRIPTING_CATEGORY, true);
            if (this.reportProject != null) {
                this.createSourceAndOutputFolder(this.reportProject);
                try {
                    this.setClasspath(this.reportProject);
                }
                catch (CoreException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
                Enumeration enumeration = SampleIncludedSourceEntry.getJavaObjects();
                while (enumeration.hasMoreElements()) {
                    URL javaObjectURL = (URL)enumeration.nextElement();
                    String filename = javaObjectURL.getFile();
                    String desFileName = filename.substring(filename.lastIndexOf(47) + 1);
                    PlaceResources.copy((Shell)this.composite.getShell(), (String)this.reportProject.getFolder("src").getLocation().toOSString(), (String)desFileName, (URL)javaObjectURL);
                }
            }
        } else {
            this.reportProject = this.createProject(item.getText().substring(0, item.getText().lastIndexOf(".")), false);
        }
        if (this.reportProject == null) {
            return;
        }
        PlaceResources.copy((Shell)this.composite.getShell(), (String)this.reportProject.getLocation().toOSString(), (String)item.getText(), (String)((ReportDesignHandle)selectedElement).getFileName());
        PlaceResources.copyExcludedRptDesignes((Shell)this.composite.getShell(), (String)this.reportProject.getLocation().toOSString(), (String)((ReportDesignHandle)selectedElement).getFileName(), (boolean)false);
        if (this.reportProject != null) {
            this.refreshReportProject(this.reportProject);
        }
        ISafeRunnable op = new ISafeRunnable(){

            public void run() {
                String fileName = ((ReportDesignHandle)selectedElement).getFileName();
                IDEOpenSampleReportAction.this.doFinish((IContainer)IDEOpenSampleReportAction.this.reportProject, fileName.substring(fileName.lastIndexOf(47) + 1));
            }

            public void handleException(Throwable exception) {
                ExceptionUtil.handle((Throwable)exception);
            }
        };
        SafeRunner.run((ISafeRunnable)op);
    }

    private void doFinish(final IContainer locationPath, final String fileName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    if (page == null || locationPath == null) {
                        throw new IllegalArgumentException();
                    }
                    IDE.openEditor((IWorkbenchPage)page, (IFile)locationPath.getFile((IPath)new Path(fileName)), (boolean)true);
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
        });
    }

    private IProject createProject(String projectName, boolean isJavaProject) {
        ProjectNameDialog projectNameDlg = new ProjectNameDialog(UIUtil.getDefaultShell());
        projectNameDlg.setTitle(Messages.getString("IDEOpenSampleReportAction.ProjectNameDialog.Title.PrjectName"));
        projectNameDlg.setProjectName(projectName);
        if (projectNameDlg.open() == 1) {
            return null;
        }
        projectName = projectNameDlg.getProjectName();
        final IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (projectHandle.exists()) {
            Object[] buttonLabels = new String[]{IDialogConstants.PROCEED_LABEL, Messages.getString("IDEOpenSampleReportAction.MessageDialog.ProjectExists.ButtonText"), IDialogConstants.CANCEL_LABEL};
            MessageDialog messageDlg = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString("IDEOpenSampleReportAction.MessageDialog.ProjectExists.Title"), null, Messages.getFormattedString("IDEOpenSampleReportAction.MessageDialog.ProjectExists.Message", buttonLabels), 2, (String[])buttonLabels, 0);
            messageDlg.open();
            if (messageDlg.getReturnCode() == 0) {
                return projectHandle;
            }
            if (messageDlg.getReturnCode() == 1) {
                try {
                    projectHandle.delete(true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (messageDlg.getReturnCode() == 2) {
                return null;
            }
        }
        final IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectHandle.getName());
        if (isJavaProject) {
            natures = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.birt.report.designer.ui.reportprojectnature"};
            description.setNatureIds(natures);
            this.addJavaBuildSpec(description);
        } else {
            natures = new String[]{"org.eclipse.birt.report.designer.ui.reportprojectnature"};
            description.setNatureIds(natures);
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                IDEOpenSampleReportAction.this.create(description, projectHandle, monitor);
            }
        };
        try {
            new ProgressMonitorDialog(this.composite.getShell()).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            ExceptionUtil.handle((Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.composite.getShell(), (String)Messages.getString("NewReportProjectWizard.errorMessage"), (String)Messages.getFormattedString("NewReportProjectWizard.caseVariantExistsError", new String[]{projectHandle.getName()}));
                } else {
                    ErrorDialog.openError((Shell)this.composite.getShell(), (String)Messages.getString("NewReportProjectWizard.errorMessage"), null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                ExceptionUtil.handle((Throwable)e);
                MessageDialog.openError((Shell)this.composite.getShell(), (String)Messages.getString("NewReportProjectWizard.errorMessage"), (String)Messages.getFormattedString("NewReportProjectWizard.internalError", new Object[]{t.getMessage()}));
            }
            return null;
        }
        return projectHandle;
    }

    private void create(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    private void refreshReportProject(final IProject project) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                project.refreshLocal(2, monitor);
            }
        };
        try {
            new ProgressMonitorDialog(this.composite.getShell()).run(false, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    private void addJavaBuildSpec(IProjectDescription description) {
        ICommand command = description.newCommand();
        command.setBuilderName("org.eclipse.jdt.core.javabuilder");
        description.setBuildSpec(new ICommand[]{command});
    }

    private void createSourceAndOutputFolder(IProject project) {
        IFolder outputFolder;
        IFolder srcFolder = project.getFolder("src");
        if (!srcFolder.exists()) {
            try {
                this.createFolder(srcFolder);
            }
            catch (CoreException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
        if (!(outputFolder = project.getFolder("bin")).exists()) {
            try {
                this.createFolder(outputFolder);
            }
            catch (CoreException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
    }

    private void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                this.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    private void setClasspath(IProject project) throws JavaModelException, CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath path = project.getFullPath().append("bin");
        javaProject.setOutputLocation(path, null);
        IClasspathEntry[] entries = this.getClassPathEntries(project);
        javaProject.setRawClasspath(entries, null);
    }

    private IClasspathEntry[] getClassPathEntries(IProject project) {
        IClasspathEntry[] internalClassPathEntries = this.getInternalClassPathEntries(project);
        IClasspathEntry[] entries = new IClasspathEntry[internalClassPathEntries.length + 1];
        System.arraycopy(internalClassPathEntries, 0, entries, 0, internalClassPathEntries.length);
        entries[entries.length - 1] = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
        return entries;
    }

    protected IClasspathEntry[] getInternalClassPathEntries(IProject project) {
        IClasspathEntry[] entries = new IClasspathEntry[1];
        IPath path = project.getFullPath().append("src");
        entries[0] = JavaCore.newSourceEntry((IPath)path);
        return entries;
    }

    public void handleEvent(Event event) {
        TreeItem item;
        if (event.widget == null || !(event.widget instanceof TreeItem)) {
            this.setEnabled(false);
        }
        if ((item = (TreeItem)event.widget) == null) {
            super.setEnabled(false);
            return;
        }
        Object selectedElement = item.getData();
        if (selectedElement == null) {
            super.setEnabled(false);
        } else {
            super.setEnabled(selectedElement instanceof ReportDesignHandle);
        }
    }

    static class ProjectNameDialog
    extends Dialog {
        Text text;
        String projectName = "";
        String title;

        protected ProjectNameDialog(Shell shell) {
            super(shell);
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setProjectName(String name) {
            this.projectName = name;
        }

        public String getProjectName() {
            return this.projectName;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(this.title);
            Composite parentComposite = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(parentComposite, 0);
            GridData gd = new GridData();
            gd.widthHint = 320;
            composite.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout(2, false);
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setText(Messages.getString("IDEOpenSampleReportAction.ProjectNameDialog.Label.PrjectName"));
            this.text = new Text(composite, 2048);
            this.text.setLayoutData((Object)new GridData(768));
            this.text.setText(this.projectName);
            return parentComposite;
        }

        protected void okPressed() {
            this.projectName = this.text.getText().trim();
            super.okPressed();
        }
    }
}

