/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiApp
extends App {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiApp.class);
    protected Bundle _bundle;
    protected ServiceRegistration _registration;
    protected ContextHandler _contextHandler;
    protected String _pathToResourceBase;
    protected String _contextPath;
    protected Resource _bundleResource;

    private static Path getBundlePath(Bundle bundle) throws Exception {
        String bundleOverrideLocation = (String)bundle.getHeaders().get("Jetty-bundleInstall");
        File bundleLocation = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
        File root = bundleOverrideLocation == null ? bundleLocation : new File(bundleOverrideLocation);
        return Paths.get(root.toURI());
    }

    private static Resource getBundleAsResource(Bundle bundle) throws Exception {
        String bundleOverrideLocation = (String)bundle.getHeaders().get("Jetty-bundleInstall");
        File bundleLocation = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
        File root = bundleOverrideLocation == null ? bundleLocation : new File(bundleOverrideLocation);
        URL url = BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(root.toURI().toURL());
        return ResourceFactory.root().newResource(url);
    }

    private static String getContextPath(Bundle bundle) {
        String location;
        String[] toks;
        int lastDot;
        Dictionary headers = bundle.getHeaders();
        Object contextPath = (String)headers.get("Web-ContextPath");
        if (contextPath == null && (lastDot = ((String)(contextPath = (toks = StringUtil.replace((String)(location = bundle.getLocation()), (char)'\\', (char)'/').split("/"))[toks.length - 1])).lastIndexOf(46)) != -1) {
            contextPath = ((String)contextPath).substring(0, lastDot);
        }
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        return contextPath;
    }

    public OSGiApp(DeploymentManager manager, AppProvider provider, Bundle bundle) throws Exception {
        super(manager, provider, OSGiApp.getBundlePath(bundle));
        this._bundle = Objects.requireNonNull(bundle);
        this._bundleResource = OSGiApp.getBundleAsResource(bundle);
        Dictionary headers = bundle.getHeaders();
        Enumeration keys = headers.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = (String)headers.get(key);
            if ("environment".equalsIgnoreCase(key) || "Jetty-Environment".equalsIgnoreCase(key)) {
                this.getProperties().put("environment", val);
                continue;
            }
            if ("jetty.deploy.defaultsDescriptor".equalsIgnoreCase(key) || "Jetty-defaultWebXmlFilePath".equalsIgnoreCase(key)) {
                this.getProperties().put("jetty.deploy.defaultsDescriptor", val);
                continue;
            }
            if ("Jetty-WebXmlFilePath".equalsIgnoreCase(key)) {
                this.getProperties().put(key, val);
                continue;
            }
            if (!"Jetty-ContextFilePath".equalsIgnoreCase(key)) continue;
            this.getProperties().put(key, val);
        }
        this.setContextPath(OSGiApp.getContextPath(bundle));
    }

    public Resource getBundleResource() {
        return this._bundleResource;
    }

    public ContextHandler getContextHandler() throws Exception {
        if (this._contextHandler == null) {
            this._contextHandler = this.getAppProvider().createContextHandler((App)this);
        }
        return this._contextHandler;
    }

    public void setContextHandler(ContextHandler contextHandler) {
        this._contextHandler = contextHandler;
    }

    public String getPathToResourceBase() {
        return this._pathToResourceBase;
    }

    public void setPathToResourceBase(String path) {
        this._pathToResourceBase = path;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public String getBundleSymbolicName() {
        return this._bundle.getSymbolicName();
    }

    public String getBundleVersionAsString() {
        if (this._bundle.getVersion() == null) {
            return null;
        }
        return this._bundle.getVersion().toString();
    }

    public Bundle getBundle() {
        return this._bundle;
    }

    public void setRegistration(ServiceRegistration registration) {
        this._registration = registration;
    }

    public ServiceRegistration getRegistration() {
        return this._registration;
    }

    public void registerAsOSGiService() throws Exception {
        if (this._registration == null) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("o.e.j.o.b.watermark", "o.e.j.o.b.watermark");
            if (this.getBundleSymbolicName() != null) {
                ((Dictionary)properties).put("osgi.web.symbolicname", this.getBundleSymbolicName());
            }
            if (this.getBundleVersionAsString() != null) {
                ((Dictionary)properties).put("osgi.web.version", this.getBundleVersionAsString());
            }
            ((Dictionary)properties).put("osgi.web.contextpath", this.getContextPath());
            ServiceRegistration rego = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext().registerService(ContextHandler.class.getName(), (Object)this.getContextHandler(), properties);
            this.setRegistration(rego);
        }
    }

    protected void deregisterAsOSGiService() throws Exception {
        if (this._registration == null) {
            return;
        }
        this._registration.unregister();
        this._registration = null;
    }
}

