/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.presentation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorUIUtil {
    public static final Generator.CleanupScheduler CLEANUP_SCHEDULER;

    static {
        CleanupSchedulerImpl cleanupScheduler = null;
        try {
            cleanupScheduler = new CleanupSchedulerImpl();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CLEANUP_SCHEDULER = cleanupScheduler;
    }

    private GeneratorUIUtil() {
    }

    public static List<GenModel> loadGenModels(IProgressMonitor progressMonitor, List<URI> uris, Shell shell) {
        if (!uris.isEmpty()) {
            progressMonitor.beginTask(GenModelEditPlugin.INSTANCE.getString("_UI_LoadingGenModel_message"), uris.size());
            ArrayList<GenModel> genModels = new ArrayList<GenModel>(uris.size());
            LinkedHashMap<String, Diagnostic> fileNameToErrorDiagnosticMap = new LinkedHashMap<String, Diagnostic>();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            for (URI uri : uris) {
                EObject eObject;
                progressMonitor.subTask(uri.toPlatformString(true));
                Resource resource = resourceSet.getResource(uri, true);
                if (resource != null && resource.getContents().size() == 1 && (eObject = (EObject)resource.getContents().get(0)) instanceof GenModel) {
                    GenModel genModel = (GenModel)eObject;
                    genModel.reconcile();
                    genModel.setCanGenerate(true);
                    genModel.setValidateModel(true);
                    Diagnostic diagnostic = genModel.diagnose();
                    if (diagnostic.getSeverity() != 4) {
                        genModels.add((GenModel)eObject);
                    } else {
                        fileNameToErrorDiagnosticMap.put(uri.lastSegment(), diagnostic);
                    }
                }
                progressMonitor.worked(1);
            }
            if (shell != null && !fileNameToErrorDiagnosticMap.isEmpty()) {
                String message;
                String reason = GenModelEditPlugin.INSTANCE.getString("_UI_InvalidGenModel_message");
                StringBuilder sb = new StringBuilder();
                BasicDiagnostic diagnosticChain = new BasicDiagnostic("", 4, reason, null);
                for (Map.Entry entry : fileNameToErrorDiagnosticMap.entrySet()) {
                    sb.append(", '").append((String)entry.getKey()).append("'");
                    diagnosticChain.add((Diagnostic)entry.getValue());
                }
                String title = GenModelEditPlugin.INSTANCE.getString("_UI_Error_title");
                String string = message = genModels.isEmpty() ? GenModelEditPlugin.INSTANCE.getString("_UI_SelectGenModelInvalid_message") : GenModelEditPlugin.INSTANCE.getString("_UI_SomeSelectGenModelInvalid_message", new Object[]{sb.delete(0, ", ".length()).toString()});
                if (DiagnosticDialog.open((Shell)shell, (String)title, (String)message, (Diagnostic)diagnosticChain) != 0) {
                    genModels.clear();
                }
            }
            return genModels;
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CleanupSchedulerImpl
    implements Generator.CleanupScheduler {
        private final Set<ICompilationUnit> compilationUnits = new LinkedHashSet<ICompilationUnit>();
        private final Class<?> javaPluginClass = CommonPlugin.loadClass((String)"org.eclipse.jdt.ui", (String)"org.eclipse.jdt.internal.ui.JavaPlugin");
        private final Method getDefaultMethod = this.javaPluginClass.getMethod("getDefault", new Class[0]);
        private final Object javaPlugin = this.getDefaultMethod.invoke(null, new Object[0]);
        private final Method getCleanUpRegistryMethod = this.javaPluginClass.getMethod("getCleanUpRegistry", new Class[0]);
        private final Method createCleanUpsMethod = this.getCleanUpRegistryMethod.getReturnType().getMethod("createCleanUps", new Class[0]);
        private final Class<?> cleanUpRefactoringClass = CommonPlugin.loadClass((String)"org.eclipse.jdt.ui", (String)"org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring");
        private final Constructor<?> cleanupRefactoringConstructor = this.cleanUpRefactoringClass.getConstructor(String.class);
        private final Method setUseOptionsFromProfileMethod = this.cleanUpRefactoringClass.getMethod("setUseOptionsFromProfile", Boolean.TYPE);
        private final Class<?> iCleanUpClass = CommonPlugin.loadClass((String)"org.eclipse.jdt.ui", (String)"org.eclipse.jdt.ui.cleanup.ICleanUp");
        private final Method addCleanUpMethod = this.cleanUpRefactoringClass.getMethod("addCleanUp", this.iCleanUpClass);
        private final Class<?> refactoringClass = CommonPlugin.loadClass((String)"org.eclipse.jdt.ui", (String)"org.eclipse.ltk.core.refactoring.Refactoring");
        private final Class<?> refactoringExecutionHelperClass = CommonPlugin.loadClass((String)"org.eclipse.jdt.ui", (String)"org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper");
        private final Constructor<?> refactoringExecutionHelperConstructor = this.refactoringExecutionHelperClass.getConstructor(this.refactoringClass, Integer.TYPE, Integer.TYPE, Shell.class, IRunnableContext.class);
        private final Method performMethod = this.refactoringExecutionHelperClass.getMethod("perform", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        private Job job;

        public synchronized Job getJob() {
            if (this.job == null) {
                this.job = new UIJob(Display.getDefault(), "Cleanup Generated Java"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            Job[] autoBuildJobs = 1.getJobManager().find(ResourcesPlugin.FAMILY_AUTO_BUILD);
                            if (autoBuildJobs.length != 0) {
                                this.schedule(1000L);
                                return Status.OK_STATUS;
                            }
                            Set<ICompilationUnit> compilationUnits = CleanupSchedulerImpl.this.getScheduledCompilationUnits();
                            ICompilationUnit[] units = compilationUnits.toArray(new ICompilationUnit[compilationUnits.size()]);
                            Object cleanUpRegistry = CleanupSchedulerImpl.this.getCleanUpRegistryMethod.invoke(CleanupSchedulerImpl.this.javaPlugin, new Object[0]);
                            Object[] cleanups = (Object[])CleanupSchedulerImpl.this.createCleanUpsMethod.invoke(cleanUpRegistry, new Object[0]);
                            Object cleanUpRefactoring = CleanupSchedulerImpl.this.cleanupRefactoringConstructor.newInstance("Clean Generated Java");
                            Method addCompilationUnitMethod = CleanupSchedulerImpl.this.cleanUpRefactoringClass.getMethod("addCompilationUnit", ICompilationUnit.class);
                            Object[] objectArray = units;
                            int n = units.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ICompilationUnit unit = objectArray[n2];
                                addCompilationUnitMethod.invoke(cleanUpRefactoring, unit);
                                ++n2;
                            }
                            CleanupSchedulerImpl.this.setUseOptionsFromProfileMethod.invoke(cleanUpRefactoring, Boolean.TRUE);
                            objectArray = cleanups;
                            n = cleanups.length;
                            n2 = 0;
                            while (n2 < n) {
                                ICompilationUnit cleanup = objectArray[n2];
                                CleanupSchedulerImpl.this.addCleanUpMethod.invoke(cleanUpRefactoring, cleanup);
                                ++n2;
                            }
                            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            Object refactoringExecutionHelper = CleanupSchedulerImpl.this.refactoringExecutionHelperConstructor.newInstance(cleanUpRefactoring, 1, 4, activeWorkbenchWindow.getShell(), activeWorkbenchWindow);
                            CleanupSchedulerImpl.this.performMethod.invoke(refactoringExecutionHelper, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof OperationCanceledException) {
                                return Status.CANCEL_STATUS;
                            }
                            return new Status(4, "org.eclipse.emf.codegen.ecore", "Refactoring failure", (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.job.setRule((ISchedulingRule)EcorePlugin.getWorkspaceRoot());
                this.job.schedule(1000L);
            }
            return this.job;
        }

        public synchronized Set<ICompilationUnit> getScheduledCompilationUnits() {
            this.job = null;
            LinkedHashSet<ICompilationUnit> result = new LinkedHashSet<ICompilationUnit>(this.compilationUnits);
            this.compilationUnits.clear();
            return result;
        }

        public synchronized void schedule(Set<ICompilationUnit> compilationUnits) {
            if (!compilationUnits.isEmpty()) {
                this.compilationUnits.addAll(compilationUnits);
                this.getJob();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GeneratorOperation
    extends WorkspaceModifyOperation {
        protected Shell shell;
        protected List<Object[]> generatorAndArgumentsList;
        protected String rootDiagnosticMessage = GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorOperationDiagnostic_message");

        public GeneratorOperation(Shell shell) {
            this.shell = shell;
        }

        public GeneratorOperation(Shell shell, List<Object[]> generatorAndArgumentsList) {
            this(shell);
            this.generatorAndArgumentsList = generatorAndArgumentsList;
        }

        public void setRootDiagnosticMessage(String rootDiagnosticMessage) {
            this.rootDiagnosticMessage = rootDiagnosticMessage;
        }

        public String getRootDiagnosticMessage() {
            return this.rootDiagnosticMessage;
        }

        public void addGeneratorAndArguments(Generator generator, Object object, Object projectType, String projectTypeName) {
            if (this.generatorAndArgumentsList == null) {
                this.generatorAndArgumentsList = new ArrayList<Object[]>();
            }
            this.generatorAndArgumentsList.add(new Object[]{generator, object, projectType, projectTypeName});
        }

        protected void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
            BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.codegen.ecore.ui", 0, this.getRootDiagnosticMessage(), null);
            progressMonitor.beginTask("", this.generatorAndArgumentsList.size());
            try {
                for (Object[] generatorAndArguments : this.generatorAndArgumentsList) {
                    Generator generator = (Generator)generatorAndArguments[0];
                    diagnostic.add(generator.generate(generatorAndArguments[1], generatorAndArguments[2], (String)generatorAndArguments[3], BasicMonitor.toMonitor((IProgressMonitorWithBlocking)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1))));
                    if (!this.canContinue((Diagnostic)diagnostic)) break;
                }
                if (this.shell != null && diagnostic.getSeverity() != 0) {
                    BasicDiagnostic finalDiagnostic = diagnostic;
                    this.shell.getDisplay().asyncExec(new Runnable((Diagnostic)finalDiagnostic){
                        private final /* synthetic */ Diagnostic val$finalDiagnostic;
                        {
                            this.val$finalDiagnostic = diagnostic;
                        }

                        public void run() {
                            DiagnosticDialog.openProblem((Shell)GeneratorOperation.this.shell, (String)GenModelEditPlugin.INSTANCE.getString("_UI_GenerationProblems_title"), (String)GenModelEditPlugin.INSTANCE.getString("_UI_GenerationProblems_message"), (Diagnostic)this.val$finalDiagnostic);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                GenModelEditPlugin.INSTANCE.log(throwable);
            }
            progressMonitor.done();
        }

        protected boolean canContinue(Diagnostic diagnostic) {
            return diagnostic.getSeverity() != 8;
        }
    }
}

