/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;

public class LineRenderEvent
extends PrimitiveRenderEvent {
    private static final long serialVersionUID = 7216549683820618553L;
    private transient Location loStart;
    private transient Location loEnd;
    private int zOrder;
    protected transient LineAttributes lia;

    public LineRenderEvent(Object oSource) {
        super(oSource);
    }

    public final void setStart(Location _loStart) {
        this.loStart = _loStart;
    }

    public final Location getStart() {
        return this.loStart;
    }

    public final void setEnd(Location _loEnd) {
        this.loEnd = _loEnd;
    }

    public final Location getEnd() {
        return this.loEnd;
    }

    public final void setLineAttributes(LineAttributes _lia) {
        this.lia = _lia;
    }

    @Override
    public final LineAttributes getLineAttributes() {
        return this.lia;
    }

    @Override
    public final Bounds getBounds() {
        double dMinX = Math.min(this.loStart.getX(), this.loEnd.getX());
        double dMaxX = Math.max(this.loStart.getX(), this.loEnd.getX());
        double dMinY = Math.min(this.loStart.getY(), this.loEnd.getY());
        double dMaxY = Math.max(this.loStart.getY(), this.loEnd.getY());
        return goFactory.createBounds(dMinX, dMinY, dMaxX - dMinX, dMaxY - dMinY);
    }

    @Override
    public PrimitiveRenderEvent copy() {
        LineRenderEvent lre = new LineRenderEvent(this.source);
        lre.setLineAttributes(goFactory.copyOf(this.lia));
        if (this.loStart != null) {
            lre.setStart(this.loStart.copyInstance());
        }
        if (this.loEnd != null) {
            lre.setEnd(this.loEnd.copyInstance());
        }
        lre.setZOrder(this.zOrder);
        return lre;
    }

    @Override
    public void fill(IDeviceRenderer idr) throws ChartException {
        this.draw(idr);
    }

    @Override
    public final void draw(IDeviceRenderer idr) throws ChartException {
        idr.drawLine(this);
    }

    @Override
    public void reset() {
        this.loEnd = null;
        this.loStart = null;
        this.lia = null;
        this.zOrder = 0;
    }

    public final void setZOrder(int _zOrder) {
        this.zOrder = _zOrder;
    }

    public final int getZOrder() {
        return this.zOrder;
    }
}

