/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.context;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.command.internal.env.core.context.Context;

public abstract class PersistentContext
implements Context {
    protected Preferences preferences_;
    protected Plugin plugin_;

    public PersistentContext(Plugin plugin) {
        this.plugin_ = plugin;
        this.preferences_ = plugin.getPluginPreferences();
    }

    public void setDefault(String name, boolean value) {
        this.preferences_.setDefault(name, value);
    }

    public void setDefault(String name, String value) {
        this.preferences_.setDefault(name, value);
    }

    public void setDefault(String name, int value) {
        this.preferences_.setDefault(name, value);
    }

    public void setValue(String name, String value) {
        this.preferences_.setValue(name, value);
        this.plugin_.savePluginPreferences();
    }

    public void setValue(String name, boolean value) {
        this.preferences_.setValue(name, value);
        this.plugin_.savePluginPreferences();
    }

    public void setValue(String name, int value) {
        this.preferences_.setValue(name, value);
        this.plugin_.savePluginPreferences();
    }

    public String getValueAsString(String name) {
        return this.preferences_.getString(name);
    }

    public boolean getValueAsBoolean(String name) {
        return this.preferences_.getBoolean(name);
    }

    public int getValueAsInt(String name) {
        return this.preferences_.getInt(name);
    }

    public String getDefaultString(String name) {
        return this.preferences_.getDefaultString(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.preferences_.getDefaultBoolean(name);
    }

    public int getDefaultInt(String name) {
        return this.preferences_.getDefaultInt(name);
    }

    public void setDefaultStringIfNoDefault(String key, String value) {
        if (this.preferences_.getDefaultString(key).equals("")) {
            this.preferences_.setDefault(key, value);
        }
    }

    public void setDefaultBooleanIfNoDefault(String key, boolean value) {
        if (this.preferences_.getDefaultString(key).equals("")) {
            this.preferences_.setDefault(key, value);
        }
    }

    public void setDefaultIntIfNoDefault(String key, int value) {
        if (this.preferences_.getDefaultString(key).equals("")) {
            this.preferences_.setDefault(key, value);
        }
    }
}

