/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.smap;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.xtext.common.types.ui.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;

public class XbaseBreakpointUtil {
    private static final Logger logger = Logger.getLogger(XbaseBreakpointUtil.class);
    @Inject
    private ITraceForTypeRootProvider traceForTypeRootProvider;

    protected IResource getBreakpointResource(IMember member) {
        IResource res;
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu != null && cu.isWorkingCopy()) {
            member = (IMember)member.getPrimaryElement();
        }
        if ((res = member.getResource()) == null) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        } else if (!res.getProject().exists()) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        }
        return res;
    }

    public IResource getBreakpointResource(IEditorInput input) throws CoreException {
        IResource resource = (IResource)Adapters.adapt((Object)input, IResource.class);
        if (resource != null) {
            return resource;
        }
        if (input instanceof IStorageEditorInput) {
            IResource underlyingResource;
            IStorage storage = ((IStorageEditorInput)input).getStorage();
            if (storage instanceof IResource) {
                return (IResource)storage;
            }
            if (storage instanceof IJarEntryResource && (underlyingResource = ((IJarEntryResource)storage).getPackageFragmentRoot().getUnderlyingResource()) != null) {
                return underlyingResource;
            }
        } else {
            IClassFile classFile = (IClassFile)Adapters.adapt((Object)input, IClassFile.class);
            if (classFile != null) {
                return this.getBreakpointResource((IMember)classFile.findPrimaryType());
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public SourceRelativeURI getBreakpointURI(IEditorInput input) {
        block12: {
            IResource resource = (IResource)Adapters.adapt((Object)input, IResource.class);
            if (resource != null) {
                return null;
            }
            if (input instanceof IStorageEditorInput) {
                IJarEntryResource jarEntryResource;
                IStorage storage;
                block13: {
                    block11: {
                        try {
                            storage = ((IStorageEditorInput)input).getStorage();
                            if (!(storage instanceof IResource)) break block11;
                            return null;
                        }
                        catch (CoreException e) {
                            logger.error((Object)"Error finding breakpoint URI", (Throwable)e);
                            return null;
                        }
                    }
                    if (!(storage instanceof IJarEntryResource)) break block12;
                    jarEntryResource = (IJarEntryResource)storage;
                    if (jarEntryResource.getPackageFragmentRoot().isArchive()) break block13;
                    return null;
                }
                Object parent = jarEntryResource.getParent();
                if (parent instanceof IPackageFragment) {
                    String path = ((IPackageFragment)parent).getElementName().replace('.', '/');
                    return new SourceRelativeURI(path + "/" + storage.getName());
                }
                if (parent instanceof IPackageFragmentRoot) {
                    return new SourceRelativeURI(storage.getName());
                }
                break block12;
            }
            IClassFile classFile = (IClassFile)Adapters.adapt((Object)input, IClassFile.class);
            if (classFile != null) {
                IEclipseTrace traceToSource = this.traceForTypeRootProvider.getTraceToSource((ITypeRoot)classFile);
                if (traceToSource == null) {
                    return null;
                }
                Iterator iterator = traceToSource.getAllAssociatedLocations().iterator();
                if (iterator.hasNext()) {
                    ILocationInResource loc = (ILocationInResource)iterator.next();
                    return loc.getSrcRelativeResourceURI();
                }
                return null;
            }
        }
        return null;
    }
}

