/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataLayer;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ToggleFilterRowCommand;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;

public class FilterRowHeaderComposite<T>
extends CompositeLayer {
    private final FilterRowDataLayer<T> filterRowDataLayer;
    private boolean filterRowVisible = true;

    public FilterRowHeaderComposite(IFilterStrategy<T> filterStrategy, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry) {
        this(columnHeaderLayer, new FilterRowDataLayer<T>(filterStrategy, columnHeaderLayer, columnHeaderDataProvider, configRegistry));
    }

    public FilterRowHeaderComposite(ILayer columnHeaderLayer, FilterRowDataLayer<T> filterRowDataLayer) {
        super(1, 2);
        this.filterRowDataLayer = filterRowDataLayer;
        this.setChildLayer("columnHeader", columnHeaderLayer, 0, 0);
        this.setChildLayer("FILTER_ROW", this.filterRowDataLayer, 0, 1);
    }

    public FilterRowDataLayer<T> getFilterRowDataLayer() {
        return this.filterRowDataLayer;
    }

    @Override
    public int getHeight() {
        if (this.filterRowVisible) {
            return super.getHeight();
        }
        return this.getHeightOffset(1);
    }

    @Override
    public int getRowCount() {
        if (this.filterRowVisible) {
            return super.getRowCount();
        }
        return super.getRowCount() - 1;
    }

    public boolean isFilterRowVisible() {
        return this.filterRowVisible;
    }

    public void setFilterRowVisible(boolean filterRowVisible) {
        this.filterRowVisible = filterRowVisible;
        this.fireLayerEvent(new RowStructuralRefreshEvent(this.filterRowDataLayer));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ToggleFilterRowCommand) {
            this.setFilterRowVisible(!this.filterRowVisible);
            return true;
        }
        return super.doCommand(command);
    }
}

