/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerOnNetwork;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class FindServersOnNetworkResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12191");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12209");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12197");
    private final ResponseHeader responseHeader;
    private final DateTime lastCounterResetTime;
    private final ServerOnNetwork[] servers;

    public FindServersOnNetworkResponse(ResponseHeader responseHeader, DateTime lastCounterResetTime, ServerOnNetwork[] servers) {
        this.responseHeader = responseHeader;
        this.lastCounterResetTime = lastCounterResetTime;
        this.servers = servers;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public DateTime getLastCounterResetTime() {
        return this.lastCounterResetTime;
    }

    public ServerOnNetwork[] getServers() {
        return this.servers;
    }

    protected FindServersOnNetworkResponse(FindServersOnNetworkResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((FindServersOnNetworkResponseBuilder)b).responseHeader;
        this.lastCounterResetTime = ((FindServersOnNetworkResponseBuilder)b).lastCounterResetTime;
        this.servers = ((FindServersOnNetworkResponseBuilder)b).servers;
    }

    public static FindServersOnNetworkResponseBuilder<?, ?> builder() {
        return new FindServersOnNetworkResponseBuilderImpl();
    }

    public FindServersOnNetworkResponseBuilder<?, ?> toBuilder() {
        return new FindServersOnNetworkResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindServersOnNetworkResponse)) {
            return false;
        }
        FindServersOnNetworkResponse other = (FindServersOnNetworkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        DateTime this$lastCounterResetTime = this.getLastCounterResetTime();
        DateTime other$lastCounterResetTime = other.getLastCounterResetTime();
        if (this$lastCounterResetTime == null ? other$lastCounterResetTime != null : !((Object)this$lastCounterResetTime).equals(other$lastCounterResetTime)) {
            return false;
        }
        return Arrays.deepEquals(this.getServers(), other.getServers());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindServersOnNetworkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        DateTime $lastCounterResetTime = this.getLastCounterResetTime();
        result = result * 59 + ($lastCounterResetTime == null ? 43 : ((Object)$lastCounterResetTime).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServers());
        return result;
    }

    @Override
    public String toString() {
        return "FindServersOnNetworkResponse(responseHeader=" + this.getResponseHeader() + ", lastCounterResetTime=" + this.getLastCounterResetTime() + ", servers=" + Arrays.deepToString(this.getServers()) + ")";
    }

    private static final class FindServersOnNetworkResponseBuilderImpl
    extends FindServersOnNetworkResponseBuilder<FindServersOnNetworkResponse, FindServersOnNetworkResponseBuilderImpl> {
        private FindServersOnNetworkResponseBuilderImpl() {
        }

        @Override
        protected FindServersOnNetworkResponseBuilderImpl self() {
            return this;
        }

        @Override
        public FindServersOnNetworkResponse build() {
            return new FindServersOnNetworkResponse(this);
        }
    }

    public static abstract class FindServersOnNetworkResponseBuilder<C extends FindServersOnNetworkResponse, B extends FindServersOnNetworkResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private DateTime lastCounterResetTime;
        private ServerOnNetwork[] servers;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FindServersOnNetworkResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(FindServersOnNetworkResponse instance, FindServersOnNetworkResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.lastCounterResetTime(instance.lastCounterResetTime);
            b.servers(instance.servers);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B lastCounterResetTime(DateTime lastCounterResetTime) {
            this.lastCounterResetTime = lastCounterResetTime;
            return (B)this.self();
        }

        public B servers(ServerOnNetwork[] servers) {
            this.servers = servers;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FindServersOnNetworkResponse.FindServersOnNetworkResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", lastCounterResetTime=" + this.lastCounterResetTime + ", servers=" + Arrays.deepToString(this.servers) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<FindServersOnNetworkResponse> {
        @Override
        public Class<FindServersOnNetworkResponse> getType() {
            return FindServersOnNetworkResponse.class;
        }

        @Override
        public FindServersOnNetworkResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            DateTime lastCounterResetTime = decoder.readDateTime("LastCounterResetTime");
            ServerOnNetwork[] servers = (ServerOnNetwork[])decoder.readStructArray("Servers", ServerOnNetwork.TYPE_ID);
            return new FindServersOnNetworkResponse(responseHeader, lastCounterResetTime, servers);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, FindServersOnNetworkResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeDateTime("LastCounterResetTime", value.getLastCounterResetTime());
            encoder.writeStructArray("Servers", (Object[])value.getServers(), ServerOnNetwork.TYPE_ID);
        }
    }
}

