/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ActivateSessionResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=468");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=470");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=469");
    private final ResponseHeader responseHeader;
    private final ByteString serverNonce;
    private final StatusCode[] results;
    private final DiagnosticInfo[] diagnosticInfos;

    public ActivateSessionResponse(ResponseHeader responseHeader, ByteString serverNonce, StatusCode[] results, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.serverNonce = serverNonce;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public ByteString getServerNonce() {
        return this.serverNonce;
    }

    public StatusCode[] getResults() {
        return this.results;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    protected ActivateSessionResponse(ActivateSessionResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((ActivateSessionResponseBuilder)b).responseHeader;
        this.serverNonce = ((ActivateSessionResponseBuilder)b).serverNonce;
        this.results = ((ActivateSessionResponseBuilder)b).results;
        this.diagnosticInfos = ((ActivateSessionResponseBuilder)b).diagnosticInfos;
    }

    public static ActivateSessionResponseBuilder<?, ?> builder() {
        return new ActivateSessionResponseBuilderImpl();
    }

    public ActivateSessionResponseBuilder<?, ?> toBuilder() {
        return new ActivateSessionResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivateSessionResponse)) {
            return false;
        }
        ActivateSessionResponse other = (ActivateSessionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        ByteString this$serverNonce = this.getServerNonce();
        ByteString other$serverNonce = other.getServerNonce();
        if (this$serverNonce == null ? other$serverNonce != null : !((Object)this$serverNonce).equals(other$serverNonce)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResults(), other.getResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivateSessionResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        ByteString $serverNonce = this.getServerNonce();
        result = result * 59 + ($serverNonce == null ? 43 : ((Object)$serverNonce).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getResults());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "ActivateSessionResponse(responseHeader=" + this.getResponseHeader() + ", serverNonce=" + this.getServerNonce() + ", results=" + Arrays.deepToString(this.getResults()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ")";
    }

    private static final class ActivateSessionResponseBuilderImpl
    extends ActivateSessionResponseBuilder<ActivateSessionResponse, ActivateSessionResponseBuilderImpl> {
        private ActivateSessionResponseBuilderImpl() {
        }

        @Override
        protected ActivateSessionResponseBuilderImpl self() {
            return this;
        }

        @Override
        public ActivateSessionResponse build() {
            return new ActivateSessionResponse(this);
        }
    }

    public static abstract class ActivateSessionResponseBuilder<C extends ActivateSessionResponse, B extends ActivateSessionResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private ByteString serverNonce;
        private StatusCode[] results;
        private DiagnosticInfo[] diagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ActivateSessionResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ActivateSessionResponse instance, ActivateSessionResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.serverNonce(instance.serverNonce);
            b.results(instance.results);
            b.diagnosticInfos(instance.diagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B serverNonce(ByteString serverNonce) {
            this.serverNonce = serverNonce;
            return (B)this.self();
        }

        public B results(StatusCode[] results) {
            this.results = results;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ActivateSessionResponse.ActivateSessionResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", serverNonce=" + this.serverNonce + ", results=" + Arrays.deepToString(this.results) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ActivateSessionResponse> {
        @Override
        public Class<ActivateSessionResponse> getType() {
            return ActivateSessionResponse.class;
        }

        @Override
        public ActivateSessionResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            ByteString serverNonce = decoder.readByteString("ServerNonce");
            StatusCode[] results = decoder.readStatusCodeArray("Results");
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new ActivateSessionResponse(responseHeader, serverNonce, results, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ActivateSessionResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeByteString("ServerNonce", value.getServerNonce());
            encoder.writeStatusCodeArray("Results", value.getResults());
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

