/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.nature;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.systemmanagement.Messages;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class FordiacNature
implements IProjectNature {
    public static final int MISSING_XTEXT_NATURE = 1;
    public static final int MISSING_EXPORT_BUILDER = 2;
    public static final int MISSING_LIBRARY_BUILDER = 3;
    private IProject project;

    public void configure() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        boolean changed = false;
        changed |= FordiacNature.configureXtextNature(description);
        changed |= FordiacNature.configureLibraryBuilder(description);
        if (changed |= FordiacNature.configureExportBuilder(description)) {
            this.project.setDescription(description, null);
        }
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        if (FordiacNature.deconfigureLibraryBuilder(description) || FordiacNature.deconfigureExportBuilder(description)) {
            this.project.setDescription(description, null);
        }
        this.project.deleteMarkers("org.eclipse.fordiac.ide.model.problem", true, 2);
    }

    public static boolean configureXtextNature(IProjectDescription description) {
        if (!description.hasNature("org.eclipse.xtext.ui.shared.xtextNature")) {
            String[] natures = description.getNatureIds();
            String[] newNatures = Arrays.copyOf(natures, natures.length + 1);
            newNatures[natures.length] = "org.eclipse.xtext.ui.shared.xtextNature";
            description.setNatureIds(newNatures);
            return true;
        }
        return false;
    }

    public static boolean configureExportBuilder(IProjectDescription description) {
        ICommand[] commands = description.getBuildSpec();
        if (Stream.of(commands).noneMatch(FordiacNature::isExportBuilderCommand)) {
            ICommand[] newCommands = Arrays.copyOf(commands, commands.length + 1);
            ICommand command = description.newCommand();
            command.setBuilderName("org.eclipse.fordiac.ide.export.builder");
            newCommands[commands.length] = command;
            description.setBuildSpec(newCommands);
            return true;
        }
        return false;
    }

    public static boolean deconfigureExportBuilder(IProjectDescription description) {
        ICommand[] commands = description.getBuildSpec();
        ICommand[] newCommands = (ICommand[])Stream.of(commands).filter(Predicate.not(FordiacNature::isExportBuilderCommand)).toArray(ICommand[]::new);
        if (newCommands.length != commands.length) {
            description.setBuildSpec(newCommands);
            return true;
        }
        return false;
    }

    public static boolean configureLibraryBuilder(IProjectDescription description) {
        ICommand[] commands = description.getBuildSpec();
        if (Stream.of(commands).noneMatch(FordiacNature::isLibraryBuilderCommand)) {
            ICommand[] newCommands = Arrays.copyOf(commands, commands.length + 1);
            ICommand command = description.newCommand();
            command.setBuilderName("org.eclipse.fordiac.ide.library.builder");
            newCommands[commands.length] = command;
            description.setBuildSpec(newCommands);
            return true;
        }
        return false;
    }

    public static boolean deconfigureLibraryBuilder(IProjectDescription description) {
        ICommand[] commands = description.getBuildSpec();
        ICommand[] newCommands = (ICommand[])Stream.of(commands).filter(Predicate.not(FordiacNature::isLibraryBuilderCommand)).toArray(ICommand[]::new);
        if (newCommands.length != commands.length) {
            description.setBuildSpec(newCommands);
            return true;
        }
        return false;
    }

    public void validate() throws CoreException {
        ArrayList<ErrorMarkerBuilder> builders = new ArrayList<ErrorMarkerBuilder>();
        if (!this.project.hasNature("org.eclipse.xtext.ui.shared.xtextNature")) {
            builders.add(ErrorMarkerBuilder.createErrorMarkerBuilder((String)MessageFormat.format(Messages.FordiacNature_MissingXtextNature, this.project.getName())).setType("org.eclipse.fordiac.ide.model.projectConfiguration").setLocation(Messages.FordiacNature_Location).setSource(this.getClass().getName()).setCode(1));
        }
        if (!this.hasProjectBuilderCommands()) {
            builders.add(ErrorMarkerBuilder.createErrorMarkerBuilder((String)MessageFormat.format(Messages.FordiacNature_MissingLibraryBuilder, this.project.getName())).setType("org.eclipse.fordiac.ide.model.projectConfiguration").setLocation(Messages.FordiacNature_Location).setSource(this.getClass().getName()).setCode(3));
        }
        if (!this.hasExportBuilderCommand()) {
            builders.add(ErrorMarkerBuilder.createErrorMarkerBuilder((String)MessageFormat.format(Messages.FordiacNature_MissingExportBuilder, this.project.getName())).setType("org.eclipse.fordiac.ide.model.projectConfiguration").setLocation(Messages.FordiacNature_Location).setSource(this.getClass().getName()).setCode(2));
        }
        FordiacMarkerHelper.updateMarkers((IResource)this.project, (String)"org.eclipse.fordiac.ide.model.projectConfiguration", builders, (boolean)true);
    }

    public boolean hasExportBuilderCommand() throws CoreException {
        return Stream.of(this.project.getDescription().getBuildSpec()).anyMatch(FordiacNature::isExportBuilderCommand);
    }

    protected static boolean isExportBuilderCommand(ICommand command) {
        return "org.eclipse.fordiac.ide.export.builder".equals(command.getBuilderName());
    }

    public boolean hasProjectBuilderCommands() throws CoreException {
        return Stream.of(this.project.getDescription().getBuildSpec()).anyMatch(FordiacNature::isLibraryBuilderCommand);
    }

    protected static boolean isLibraryBuilderCommand(ICommand command) {
        return "org.eclipse.fordiac.ide.library.builder".equals(command.getBuilderName());
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        try {
            this.validate();
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }
}

