/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextfunctioneditor.util;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.STFunction;
import org.eclipse.fordiac.ide.model.libraryElement.STFunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartition;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreReconciler;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.util.STFunctionPartition;

public class STFunctionReconciler
implements STCoreReconciler {
    private static final String DEFAULT_INPUT_EVENT_NAME = "REQ";
    private static final String DEFAULT_OUTPUT_EVENT_NAME = "CNF";

    public void reconcile(LibraryElement dest, Optional<? extends STCorePartition> source) {
        if (dest instanceof FunctionFBType) {
            STCorePartition sTCorePartition;
            FunctionFBType functionFbType = (FunctionFBType)dest;
            if (source.isPresent() && (sTCorePartition = source.get()) instanceof STFunctionPartition) {
                STFunctionPartition stFunctionPartition = (STFunctionPartition)sTCorePartition;
                STFunctionReconciler.reconcile(functionFbType, stFunctionPartition);
            }
        }
    }

    protected static void reconcile(FunctionFBType dest, STFunctionPartition source) {
        if (STFunctionReconciler.checkDuplicates(source.getFunctions())) {
            return;
        }
        CompilerInfo compilerInfo = dest.getCompilerInfo();
        if (compilerInfo == null) {
            compilerInfo = LibraryElementFactory.eINSTANCE.createCompilerInfo();
            dest.setCompilerInfo(compilerInfo);
        }
        compilerInfo.setPackageName(source.getPackageName());
        ECollections.setEList((EList)compilerInfo.getImports(), (List)source.getImports());
        STFunctionBody body = LibraryElementFactory.eINSTANCE.createSTFunctionBody();
        body.setText(source.getOriginalSource());
        dest.setBody((FunctionBody)body);
        STFunctionReconciler.reconcileType(dest, source);
    }

    protected static void reconcileType(FunctionFBType dest, STFunctionPartition source) {
        STFunctionReconciler.findPrimaryFunction(dest, source).ifPresent(function -> STFunctionReconciler.reconcileType(dest, function));
    }

    protected static void reconcileType(FunctionFBType dest, STFunction source) {
        dest.setComment(source.getComment());
        STFunctionReconciler.reconcileInterface(dest.getInterfaceList(), source);
    }

    protected static void reconcileInterface(InterfaceList interfaceList, STFunction source) {
        ECollections.setEList((EList)interfaceList.getEventInputs(), List.of(STFunctionReconciler.createEvent(DEFAULT_INPUT_EVENT_NAME, true)));
        ECollections.setEList((EList)interfaceList.getEventOutputs(), List.of(STFunctionReconciler.createEvent(DEFAULT_OUTPUT_EVENT_NAME, false)));
        ECollections.setEList((EList)interfaceList.getInputVars(), source.getInputParameters().stream().map(VarDeclaration.class::cast).map(EcoreUtil::copy).toList());
        ECollections.setEList((EList)interfaceList.getOutputVars(), source.getOutputParameters().stream().map(VarDeclaration.class::cast).map(EcoreUtil::copy).toList());
        ECollections.setEList((EList)interfaceList.getInOutVars(), source.getInOutParameters().stream().map(VarDeclaration.class::cast).map(EcoreUtil::copy).toList());
        if (source.getReturnType() != null) {
            VarDeclaration returnVar = LibraryElementFactory.eINSTANCE.createVarDeclaration();
            returnVar.setName("");
            returnVar.setType(source.getReturnType());
            interfaceList.getOutputVars().add(0, (Object)returnVar);
        }
        STFunctionReconciler.addWiths((Event)interfaceList.getEventInputs().get(0), Stream.concat(interfaceList.getInputVars().stream(), interfaceList.getInOutVars().stream()));
        STFunctionReconciler.addWiths((Event)interfaceList.getEventOutputs().get(0), Stream.concat(interfaceList.getOutputVars().stream(), interfaceList.getOutMappedInOutVars().stream()));
    }

    protected static Event createEvent(String name, boolean input) {
        Event event = LibraryElementFactory.eINSTANCE.createEvent();
        event.setName(name);
        event.setType((DataType)EventTypeLibrary.getInstance().getType(null));
        event.setIsInput(input);
        return event;
    }

    protected static void addWiths(Event event, Stream<VarDeclaration> withs) {
        withs.forEach(variable -> {
            With with = STFunctionReconciler.addWith(event, variable);
        });
    }

    private static With addWith(Event event, VarDeclaration variable) {
        With with = LibraryElementFactory.eINSTANCE.createWith();
        event.getWith().add((Object)with);
        with.setVariables(variable);
        return with;
    }

    protected static Optional<STFunction> findPrimaryFunction(FunctionFBType dest, STFunctionPartition source) {
        return source.getFunctions().stream().filter(callable -> dest.getName().equals(callable.getName())).findFirst().or(source.getFunctions().stream().filter(callable -> !callable.getName().startsWith("LOST_AND_FOUND"))::findFirst);
    }

    protected static boolean checkDuplicates(List<? extends ICallable> list) {
        return list.stream().map(INamedElement::getName).distinct().count() != (long)list.size();
    }
}

