/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.editor;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.LanguageSpecificURIEditorOpener;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class STCoreURIEditorOpener
extends LanguageSpecificURIEditorOpener {
    private static final Logger logger = Logger.getLogger(LanguageSpecificURIEditorOpener.class);
    @Inject
    private IStorage2UriMapper mapper;
    @Inject(optional=true)
    private IWorkbench workbench;
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public IEditorPart open(URI uri, EReference crossReference, int indexInList, boolean select) {
        Iterator storages = this.mapper.getStorages(uri.trimFragment()).iterator();
        if (storages != null && storages.hasNext()) {
            try {
                IStorage storage = (IStorage)((Pair)storages.next()).getFirst();
                IEditorInput editorInput = EditorUtils.createEditorInput((IStorage)storage);
                IWorkbenchPage activePage = this.workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)editorInput, (String)this.getEditorId(uri), (boolean)select);
                this.selectAndReveal(editor, uri, crossReference, indexInList, select);
                return EditorUtils.getXtextEditor((IEditorPart)editor);
            }
            catch (WrappedException e) {
                logger.error((Object)("Error while opening editor part for EMF URI '" + String.valueOf(uri) + "'"), e.getCause());
            }
            catch (PartInitException partInitException) {
                logger.error((Object)("Error while opening editor part for EMF URI '" + String.valueOf(uri) + "'"), (Throwable)partInitException);
            }
        }
        return null;
    }

    protected String getEditorId(URI uri) {
        if (uri.fileExtension() == null || this.fileExtensionProvider.getPrimaryFileExtension().equals(uri.fileExtension())) {
            return super.getEditorId();
        }
        return "org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeEditor";
    }
}

