/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public final class DateValueConverter
implements ValueConverter<LocalDate> {
    public static final DateValueConverter INSTANCE = new DateValueConverter();
    private static final Pattern SCANNER_PATTERN = Pattern.compile("\\G\\d[_\\d]++-\\d[_\\d]++-\\d[_\\d]++");

    private DateValueConverter() {
    }

    @Override
    public LocalDate toValue(String string) throws IllegalArgumentException {
        if (string.indexOf("__") != -1) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_CONSECUTIVE_UNDERSCORES_ERROR_MESSAGE, string));
        }
        try {
            return LocalDate.parse(string.replace("_", ""));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_INVALID_DATE_FORMAT, string), e);
        }
    }

    @Override
    public LocalDate toValue(Scanner scanner) throws IllegalArgumentException {
        return (LocalDate)this.toValue(scanner, SCANNER_PATTERN);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

