/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.Collections;
import java.util.List;
import org.eclipse.fordiac.ide.gef.nat.FBColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.TypedElementConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.TypedElementTableColumn;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.gef.properties.BaseFBFilter;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInternalFBOrderCommand;
import org.eclipse.fordiac.ide.model.commands.change.IndexUpDown;
import org.eclipse.fordiac.ide.model.commands.create.CreateInternalFBCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInternalFBCommand;
import org.eclipse.fordiac.ide.model.commands.insert.InsertFBCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.ui.nat.FBTreeNodeLabelProvider;
import org.eclipse.fordiac.ide.model.ui.nat.FBTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.nat.TypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.FBTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionButton;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderToolbarWidget;
import org.eclipse.fordiac.ide.ui.widget.ChangeableListDataProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.I4diacNatTableUtil;
import org.eclipse.fordiac.ide.ui.widget.IChangeableRowDataProvider;
import org.eclipse.fordiac.ide.ui.widget.ISelectionProviderSection;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.selection.RowPostSelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class InternalFbsSection
extends AbstractSection
implements I4diacNatTableUtil,
ISelectionProviderSection {
    protected IChangeableRowDataProvider<FB> provider;
    protected NatTable table;
    private RowPostSelectionProvider<FB> selectionProvider;
    private AddDeleteReorderToolbarWidget buttons;

    protected BaseFBType getType() {
        return (BaseFBType)this.type;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createInternalFbsControls(parent);
    }

    public void createInternalFbsControls(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttons = new AddDeleteReorderToolbarWidget();
        this.buttons.createControls(composite, (FormToolkit)this.getWidgetFactory());
        this.provider = new ChangeableListDataProvider((IColumnAccessor)new FBColumnAccessor(this));
        DataLayer dataLayer = new DataLayer(this.provider);
        dataLayer.setConfigLabelAccumulator(new TypedElementConfigLabelAccumulator<FB>((IRowDataProvider<FB>)this.provider, this::getAnnotationModel));
        this.table = NatTableWidgetFactory.createRowNatTable((Composite)composite, (DataLayer)dataLayer, (IDataProvider)new NatTableColumnProvider(TypedElementTableColumn.DEFAULT_COLUMNS), (IEditableRule)IEditableRule.ALWAYS_EDITABLE, (ICellEditor)new TypeSelectionButton(this::getTypeLibrary, (ITypeSelectionContentProvider)FBTypeSelectionContentProvider.INSTANCE, (TypeSelectionTreeContentProvider)FBTypeSelectionTreeContentProvider.INSTANCE, (DelegatingStyledCellLabelProvider.IStyledLabelProvider)FBTreeNodeLabelProvider.INSTANCE), (I4diacNatTableUtil)this, (boolean)false);
        this.table.configure();
        this.buttons.bindToTableViewer(this.table, (CommandExecutor)this, ref -> new CreateInternalFBCommand(this.getType(), this.getInsertionIndex(), this.getName(), this.getFBTypeEntry()), ref -> new DeleteInternalFBCommand((FB)ref), ref -> new ChangeInternalFBOrderCommand(this.getType(), (FB)ref, IndexUpDown.UP), ref -> new ChangeInternalFBOrderCommand(this.getType(), (FB)ref, IndexUpDown.DOWN));
        this.selectionProvider = new RowPostSelectionProvider(this.table, NatTableWidgetFactory.getSelectionLayer((NatTable)this.table), this.provider, false);
    }

    private FBTypeEntry getFBTypeEntry() {
        FB fb = this.getLastSelectedFB();
        return fb != null ? (FBTypeEntry)fb.getTypeEntry() : null;
    }

    private String getName() {
        FB fb = this.getLastSelectedFB();
        return fb != null ? fb.getName() : null;
    }

    private int getInsertionIndex() {
        FB fb = this.getLastSelectedFB();
        if (fb == null) {
            return this.getType().getInternalFbs().size();
        }
        return this.getType().getInternalFbs().indexOf((Object)fb) + 1;
    }

    private FB getLastSelectedFB() {
        return (FB)NatTableWidgetFactory.getLastSelectedVariable((NatTable)this.table);
    }

    public void addEntry(Object entry, boolean isInput, int index, CompoundCommand cmd) {
        if (entry instanceof FB) {
            FB fb = (FB)entry;
            cmd.add((Command)new InsertFBCommand(this.getType(), fb, index));
        }
    }

    @Override
    protected void performRefresh() {
        this.provider.setInput(this.getType() != null ? this.getType().getInternalFbs() : Collections.emptyList());
        this.table.refresh();
    }

    @Override
    protected void performRefreshAnnotations() {
        this.table.refresh(false);
    }

    public void executeCompoundCommand(CompoundCommand cmd) {
        this.executeCommand((Command)cmd);
        this.table.refresh();
    }

    public boolean isEditable() {
        return true;
    }

    @Override
    protected Object getInputType(Object input) {
        return BaseFBFilter.getFBTypeFromSelectedElement(input);
    }

    @Override
    protected void setInputCode() {
    }

    @Override
    protected void setInputInit() {
        BaseFBType currentType = this.getType();
        this.provider.setInput((List)(currentType != null ? currentType.getInternalFbs() : Collections.emptyList()));
        this.table.refresh();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.buttons != null) {
            this.buttons.dispose();
        }
    }

    public void removeEntry(Object entry, CompoundCommand cmd) {
        if (entry instanceof FB) {
            FB fb = (FB)entry;
            cmd.add((Command)new DeleteInternalFBCommand(fb));
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }
}

