/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.osgi.service.prefs.BackingStoreException;

public class PaletteFlyoutPreferences
implements FlyoutPaletteComposite.FlyoutPreferences {
    private static final int INITIAL_PALETTE_SIZE = 200;
    private final String paletteDockLocationID;
    private final String paletteSizeID;
    private final String paletteStateID;

    public PaletteFlyoutPreferences(String paletteDockLocationID, String paletteSizeID, String paletteStateID) {
        this.paletteDockLocationID = paletteDockLocationID;
        this.paletteSizeID = paletteSizeID;
        this.paletteStateID = paletteStateID;
        this.checkPreferenceStoreStatus();
    }

    public int getDockLocation() {
        return Platform.getPreferencesService().getInt("org.eclipse.fordiac.ide.gef", this.paletteDockLocationID, 0, null);
    }

    public int getPaletteState() {
        return Platform.getPreferencesService().getInt("org.eclipse.fordiac.ide.gef", this.paletteStateID, 0, null);
    }

    public int getPaletteWidth() {
        return Platform.getPreferencesService().getInt("org.eclipse.fordiac.ide.gef", this.paletteSizeID, 0, null);
    }

    public void setDockLocation(int location) {
        PaletteFlyoutPreferences.setValue(this.paletteDockLocationID, location);
    }

    public void setPaletteState(int state) {
        PaletteFlyoutPreferences.setValue(this.paletteStateID, state);
    }

    public void setPaletteWidth(int width) {
        PaletteFlyoutPreferences.setValue(this.paletteSizeID, width);
    }

    private static void setValue(String valueID, int value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.fordiac.ide.gef");
        prefs.putInt(valueID, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            FordiacLogHelper.logError((String)Messages.HandlerPreferenceSafeError, (Throwable)e);
        }
    }

    private void checkPreferenceStoreStatus() {
        if (Platform.getPreferencesService().getString("org.eclipse.fordiac.ide.gef", this.paletteStateID, null, null) == null) {
            this.setPaletteState(4);
            this.setPaletteWidth(200);
        }
    }
}

